/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.roadsigns;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.openstreetmap.josm.plugins.roadsigns.ParametrizedString;
import org.openstreetmap.josm.plugins.roadsigns.RoadSignsPlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class Sign {
    public String id;
    public ParametrizedString ref;
    public ParametrizedString traffic_sign_tag;
    public String iconURL;
    public ImageIcon icon;
    public ImageIcon disabledIcon;
    public String name;
    public String long_name;
    public List<Tag> tags = new ArrayList<Tag>();
    public List<Sign> supplements = new ArrayList<Sign>();
    public List<SignParameter> params = new ArrayList<SignParameter>();
    public boolean isSupplementing;
    public String loc_wiki;
    public String wiki;
    public String help;
    public Boolean useful;
    public JLabel label;

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = new ImageProvider(this.iconURL).setDirs(RoadSignsPlugin.iconDirs).setId("plugin.sign." + this.id).setOptional(true).get();
        }
        return this.icon;
    }

    public String getDefaultRef() {
        if (this.ref == null) {
            return null;
        }
        String r = this.ref.toString();
        if ((r = r.replaceAll("\\[.*\\]", "")).startsWith("DE:")) {
            r = r.replaceAll("DE:", "");
            Pattern p1 = Pattern.compile("^\\d{3}(\\D|$)");
            Matcher m1 = p1.matcher(r);
            if (m1.find()) {
                return I18n.tr((String)"Sign {0}", (Object[])new Object[]{r});
            }
            Pattern p2 = Pattern.compile("^\\d{4}(\\D|$)");
            Matcher m2 = p2.matcher(r);
            if (m2.find()) {
                return I18n.tr((String)"Additional sign {0}", (Object[])new Object[]{r});
            }
            return null;
        }
        return null;
    }

    public boolean isUseful() {
        if (this.useful != null) {
            return this.useful;
        }
        return !this.tags.isEmpty();
    }

    public String toString() {
        return this.id + " - " + this.name;
    }

    public static class SignParameter {
        public String ident;
        public Input input;
        String deflt;
        String prefix;
        String suffix;
        Integer fieldWidth;

        public SignParameter(String inputType) {
            if (inputType.equals("textfield")) {
                this.input = Input.TEXTFIELD;
            } else if (inputType.equals("combo")) {
                this.input = Input.COMBO;
            } else {
                throw new IllegalArgumentException("unknown input type: " + inputType);
            }
        }

        public String getDefault() {
            return this.deflt == null ? "" : this.deflt;
        }

        public String getPrefix() {
            return this.prefix == null ? "" : this.prefix;
        }

        public String getSuffix() {
            return this.suffix == null ? "" : this.suffix;
        }

        public static enum Input {
            TEXTFIELD,
            COMBO;

        }
    }

    public static class Tag {
        public ParametrizedString key;
        public ParametrizedString value;
        public String ident;
        public String tag_ref;
        public ParametrizedString append_value;
        public ParametrizedString condition;

        public String toString() {
            return "<TAG key=" + String.valueOf(this.key) + " value=" + String.valueOf(this.value) + " ident=" + this.ident + " tag_ref=" + this.tag_ref + " append_value=" + String.valueOf(this.append_value) + " condition=" + String.valueOf(this.condition) + ">";
        }
    }
}

