/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.PluginInformation;
import reverter.RevertChangesetCommand;
import reverter.ReverterPlugin;

public class ReverterUploadHook
implements UploadHook {
    final String pluginString;

    public ReverterUploadHook(PluginInformation info) {
        this.pluginString = "reverter_plugin/" + info.version;
    }

    public void modifyChangesetTags(Map<String, String> tags) {
        if (ReverterPlugin.reverterUsed.get()) {
            for (Command cmd : UndoRedoHandler.getInstance().getUndoCommands()) {
                if (!Objects.equals(MainApplication.getLayerManager().getEditDataSet(), cmd.getAffectedDataSet()) || !ReverterUploadHook.isReverterCmd(cmd)) continue;
                tags.merge("created_by", this.pluginString, (oldValue, value) -> String.join((CharSequence)";", value, oldValue));
                break;
            }
        }
    }

    private static boolean isReverterCmd(Command cmd) {
        if (cmd instanceof RevertChangesetCommand) {
            return true;
        }
        if (cmd instanceof SequenceCommand) {
            return ((SequenceCommand)cmd).getLastCommand() instanceof RevertChangesetCommand;
        }
        return false;
    }
}

