/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib.utils;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private final InputStream inputStream;
    private long bytesRead;
    private long mark;

    public CountingInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        int read = this.inputStream.read();
        if (read != -1) {
            ++this.bytesRead;
        }
        return read;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int read = this.inputStream.read(bytes);
        if (read != -1) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int read = this.inputStream.read(bytes, off, len);
        if (read != -1) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        byte[] allBytes = this.inputStream.readAllBytes();
        this.bytesRead += (long)allBytes.length;
        return allBytes;
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        byte[] nBytes = this.inputStream.readNBytes(len);
        this.bytesRead += (long)nBytes.length;
        return nBytes;
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        int read = this.inputStream.readNBytes(b, off, len);
        if (read != -1) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long read = this.inputStream.skip(n);
        this.bytesRead += read;
        return read;
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        this.inputStream.skipNBytes(n);
        this.bytesRead += n;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.inputStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
        this.mark = this.bytesRead;
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
        this.bytesRead = this.mark;
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

