/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class Http2Client
extends HttpClient {
    private static final Map<Duration, java.net.http.HttpClient> clientForConnectTimeout = new ConcurrentHashMap<Duration, java.net.http.HttpClient>();
    private static final String USER_AGENT_STRING = "User-Agent";
    private HttpRequest request;
    private HttpResponse<InputStream> response;

    Http2Client(URL url, String requestMethod) {
        super(url, requestMethod);
    }

    protected void setupConnection(ProgressMonitor progressMonitor) throws IOException {
        this.request = this.createRequest();
        this.notifyConnect(progressMonitor);
        if (this.requiresBody()) {
            this.logRequestBody();
        }
    }

    HttpRequest createRequest() throws IOException {
        HttpRequest.Builder requestBuilder;
        Map headers = this.getHeaders();
        try {
            requestBuilder = HttpRequest.newBuilder().uri(this.getURL().toURI()).method(this.getRequestMethod(), this.hasRequestBody() ? HttpRequest.BodyPublishers.ofByteArray(this.getRequestBody()) : HttpRequest.BodyPublishers.noBody()).header(USER_AGENT_STRING, headers.getOrDefault(USER_AGENT_STRING, Version.getInstance().getFullAgentString()));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        int timeout = this.getReadTimeout();
        if (timeout > 0) {
            requestBuilder.timeout(Duration.ofMillis(timeout));
        }
        if (this.getIfModifiedSince() > 0L) {
            requestBuilder.header("If-Modified-Since", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.getIfModifiedSince()), ZoneId.systemDefault())));
        }
        if (!this.isUseCache()) {
            requestBuilder.header("Cache-Control", "no-cache");
        }
        for (Map.Entry header : headers.entrySet()) {
            if (header.getValue() == null || USER_AGENT_STRING.equals(header.getKey())) continue;
            try {
                requestBuilder.header((String)header.getKey(), (String)header.getValue());
            }
            catch (IllegalArgumentException e) {
                Logging.warn((String)e.getMessage());
            }
        }
        return requestBuilder.build();
    }

    protected HttpClient.ConnectionResponse performConnection() throws IOException {
        java.net.http.HttpClient client = clientForConnectTimeout.computeIfAbsent(Duration.ofMillis(this.getConnectTimeout()), timeout -> java.net.http.HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).connectTimeout((Duration)timeout).build());
        try {
            this.response = client.send(this.request, HttpResponse.BodyHandlers.ofInputStream());
            return new HttpClient.ConnectionResponse(){

                public String getResponseVersion() {
                    return Http2Client.this.response.version().name();
                }

                public int getResponseCode() throws IOException {
                    return Http2Client.this.response.statusCode();
                }

                public long getContentLengthLong() {
                    return Http2Client.this.response.headers().firstValueAsLong("Content-Length").orElse(-1L);
                }

                public Map<String, List<String>> getHeaderFields() {
                    return Http2Client.this.response.headers().map();
                }

                public String getHeaderField(String name) {
                    String list = String.join((CharSequence)",", Http2Client.this.response.headers().allValues(name));
                    return list.isEmpty() ? null : list;
                }
            };
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected HttpClient.Response buildResponse(ProgressMonitor progressMonitor) throws IOException {
        return new Http2Response(this.response, progressMonitor);
    }

    protected void performDisconnection() throws IOException {
    }

    public void disconnect() {
    }

    public static final class Http2Response
    extends HttpClient.Response {
        private final HttpResponse<InputStream> response;

        public Http2Response(HttpResponse<InputStream> response, ProgressMonitor progressMonitor) throws IOException {
            super(progressMonitor, response.statusCode(), null);
            this.response = Objects.requireNonNull(response);
            this.debugRedirect();
        }

        public URL getURL() {
            try {
                return this.response.uri().toURL();
            }
            catch (MalformedURLException e) {
                throw new JosmRuntimeException((Throwable)e);
            }
        }

        public String getRequestMethod() {
            return this.response.request().method();
        }

        protected InputStream getInputStream() throws IOException {
            return this.response.body();
        }

        public String getContentEncoding() {
            return this.response.headers().firstValue("Content-Encoding").orElse(null);
        }

        public String getContentType() {
            return this.response.headers().firstValue("Content-Type").orElse(null);
        }

        public long getExpiration() {
            return Http2Response.parseDate(this.response.headers().firstValue("Expires").orElse(null));
        }

        public long getLastModified() {
            return Http2Response.parseDate(this.response.headers().firstValue("Last-Modified").orElse(null));
        }

        static long parseDate(String string) {
            if (string != null) {
                try {
                    return DateTimeFormatter.RFC_1123_DATE_TIME.parse(string).getLong(ChronoField.INSTANT_SECONDS) * 1000L;
                }
                catch (DateTimeException e) {
                    Logging.debug((Throwable)e);
                }
            }
            return 0L;
        }

        public long getContentLength() {
            return this.response.headers().firstValueAsLong("Content-Length").orElse(-1L);
        }

        public String getHeaderField(String name) {
            String list = String.join((CharSequence)",", this.response.headers().allValues(name));
            return list.isEmpty() ? null : list;
        }

        public Map<String, List<String>> getHeaderFields() {
            return this.response.headers().map();
        }

        public void disconnect() {
            Utils.close((Closeable)this.response.body());
        }
    }
}

