/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photo_geotagging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossy;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;

public final class ExifGPSTagger {
    private ExifGPSTagger() {
    }

    public static void setExifGPSTag(File imageFile, File dst, ImageEntry imageEntry, boolean lossy) throws IOException {
        try {
            ExifGPSTagger.setExifGPSTagWorker(imageFile, dst, imageEntry, lossy);
        }
        catch (ImagingException ire) {
            throw new IOException(I18n.tr((String)("Read/write error: " + ire.getMessage()), (Object[])new Object[0]), ire);
        }
    }

    public static void setExifGPSTagWorker(File imageFile, File dst, ImageEntry imageEntry, boolean lossy) throws IOException {
        TiffOutputSet outputSet = null;
        ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
        if (metadata instanceof JpegImageMetadata) {
            TiffImageMetadata exif = ((JpegImageMetadata)metadata).getExif();
            if (null != exif) {
                outputSet = exif.getOutputSet();
            }
        } else if (metadata instanceof TiffImageMetadata) {
            outputSet = ((TiffImageMetadata)metadata).getOutputSet();
        }
        if (null == outputSet) {
            outputSet = new TiffOutputSet();
        }
        TiffOutputDirectory gpsDirectory = outputSet.getOrCreateGpsDirectory();
        gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_VERSION_ID);
        gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_VERSION_ID, new byte[]{2, 3, 0, 0});
        if (imageEntry.getGpsInstant() != null) {
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            calendar.setTimeInMillis(imageEntry.getGpsInstant().toEpochMilli());
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            DecimalFormat yearFormatter = new DecimalFormat("0000");
            DecimalFormat monthFormatter = new DecimalFormat("00");
            DecimalFormat dayFormatter = new DecimalFormat("00");
            String yearStr = yearFormatter.format(year);
            String monthStr = monthFormatter.format(month);
            String dayStr = dayFormatter.format(day);
            String dateStamp = yearStr + ":" + monthStr + ":" + dayStr;
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_TIME_STAMP);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_TIME_STAMP, new RationalNumber[]{RationalNumber.valueOf((double)hour), RationalNumber.valueOf((double)minute), RationalNumber.valueOf((double)second)});
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_DATE_STAMP);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_DATE_STAMP, new String[]{dateStamp});
        }
        outputSet.setGpsInDegrees(imageEntry.getPos().lon(), imageEntry.getPos().lat());
        if (imageEntry.getSpeed() != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_SPEED_REF);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_SPEED_REF, new String[]{"K"});
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_SPEED);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_SPEED, RationalNumber.valueOf((double)imageEntry.getSpeed()));
        }
        if (imageEntry.getElevation() != null) {
            byte eleRef = imageEntry.getElevation() >= 0.0 ? (byte)0 : 1;
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_ALTITUDE_REF);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_ALTITUDE_REF, eleRef);
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_ALTITUDE);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_ALTITUDE, RationalNumber.valueOf((double)Math.abs(imageEntry.getElevation())));
        }
        if (imageEntry.getExifImgDir() != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF, new String[]{"T"});
            Double imgDir = ExifGPSTagger.checkAngle(imageEntry.getExifImgDir());
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION, RationalNumber.valueOf((double)imgDir));
        }
        if (imageEntry.getExifGpsTrack() != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_TRACK_REF);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_TRACK_REF, new String[]{"T"});
            Double gpsTrack = ExifGPSTagger.checkAngle(imageEntry.getExifGpsTrack());
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_TRACK);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_TRACK, RationalNumber.valueOf((double)gpsTrack));
        }
        if (imageEntry.getGpsDiffMode() != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_DIFFERENTIAL);
            if (imageEntry.getGpsDiffMode().equals(0) || imageEntry.getGpsDiffMode().equals(1)) {
                gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_DIFFERENTIAL, imageEntry.getGpsDiffMode().shortValue());
            }
        }
        if (imageEntry.getGps2d3dMode() != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_MEASURE_MODE);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_MEASURE_MODE, new String[]{imageEntry.getGps2d3dMode().toString()});
        }
        if (imageEntry.getExifGpsProcMethod() != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_PROCESSING_METHOD);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_PROCESSING_METHOD, imageEntry.getExifGpsProcMethod());
        }
        if (imageEntry.getExifGpsDatum() != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_MAP_DATUM);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_MAP_DATUM, new String[]{imageEntry.getExifGpsDatum().toString()});
        }
        if (imageEntry.getExifHPosErr() != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_HOR_POSITIONING_ERROR);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_HOR_POSITIONING_ERROR, RationalNumber.valueOf((double)imageEntry.getExifHPosErr()));
        }
        if (imageEntry.getExifGpsDop() != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_DOP);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_DOP, RationalNumber.valueOf((double)imageEntry.getExifGpsDop()));
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dst));){
            if (metadata instanceof JpegImageMetadata) {
                if (lossy) {
                    new ExifRewriter().updateExifMetadataLossy(imageFile, (OutputStream)os, outputSet);
                } else {
                    new ExifRewriter().updateExifMetadataLossless(imageFile, (OutputStream)os, outputSet);
                }
            } else if (metadata instanceof TiffImageMetadata) {
                new TiffImageWriterLossy().write((OutputStream)os, outputSet);
            }
        }
    }

    private static Double checkAngle(Double angle) {
        if (angle < 0.0) {
            angle = angle % 360.0;
            angle = angle + 360.0;
        }
        if (angle >= 360.0) {
            angle = angle % 360.0;
        }
        return angle;
    }
}

