/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.RowStyle;
import org.jopendocument.dom.spreadsheet.Table;
import org.jopendocument.dom.spreadsheet.TableCalcNode;

public class Row<D extends ODDocument>
extends TableCalcNode<RowStyle, D> {
    private final Table<D> parent;
    private final int index;
    private final List<Cell<D>> cells;

    Row(Table<D> table, Element element, int n) {
        super(table.getODDocument(), element, RowStyle.class);
        this.parent = table;
        this.index = n;
        this.cells = new ArrayList<Cell<D>>();
        for (Element element2 : this.getCellElements()) {
            this.addCellElem(element2);
        }
    }

    protected final Table<D> getSheet() {
        return this.parent;
    }

    final int getY() {
        return this.index;
    }

    private void addCellElem(Element element) {
        Cell cell = new Cell(this, element);
        this.cells.add(cell);
        String string = element.getAttributeValue("number-columns-repeated", this.getSheet().getTABLE());
        if (string != null) {
            int n = Integer.parseInt(string) - 1;
            for (int i = 0; i < n; ++i) {
                this.cells.add(cell);
            }
        }
    }

    private List<Element> getCellElements() {
        return this.getElement().getChildren();
    }

    protected final Cell<D> getCellAt(int n) {
        return this.cells.get(n);
    }
}

