/*
 * Decompiled with CFR 0.152.
 */
package org.j7zip.SevenZip.Archive.SevenZip;

import java.io.IOException;
import org.j7zip.Common.ObjectVector;
import org.j7zip.SevenZip.Archive.IArchiveExtractCallback;
import org.j7zip.SevenZip.Archive.IInArchive;
import org.j7zip.SevenZip.Archive.SevenZip.AltCoderInfo;
import org.j7zip.SevenZip.Archive.SevenZip.ArchiveDatabaseEx;
import org.j7zip.SevenZip.Archive.SevenZip.CoderInfo;
import org.j7zip.SevenZip.Archive.SevenZip.Decoder;
import org.j7zip.SevenZip.Archive.SevenZip.ExtractFolderInfo;
import org.j7zip.SevenZip.Archive.SevenZip.FileItem;
import org.j7zip.SevenZip.Archive.SevenZip.Folder;
import org.j7zip.SevenZip.Archive.SevenZip.FolderOutStream;
import org.j7zip.SevenZip.Archive.SevenZip.InArchive;
import org.j7zip.SevenZip.Archive.SevenZip.MethodID;
import org.j7zip.SevenZip.Archive.SevenZipEntry;
import org.j7zip.SevenZip.Common.LocalCompressProgressInfo;
import org.j7zip.SevenZip.Common.LocalProgress;
import org.j7zip.SevenZip.IInStream;

public class Handler
implements IInArchive {
    IInStream _inStream;
    ArchiveDatabaseEx _database = new ArchiveDatabaseEx();

    @Override
    public int Open(IInStream stream) throws IOException {
        return this.Open(stream, 0x400000L);
    }

    @Override
    public int Open(IInStream stream, long maxCheckStartPosition) throws IOException {
        this.close();
        InArchive archive = new InArchive();
        int ret = archive.Open(stream, maxCheckStartPosition);
        if (ret != 0) {
            return ret;
        }
        ret = archive.ReadDatabase(this._database);
        if (ret != 0) {
            return ret;
        }
        this._database.Fill();
        this._inStream = stream;
        return 0;
    }

    @Override
    public int Extract(int[] indices, int numItems, int testModeSpec, IArchiveExtractCallback extractCallbackSpec) throws IOException {
        boolean allFilesMode;
        boolean testMode = testModeSpec != 0;
        IArchiveExtractCallback extractCallback = extractCallbackSpec;
        long importantTotalUnPacked = 0L;
        boolean bl = allFilesMode = numItems == -1;
        if (allFilesMode) {
            numItems = this._database.Files.size();
        }
        if (numItems == 0) {
            return 0;
        }
        ObjectVector<ExtractFolderInfo> extractFolderInfoVector = new ObjectVector<ExtractFolderInfo>();
        for (int ii = 0; ii < numItems; ++ii) {
            int ref2Index = allFilesMode ? ii : indices[ii];
            ArchiveDatabaseEx database = this._database;
            int fileIndex = ref2Index;
            int folderIndex = database.FileIndexToFolderIndexMap.get(fileIndex);
            if (folderIndex == -1) {
                extractFolderInfoVector.add(new ExtractFolderInfo(fileIndex, -1));
                continue;
            }
            if (extractFolderInfoVector.isEmpty() || folderIndex != ((ExtractFolderInfo)extractFolderInfoVector.Back()).FolderIndex) {
                extractFolderInfoVector.add(new ExtractFolderInfo(-1, folderIndex));
                Folder folderInfo = (Folder)database.Folders.get(folderIndex);
                long unPackSize = folderInfo.GetUnPackSize();
                importantTotalUnPacked += unPackSize;
                ((ExtractFolderInfo)extractFolderInfoVector.Back()).UnPackSize = unPackSize;
            }
            ExtractFolderInfo efi = (ExtractFolderInfo)extractFolderInfoVector.Back();
            int startIndex = database.FolderStartFileIndex.get(folderIndex);
            for (int index = efi.ExtractStatuses.size(); index <= fileIndex - startIndex; ++index) {
                efi.ExtractStatuses.add(index == fileIndex - startIndex);
            }
        }
        extractCallback.SetTotal(importantTotalUnPacked);
        Decoder decoder = new Decoder(false);
        long currentImportantTotalUnPacked = 0L;
        int i = 0;
        while (i < extractFolderInfoVector.size()) {
            long totalFolderUnPacked;
            block20: {
                FolderOutStream folderOutStream;
                ExtractFolderInfo efi = (ExtractFolderInfo)extractFolderInfoVector.get(i);
                totalFolderUnPacked = efi.UnPackSize;
                int res = extractCallback.SetCompleted(currentImportantTotalUnPacked);
                if (res != 0) {
                    return res;
                }
                FolderOutStream outStream = folderOutStream = new FolderOutStream();
                ArchiveDatabaseEx database = this._database;
                int startIndex = efi.FileIndex != -1 ? efi.FileIndex : database.FolderStartFileIndex.get(efi.FolderIndex);
                int result = folderOutStream.Init(database, 0, startIndex, efi.ExtractStatuses, extractCallback, testMode);
                if (result != 0) {
                    return result;
                }
                if (efi.FileIndex == -1) {
                    LocalCompressProgressInfo localCompressProgressSpec;
                    LocalProgress localProgressSpec;
                    int folderIndex = efi.FolderIndex;
                    Folder folderInfo = (Folder)database.Folders.get(folderIndex);
                    LocalProgress progress = localProgressSpec = new LocalProgress();
                    localProgressSpec.Init(extractCallback, false);
                    LocalCompressProgressInfo compressProgress = localCompressProgressSpec = new LocalCompressProgressInfo();
                    localCompressProgressSpec.Init(progress, -1L, currentImportantTotalUnPacked);
                    int packStreamIndex = database.FolderStartPackStreamIndex.get(folderIndex);
                    long folderStartPackPos = database.GetFolderStreamPos(folderIndex, 0);
                    try {
                        result = decoder.Decode(this._inStream, folderStartPackPos, database.PackSizes, packStreamIndex, folderInfo, outStream, compressProgress);
                        if (result == 1) {
                            result = folderOutStream.FlushCorrupted(2);
                            if (result != 0) {
                                return result;
                            }
                        } else if (result == -2147467263) {
                            result = folderOutStream.FlushCorrupted(1);
                            if (result != 0) {
                                return result;
                            }
                        } else {
                            if (result != 0) {
                                return result;
                            }
                            if (folderOutStream.WasWritingFinished() != 0 && (result = folderOutStream.FlushCorrupted(2)) != 0) {
                                return result;
                            }
                        }
                    }
                    catch (Exception e) {
                        System.out.println("IOException : " + String.valueOf(e));
                        e.printStackTrace();
                        result = folderOutStream.FlushCorrupted(2);
                        if (result == 0) break block20;
                        return result;
                    }
                }
            }
            ++i;
            currentImportantTotalUnPacked += totalFolderUnPacked;
        }
        return 0;
    }

    @Override
    public int close() throws IOException {
        if (this._inStream != null) {
            this._inStream.close();
        }
        this._inStream = null;
        this._database.Clear();
        return 0;
    }

    long getPackSize(int index2) {
        long packSize = 0L;
        int folderIndex = this._database.FileIndexToFolderIndexMap.get(index2);
        if (folderIndex != -1 && this._database.FolderStartFileIndex.get(folderIndex) == index2) {
            packSize = this._database.GetFolderFullPackSize(folderIndex);
        }
        return packSize;
    }

    static int GetUInt32FromMemLE(byte[] p, int off) {
        return p[off] | p[off + 1] << 8 | p[off + 2] << 16 | p[off + 3] << 24;
    }

    static String GetStringForSizeValue(int value) {
        for (int i = 31; i >= 0; --i) {
            if (1 << i != value) continue;
            return "" + i;
        }
        Object result = "";
        if (value % 0x100000 == 0) {
            result = (String)result + (value >> 20);
            result = (String)result + "m";
        } else if (value % 1024 == 0) {
            result = (String)result + (value >> 10);
            result = (String)result + "k";
        } else {
            result = (String)result + value;
            result = (String)result + "b";
        }
        return result;
    }

    String getMethods(int index2) {
        String ret = "";
        int folderIndex = this._database.FileIndexToFolderIndexMap.get(index2);
        if (folderIndex != -1) {
            Folder folderInfo = (Folder)this._database.Folders.get(folderIndex);
            Object methodsString = "";
            for (int i = folderInfo.Coders.size() - 1; i >= 0; --i) {
                CoderInfo coderInfo = (CoderInfo)folderInfo.Coders.get(i);
                if (methodsString != "") {
                    methodsString = (String)methodsString + " ";
                }
                for (int j = 0; j < coderInfo.AltCoders.size(); ++j) {
                    if (j > 0) {
                        methodsString = (String)methodsString + "|";
                    }
                    AltCoderInfo altCoderInfo = (AltCoderInfo)coderInfo.AltCoders.get(j);
                    String methodName = "";
                    boolean methodIsKnown = true;
                    if (altCoderInfo.MethodID.equals(MethodID.k_Copy)) {
                        methodName = "Copy";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_LZMA)) {
                        methodName = "LZMA";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_BCJ)) {
                        methodName = "BCJ";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_BCJ2)) {
                        methodName = "BCJ2";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_PPMD)) {
                        methodName = "PPMD";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_Deflate)) {
                        methodName = "Deflate";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_Deflate64)) {
                        methodName = "Deflate64";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_BZip2)) {
                        methodName = "BZip2";
                    } else if (altCoderInfo.MethodID.equals(MethodID.k_7zAES)) {
                        methodName = "7zAES";
                    } else {
                        methodIsKnown = false;
                    }
                    if (!methodIsKnown) continue;
                    methodsString = (String)methodsString + methodName;
                    if (!altCoderInfo.MethodID.equals(MethodID.k_LZMA) || altCoderInfo.Properties.GetCapacity() < 5) continue;
                    methodsString = (String)methodsString + ":";
                    int dicSize = Handler.GetUInt32FromMemLE(altCoderInfo.Properties.data(), 1);
                    methodsString = (String)methodsString + Handler.GetStringForSizeValue(dicSize);
                }
            }
            ret = methodsString;
        }
        return ret;
    }

    @Override
    public SevenZipEntry getEntry(int index) {
        FileItem item = (FileItem)this._database.Files.get(index);
        int index2 = index;
        long crc = -1L;
        if (item.IsFileCRCDefined) {
            crc = (long)item.FileCRC & 0xFFFFFFFFL;
        }
        long position = -1L;
        if (item.IsStartPosDefined) {
            position = item.StartPos;
        }
        SevenZipEntry entry = new SevenZipEntry(item.name, this.getPackSize(index2), item.UnPackSize, crc, item.LastWriteTime, position, item.IsDirectory, item.Attributes, this.getMethods(index2));
        return entry;
    }
}

