/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.seamapeditor.panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.plugins.seamapeditor.SmedAction;
import org.openstreetmap.josm.plugins.seamapeditor.messages.Messages;
import org.openstreetmap.josm.plugins.seamapeditor.seamarks.SeaMark;

public class PanelSpec
extends JPanel {
    private SmedAction dlg;
    public JLabel categoryLabel;
    public JComboBox<String> categoryBox;
    public EnumMap<SeaMark.Cat, Integer> categories = new EnumMap(SeaMark.Cat.class);
    private ActionListener alCategoryBox = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Cat cat : PanelSpec.this.categories.keySet()) {
                int idx = PanelSpec.this.categories.get((Object)cat);
                if (PanelSpec.this.dlg.node == null || idx != PanelSpec.this.categoryBox.getSelectedIndex()) continue;
                SmedAction.panelMain.mark.setCategory(cat);
            }
        }
    };
    public JComboBox<String> mooringBox;
    public EnumMap<SeaMark.Cat, Integer> moorings = new EnumMap(SeaMark.Cat.class);
    private ActionListener alMooringBox = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Cat cat : PanelSpec.this.moorings.keySet()) {
                int idx = PanelSpec.this.moorings.get((Object)cat);
                if (PanelSpec.this.dlg.node == null || idx != PanelSpec.this.mooringBox.getSelectedIndex()) continue;
                SmedAction.panelMain.mark.setCategory(cat);
                if (cat == SeaMark.Cat.INB_CALM || cat == SeaMark.Cat.INB_SBM) {
                    SmedAction.panelMain.mark.setObject(SeaMark.Obj.BOYINB);
                    SmedAction.panelMain.mark.setShape(SeaMark.Shp.UNKSHP);
                    continue;
                }
                SmedAction.panelMain.mark.setObject(SeaMark.Obj.MORFAC);
                if (cat == SeaMark.Cat.MOR_BUOY) continue;
                SmedAction.panelMain.mark.setShape(SeaMark.Shp.UNKSHP);
            }
            if (PanelSpec.this.dlg.node != null) {
                PanelSpec.this.syncPanel();
            }
        }
    };
    public ButtonGroup shapeButtons = new ButtonGroup();
    public JRadioButton pillarButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/PillarButton.png")));
    public JRadioButton sparButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SparButton.png")));
    public JRadioButton canButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/CanButton.png")));
    public JRadioButton coneButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/ConeButton.png")));
    public JRadioButton sphereButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SphereButton.png")));
    public JRadioButton barrelButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BarrelButton.png")));
    public JRadioButton superButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SuperButton.png")));
    public JRadioButton floatButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FloatButton.png")));
    public JRadioButton beaconButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BeaconButton.png")));
    public JRadioButton towerButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/TowerButton.png")));
    public JRadioButton stakeButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/StakeButton.png")));
    public JRadioButton cairnButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/CairnButton.png")));
    public EnumMap<SeaMark.Shp, JRadioButton> shapes = new EnumMap(SeaMark.Shp.class);
    public EnumMap<SeaMark.Shp, SeaMark.Obj> objects = new EnumMap(SeaMark.Shp.class);
    public ActionListener alShape = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SmedAction.panelMain.mark.getObject() != SeaMark.Obj.MORFAC || SmedAction.panelMain.mark.getCategory() == SeaMark.Cat.MOR_BUOY) {
                for (SeaMark.Shp shp : PanelSpec.this.shapes.keySet()) {
                    JRadioButton button = PanelSpec.this.shapes.get((Object)shp);
                    if (button.isSelected()) {
                        SmedAction.panelMain.mark.setShape(shp);
                        if (SeaMark.EntMAP.get((Object)SmedAction.panelMain.mark.getObject()) != SeaMark.Ent.MOORING) {
                            SmedAction.panelMain.mark.setObject(PanelSpec.this.objects.get((Object)shp));
                            if (SmedAction.panelMain.mark.getObjColour(0) == SeaMark.Col.UNKCOL) {
                                SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                                SmedAction.panelMain.mark.setObjColour(SeaMark.Col.YELLOW);
                            }
                            if (button == PanelSpec.this.cairnButton) {
                                SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                                SmedAction.panelMain.mark.setObjColour(SeaMark.Col.UNKCOL);
                            }
                            PanelSpec.this.topmarkButton.setVisible(SmedAction.panelMain.mark.testValid());
                        }
                        button.setBorderPainted(true);
                        continue;
                    }
                    button.setBorderPainted(false);
                }
                SmedAction.panelMain.panelMore.syncPanel();
            }
        }
    };
    public JToggleButton topmarkButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/images/SpecTopButton.png")));
    private ActionListener alTop = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PanelSpec.this.topmarkButton.isSelected()) {
                SmedAction.panelMain.mark.setTopmark(SeaMark.Top.X_SHAPE);
                SmedAction.panelMain.mark.setTopPattern(SeaMark.Pat.NOPAT);
                SmedAction.panelMain.mark.setTopColour(SeaMark.Col.YELLOW);
                PanelSpec.this.topmarkButton.setBorderPainted(true);
            } else {
                SmedAction.panelMain.mark.setTopmark(SeaMark.Top.NOTOP);
                SmedAction.panelMain.mark.setTopPattern(SeaMark.Pat.NOPAT);
                SmedAction.panelMain.mark.setTopColour(SeaMark.Col.UNKCOL);
                PanelSpec.this.topmarkButton.setBorderPainted(false);
            }
            SmedAction.panelMain.panelTop.syncPanel();
        }
    };
    public JToggleButton noticeButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/images/NoticeButton.png")));
    private ActionListener alNotice = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SmedAction.panelMain.mark.clrMark();
            if (PanelSpec.this.noticeButton.isSelected()) {
                SmedAction.panelMain.mark.setObject(SeaMark.Obj.NOTMRK);
                PanelSpec.this.noticeButton.setBorderPainted(true);
            } else {
                SmedAction.panelMain.mark.setObject(SeaMark.Obj.UNKOBJ);
                PanelSpec.this.noticeButton.setBorderPainted(false);
            }
            SmedAction.panelMain.syncPanel();
        }
    };
    public JToggleButton mooringButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/images/MooringButton.png")));
    private ActionListener alMooring = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SmedAction.panelMain.mark.setObject(SeaMark.Obj.UNKOBJ);
            SmedAction.panelMain.mark.setCategory(SeaMark.Cat.NOCAT);
            SmedAction.panelMain.mark.setTopmark(SeaMark.Top.NOTOP);
            if (PanelSpec.this.mooringButton.isSelected()) {
                SmedAction.panelMain.mark.setObject(SeaMark.Obj.MORFAC);
                PanelSpec.this.categoryBox.setVisible(false);
                PanelSpec.this.mooringBox.setVisible(true);
                PanelSpec.this.pillarButton.setEnabled(false);
                PanelSpec.this.sparButton.setEnabled(false);
                PanelSpec.this.beaconButton.setEnabled(false);
                PanelSpec.this.towerButton.setEnabled(false);
                PanelSpec.this.stakeButton.setEnabled(false);
                PanelSpec.this.cairnButton.setEnabled(false);
                PanelSpec.this.mooringButton.setBorderPainted(true);
            } else {
                PanelSpec.this.mooringBox.setVisible(false);
                PanelSpec.this.categoryBox.setVisible(true);
                PanelSpec.this.pillarButton.setEnabled(true);
                PanelSpec.this.sparButton.setEnabled(true);
                PanelSpec.this.beaconButton.setEnabled(true);
                PanelSpec.this.towerButton.setEnabled(true);
                PanelSpec.this.stakeButton.setEnabled(true);
                PanelSpec.this.cairnButton.setEnabled(true);
                PanelSpec.this.mooringButton.setBorderPainted(false);
            }
            PanelSpec.this.syncPanel();
        }
    };

    public PanelSpec(SmedAction dia) {
        this.dlg = dia;
        this.setLayout(null);
        this.add(this.getShapeButton(this.pillarButton, 0, 0, 34, 32, "Pillar", SeaMark.Shp.PILLAR, SeaMark.Obj.BOYSPP));
        this.add(this.getShapeButton(this.sparButton, 34, 0, 34, 32, "Spar", SeaMark.Shp.SPAR, SeaMark.Obj.BOYSPP));
        this.add(this.getShapeButton(this.canButton, 68, 0, 34, 32, "Can", SeaMark.Shp.CAN, SeaMark.Obj.BOYSPP));
        this.add(this.getShapeButton(this.coneButton, 102, 0, 34, 32, "Cone", SeaMark.Shp.CONI, SeaMark.Obj.BOYSPP));
        this.add(this.getShapeButton(this.sphereButton, 0, 32, 34, 32, "Sphere", SeaMark.Shp.SPHERI, SeaMark.Obj.BOYSPP));
        this.add(this.getShapeButton(this.barrelButton, 34, 32, 34, 32, "Barrel", SeaMark.Shp.BARREL, SeaMark.Obj.BOYSPP));
        this.add(this.getShapeButton(this.superButton, 68, 32, 34, 32, "Super", SeaMark.Shp.SUPER, SeaMark.Obj.BOYSPP));
        this.add(this.getShapeButton(this.floatButton, 102, 32, 34, 32, "Float", SeaMark.Shp.FLOAT, SeaMark.Obj.LITFLT));
        this.add(this.getShapeButton(this.beaconButton, 0, 64, 34, 32, "Beacon", SeaMark.Shp.BEACON, SeaMark.Obj.BCNSPP));
        this.add(this.getShapeButton(this.towerButton, 34, 64, 34, 32, "TowerB", SeaMark.Shp.TOWER, SeaMark.Obj.BCNSPP));
        this.add(this.getShapeButton(this.stakeButton, 68, 64, 34, 32, "Stake", SeaMark.Shp.STAKE, SeaMark.Obj.BCNSPP));
        this.add(this.getShapeButton(this.cairnButton, 102, 64, 34, 32, "CairnB", SeaMark.Shp.CAIRN, SeaMark.Obj.BCNSPP));
        this.categoryLabel = new JLabel(Messages.getString("Category"), 0);
        this.categoryLabel.setBounds(new Rectangle(5, 125, 160, 18));
        this.add(this.categoryLabel);
        this.categoryBox = new JComboBox();
        this.categoryBox.setBounds(new Rectangle(5, 142, 160, 18));
        this.add(this.categoryBox);
        this.categoryBox.setVisible(true);
        this.categoryBox.addActionListener(this.alCategoryBox);
        this.addCatItem("", SeaMark.Cat.NOCAT);
        this.addCatItem(Messages.getString("UKPurpose"), SeaMark.Cat.SPM_UNKN);
        this.addCatItem(Messages.getString("Warning"), SeaMark.Cat.SPM_WARN);
        this.addCatItem(Messages.getString("ChanSeparation"), SeaMark.Cat.SPM_CHBF);
        this.addCatItem(Messages.getString("Yachting"), SeaMark.Cat.SPM_YCHT);
        this.addCatItem(Messages.getString("Cable"), SeaMark.Cat.SPM_CABL);
        this.addCatItem(Messages.getString("Outfall"), SeaMark.Cat.SPM_OFAL);
        this.addCatItem(Messages.getString("ODAS"), SeaMark.Cat.SPM_ODAS);
        this.addCatItem(Messages.getString("RecreationZone"), SeaMark.Cat.SPM_RECN);
        this.addCatItem(Messages.getString("Mooring"), SeaMark.Cat.SPM_MOOR);
        this.addCatItem(Messages.getString("LANBY"), SeaMark.Cat.SPM_LNBY);
        this.addCatItem(Messages.getString("Leading"), SeaMark.Cat.SPM_LDNG);
        this.addCatItem(Messages.getString("Notice"), SeaMark.Cat.SPM_NOTC);
        this.addCatItem(Messages.getString("TSS"), SeaMark.Cat.SPM_TSS);
        this.addCatItem(Messages.getString("FoulGround"), SeaMark.Cat.SPM_FOUL);
        this.addCatItem(Messages.getString("Diving"), SeaMark.Cat.SPM_DIVE);
        this.addCatItem(Messages.getString("FerryCross"), SeaMark.Cat.SPM_FRRY);
        this.addCatItem(Messages.getString("Anchorage"), SeaMark.Cat.SPM_ANCH);
        this.mooringBox = new JComboBox();
        this.mooringBox.setBounds(new Rectangle(5, 142, 160, 18));
        this.add(this.mooringBox);
        this.mooringBox.setVisible(false);
        this.mooringBox.addActionListener(this.alMooringBox);
        this.addMorItem("", SeaMark.Cat.NOCAT);
        this.addMorItem(Messages.getString("Dolphin"), SeaMark.Cat.MOR_DLPN);
        this.addMorItem(Messages.getString("DevDolphin"), SeaMark.Cat.MOR_DDPN);
        this.addMorItem(Messages.getString("Bollard"), SeaMark.Cat.MOR_BLRD);
        this.addMorItem(Messages.getString("Wall"), SeaMark.Cat.MOR_WALL);
        this.addMorItem(Messages.getString("Post"), SeaMark.Cat.MOR_POST);
        this.addMorItem(Messages.getString("Chain"), SeaMark.Cat.MOR_CHWR);
        this.addMorItem(Messages.getString("Rope"), SeaMark.Cat.MOR_ROPE);
        this.addMorItem(Messages.getString("Automatic"), SeaMark.Cat.MOR_AUTO);
        this.addMorItem(Messages.getString("MooringBuoy"), SeaMark.Cat.MOR_BUOY);
        this.addMorItem(Messages.getString("CALM"), SeaMark.Cat.INB_CALM);
        this.addMorItem(Messages.getString("SBM"), SeaMark.Cat.INB_SBM);
        this.topmarkButton.setBounds(new Rectangle(136, 0, 34, 32));
        this.topmarkButton.setToolTipText(Messages.getString("Topmark"));
        this.topmarkButton.setBorder(BorderFactory.createLoweredBevelBorder());
        this.topmarkButton.addActionListener(this.alTop);
        this.add(this.topmarkButton);
        this.mooringButton.setBounds(new Rectangle(136, 64, 34, 32));
        this.mooringButton.setToolTipText(Messages.getString("Mooring"));
        this.mooringButton.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mooringButton.addActionListener(this.alMooring);
        this.add(this.mooringButton);
    }

    public void syncPanel() {
        int item;
        if (SeaMark.EntMAP.get((Object)SmedAction.panelMain.mark.getObject()) == SeaMark.Ent.MOORING) {
            this.mooringButton.setBorderPainted(true);
            this.categoryBox.setVisible(false);
            this.mooringBox.setVisible(true);
            this.pillarButton.setEnabled(false);
            this.sparButton.setEnabled(false);
            this.beaconButton.setEnabled(false);
            this.towerButton.setEnabled(false);
            this.stakeButton.setEnabled(false);
            this.cairnButton.setEnabled(false);
            this.noticeButton.setEnabled(false);
            this.topmarkButton.setVisible(false);
            for (SeaMark.Cat cat : this.moorings.keySet()) {
                item = this.moorings.get((Object)cat);
                if (SmedAction.panelMain.mark.getCategory() != cat) continue;
                this.mooringBox.setSelectedIndex(item);
            }
        } else {
            this.mooringButton.setBorderPainted(false);
            this.mooringBox.setVisible(false);
            this.categoryBox.setVisible(true);
            this.pillarButton.setEnabled(true);
            this.sparButton.setEnabled(true);
            this.beaconButton.setEnabled(true);
            this.towerButton.setEnabled(true);
            this.stakeButton.setEnabled(true);
            this.cairnButton.setEnabled(true);
            this.noticeButton.setEnabled(true);
            this.topmarkButton.setBorderPainted(SmedAction.panelMain.mark.getTopmark() != SeaMark.Top.NOTOP);
            this.topmarkButton.setSelected(SmedAction.panelMain.mark.getTopmark() != SeaMark.Top.NOTOP);
            this.topmarkButton.setVisible(SmedAction.panelMain.mark.testValid());
            for (SeaMark.Cat cat : this.categories.keySet()) {
                item = this.categories.get((Object)cat);
                if (SmedAction.panelMain.mark.getCategory() != cat) continue;
                this.categoryBox.setSelectedIndex(item);
            }
        }
        for (SeaMark.Shp shp : this.shapes.keySet()) {
            JRadioButton button = this.shapes.get((Object)shp);
            if (SmedAction.panelMain.mark.getShape() == shp) {
                button.setBorderPainted(true);
                continue;
            }
            button.setBorderPainted(false);
        }
        this.noticeButton.setBorderPainted(false);
        SmedAction.panelMain.mark.testValid();
    }

    private void addCatItem(String str, SeaMark.Cat cat) {
        this.categories.put(cat, this.categoryBox.getItemCount());
        this.categoryBox.addItem(str);
    }

    private void addMorItem(String str, SeaMark.Cat cat) {
        this.moorings.put(cat, this.mooringBox.getItemCount());
        this.mooringBox.addItem(str);
    }

    private JRadioButton getShapeButton(JRadioButton button, int x, int y, int w, int h, String tip, SeaMark.Shp shp, SeaMark.Obj obj) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(Messages.getString(tip));
        button.addActionListener(this.alShape);
        this.shapeButtons.add(button);
        this.shapes.put(shp, button);
        this.objects.put(shp, obj);
        return button;
    }
}

