/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.changeset.util;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class Request {
    private static final StringProperty OSMCHA_AUTHORIZATION = new StringProperty("osmcha.authorization.key", null);

    private Request() {
    }

    private static boolean getOsmChaAuthorization() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        String message = I18n.tr((String)"Please enter your OSMCha API Key (see link)", (Object[])new Object[0]);
        String userUrl = "https://osmcha.org/user";
        HtmlPanel htmlPanel = new HtmlPanel("<html><body style=\"width: 375px;\">" + message + "<br><a href=\"" + userUrl + "\">" + userUrl + "</a></body></html>");
        htmlPanel.enableClickableHyperlinks();
        jPanel.add((Component)htmlPanel);
        JosmTextField textField = new JosmTextField();
        textField.setHint("Token <Token Value>");
        jPanel.add((Component)textField);
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Missing OSMCha API Key", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}).setContent((Component)jPanel);
        int ret = ed.showDialog().getValue();
        if (ret == 0 || ret == 2) {
            return false;
        }
        OSMCHA_AUTHORIZATION.put(textField.getText());
        return OSMCHA_AUTHORIZATION.isSet();
    }

    public static String sendGET(String url) throws IOException {
        Logging.trace((String)url);
        HttpClient client = HttpClient.create((URL)new URL(url)).setAccept("application/json");
        if (url.contains("https://osmcha.org/api/v1/")) {
            if (!OSMCHA_AUTHORIZATION.isSet() && !Request.getOsmChaAuthorization()) {
                return null;
            }
            client.setHeader("Authorization", OSMCHA_AUTHORIZATION.get());
        }
        HttpClient.Response response = client.connect();
        String result = null;
        if (response.getResponseCode() == 200) {
            result = response.fetchContent();
        } else if (response.getResponseCode() == 401 && url.contains("https://osmcha.org/api/v1/")) {
            OSMCHA_AUTHORIZATION.remove();
        }
        response.disconnect();
        return result;
    }
}

