/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.eventbus;

import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.openstreetmap.josm.eventbus.EventBus;
import org.openstreetmap.josm.eventbus.Subscribe;
import org.openstreetmap.josm.eventbus.Subscriber;
import org.openstreetmap.josm.tools.MultiMap;

final class SubscriberRegistry {
    private final ConcurrentMap<Class<?>, CopyOnWriteArraySet<Subscriber>> subscribers = new ConcurrentHashMap();
    private final EventBus bus;
    private static final Map<Class<?>, Set<Class<?>>> flattenHierarchyCache = new HashMap();

    SubscriberRegistry(EventBus bus) {
        this.bus = Objects.requireNonNull(bus);
    }

    void register(Object listener) {
        MultiMap<Class<?>, Subscriber> listenerMethods = this.findAllSubscribers(listener);
        for (Map.Entry entry : listenerMethods.entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection eventMethodsInListener = (Collection)entry.getValue();
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (eventSubscribers == null) {
                CopyOnWriteArraySet newSet = new CopyOnWriteArraySet();
                eventSubscribers = SubscriberRegistry.firstNonNull(this.subscribers.putIfAbsent(eventType, newSet), newSet);
            }
            eventSubscribers.addAll(eventMethodsInListener);
        }
    }

    void unregister(Object listener) {
        MultiMap<Class<?>, Subscriber> listenerMethods = this.findAllSubscribers(listener);
        for (Map.Entry entry : listenerMethods.entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection listenerMethodsForType = (Collection)entry.getValue();
            CopyOnWriteArraySet currentSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (currentSubscribers != null && currentSubscribers.removeAll(listenerMethodsForType)) continue;
            throw new IllegalArgumentException("missing event subscriber for an annotated method. Is " + String.valueOf(listener) + " registered?");
        }
    }

    Set<Subscriber> getSubscribersForTesting(Class<?> eventType) {
        return SubscriberRegistry.firstNonNull((AbstractSet)this.subscribers.get(eventType), new HashSet());
    }

    Iterator<Subscriber> getSubscribers(Object event) {
        Set<Class<?>> eventTypes = SubscriberRegistry.flattenHierarchy(event.getClass());
        ArrayList subscriberList = new ArrayList(eventTypes.size());
        for (Class<?> eventType : eventTypes) {
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (eventSubscribers == null) continue;
            subscriberList.addAll(eventSubscribers);
        }
        return Collections.unmodifiableList(subscriberList).iterator();
    }

    private MultiMap<Class<?>, Subscriber> findAllSubscribers(Object listener) {
        MultiMap methodsInListener = new MultiMap();
        Class<?> clazz = listener.getClass();
        for (Method method : SubscriberRegistry.getAnnotatedMethods(clazz)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            methodsInListener.put(eventType, (Object)Subscriber.create(this.bus, listener, method));
        }
        return methodsInListener;
    }

    private static List<Method> getAnnotatedMethods(Class<?> clazz) {
        return SubscriberRegistry.getAnnotatedMethodsNotCached(clazz);
    }

    private static List<Method> getAnnotatedMethodsNotCached(Class<?> clazz) {
        Set<Class<?>> supertypes = SubscriberRegistry.getClassesAndInterfaces(clazz);
        HashMap<MethodIdentifier, Method> identifiers = new HashMap<MethodIdentifier, Method>();
        for (Class<?> supertype : supertypes) {
            for (Method method : supertype.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Subscribe.class) || method.isSynthetic()) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new IllegalArgumentException(String.format("Method %s has @Subscribe annotation but has %s parameters.Subscriber methods must have exactly 1 parameter.", method, parameterTypes.length));
                }
                MethodIdentifier ident = new MethodIdentifier(method);
                if (identifiers.containsKey(ident)) continue;
                identifiers.put(ident, method);
            }
        }
        return new ArrayList<Method>(identifiers.values());
    }

    static Set<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        return flattenHierarchyCache.computeIfAbsent(concreteClass, SubscriberRegistry::getClassesAndInterfaces);
    }

    static <T> T firstNonNull(T first, T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException("Both parameters are null");
    }

    private static Set<Class<?>> getClassesAndInterfaces(Class<?> clazz) {
        HashSet result = new HashSet();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            result.add(c);
            for (Set interfaces : Arrays.stream(c.getInterfaces()).map(SubscriberRegistry::getClassesAndInterfaces).collect(Collectors.toList())) {
                result.addAll(interfaces);
            }
        }
        return result;
    }

    private static final class MethodIdentifier {
        private final String name;
        private final List<Class<?>> parameterTypes;

        MethodIdentifier(Method method) {
            this.name = method.getName();
            this.parameterTypes = Arrays.asList(method.getParameterTypes());
        }

        public int hashCode() {
            return Objects.hash(this.name, this.parameterTypes);
        }

        public boolean equals(Object o) {
            if (o instanceof MethodIdentifier) {
                MethodIdentifier ident = (MethodIdentifier)o;
                return this.name.equals(ident.name) && this.parameterTypes.equals(ident.parameterTypes);
            }
            return false;
        }
    }
}

