/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.actions.StreetsideDownloadAction;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;

public class StreetsideImageDisplay
extends JComponent {
    private static final long serialVersionUID = -3188274185432686201L;
    private volatile BufferedImage image;
    private volatile Rectangle visibleRect;
    private Rectangle selectedRect;

    public StreetsideImageDisplay() {
        ImgDisplayMouseListener mouseListener = new ImgDisplayMouseListener();
        this.addMouseListener(mouseListener);
        this.addMouseWheelListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        StreetsideProperties.SHOW_DETECTED_SIGNS.addListener(valChanged -> this.repaint());
    }

    private static Point getCenterImgCoord(Rectangle visibleRect) {
        return new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
    }

    private static Rectangle calculateDrawImageRectangle(Rectangle imgRect, Rectangle compRect) {
        int x = 0;
        int y = 0;
        int w = compRect.width;
        int wFact = w * imgRect.height;
        int h = compRect.height;
        int hFact = h * imgRect.width;
        if (wFact != hFact) {
            if (wFact > hFact) {
                w = hFact / imgRect.height;
                x = (compRect.width - w) / 2;
            } else {
                h = wFact / imgRect.width;
                y = (compRect.height - h) / 2;
            }
        }
        return new Rectangle(x + compRect.x, y + compRect.y, w, h);
    }

    private static void checkVisibleRectPos(Image image, Rectangle visibleRect) {
        if (visibleRect.x < 0) {
            visibleRect.x = 0;
        }
        if (visibleRect.y < 0) {
            visibleRect.y = 0;
        }
        if (visibleRect.x + visibleRect.width > image.getWidth(null)) {
            visibleRect.x = image.getWidth(null) - visibleRect.width;
        }
        if (visibleRect.y + visibleRect.height > image.getHeight(null)) {
            visibleRect.y = image.getHeight(null) - visibleRect.height;
        }
    }

    private static void checkVisibleRectSize(Image image, Rectangle visibleRect) {
        if (visibleRect.width > image.getWidth(null)) {
            visibleRect.width = image.getWidth(null);
        }
        if (visibleRect.height > image.getHeight(null)) {
            visibleRect.height = image.getHeight(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(BufferedImage image) {
        StreetsideImageDisplay streetsideImageDisplay = this;
        synchronized (streetsideImageDisplay) {
            this.image = image;
            this.selectedRect = null;
            if (image != null) {
                this.visibleRect = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
            }
        }
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Rectangle visibleRect;
        BufferedImage image;
        StreetsideImageDisplay streetsideImageDisplay = this;
        synchronized (streetsideImageDisplay) {
            image = this.image;
            visibleRect = this.visibleRect;
        }
        if (image == null) {
            g.setColor(Color.black);
            String noImageStr = StreetsideLayer.hasInstance() ? I18n.tr((String)"No image selected", (Object[])new Object[0]) : I18n.tr((String)"Press \"{0}\" to download images", (Object[])new Object[]{StreetsideDownloadAction.SHORTCUT.getKeyText()});
            Rectangle2D noImageSize = g.getFontMetrics(g.getFont()).getStringBounds(noImageStr, g);
            Dimension size = this.getSize();
            g.drawString(noImageStr, (int)(((double)size.width - noImageSize.getWidth()) / 2.0), (int)(((double)size.height - noImageSize.getHeight()) / 2.0));
        } else {
            Rectangle target = this.calculateDrawImageRectangle(visibleRect);
            g.drawImage(image, target.x, target.y, target.x + target.width, target.y + target.height, visibleRect.x, visibleRect.y, visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height, null);
            if (this.selectedRect != null) {
                Point topLeft = this.img2compCoord(visibleRect, this.selectedRect.x, this.selectedRect.y);
                Point bottomRight = this.img2compCoord(visibleRect, this.selectedRect.x + this.selectedRect.width, this.selectedRect.y + this.selectedRect.height);
                g.setColor(new Color(128, 128, 128, 180));
                g.fillRect(target.x, target.y, target.width, topLeft.y - target.y);
                g.fillRect(target.x, target.y, topLeft.x - target.x, target.height);
                g.fillRect(bottomRight.x, target.y, target.x + target.width - bottomRight.x, target.height);
                g.fillRect(target.x, bottomRight.y, target.width, target.y + target.height - bottomRight.y);
                g.setColor(Color.black);
                g.drawRect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
            }
            if (Boolean.TRUE.equals(StreetsideProperties.SHOW_DETECTED_SIGNS.get())) {
                Point upperLeft = this.img2compCoord(visibleRect, 0, 0);
                Point lowerRight = this.img2compCoord(visibleRect, this.getImage().getWidth(), this.getImage().getHeight());
                AffineTransform unit2compTransform = AffineTransform.getTranslateInstance(upperLeft.getX(), upperLeft.getY());
                unit2compTransform.concatenate(AffineTransform.getScaleInstance(lowerRight.getX() - upperLeft.getX(), lowerRight.getY() - upperLeft.getY()));
                Graphics2D g2d = (Graphics2D)g;
                g2d.setStroke(new BasicStroke(2.0f));
            }
        }
    }

    private Point img2compCoord(Rectangle visibleRect, int xImg, int yImg) {
        Rectangle drawRect = this.calculateDrawImageRectangle(visibleRect);
        return new Point(drawRect.x + (xImg - visibleRect.x) * drawRect.width / visibleRect.width, drawRect.y + (yImg - visibleRect.y) * drawRect.height / visibleRect.height);
    }

    private Point comp2imgCoord(Rectangle visibleRect, int xComp, int yComp) {
        Rectangle drawRect = this.calculateDrawImageRectangle(visibleRect);
        return new Point(visibleRect.x + (xComp - drawRect.x) * visibleRect.width / drawRect.width, visibleRect.y + (yComp - drawRect.y) * visibleRect.height / drawRect.height);
    }

    private Rectangle calculateDrawImageRectangle(Rectangle visibleRect) {
        return StreetsideImageDisplay.calculateDrawImageRectangle(visibleRect, new Rectangle(0, 0, this.getSize().width, this.getSize().height));
    }

    private class ImgDisplayMouseListener
    implements MouseListener,
    MouseWheelListener,
    MouseMotionListener {
        private boolean mouseIsDragging;
        private long lastTimeForMousePoint;
        private Point mousePointInImg;

        private ImgDisplayMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Rectangle visibleRect;
            BufferedImage image;
            StreetsideImageDisplay streetsideImageDisplay = StreetsideImageDisplay.this;
            synchronized (streetsideImageDisplay) {
                image = StreetsideImageDisplay.this.getImage();
                visibleRect = StreetsideImageDisplay.this.visibleRect;
            }
            this.mouseIsDragging = false;
            StreetsideImageDisplay.this.selectedRect = null;
            if (image != null && Math.min(StreetsideImageDisplay.this.getSize().getWidth(), StreetsideImageDisplay.this.getSize().getHeight()) > 0.0) {
                int wFact;
                int hFact;
                if (e.getWhen() - this.lastTimeForMousePoint > 1500L || this.mousePointInImg == null) {
                    this.lastTimeForMousePoint = e.getWhen();
                    this.mousePointInImg = StreetsideImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                }
                if (e.getWheelRotation() > 0) {
                    visibleRect.width = visibleRect.width * 3 / 2;
                    visibleRect.height = visibleRect.height * 3 / 2;
                } else {
                    visibleRect.width = visibleRect.width * 2 / 3;
                    visibleRect.height = visibleRect.height * 2 / 3;
                }
                if (visibleRect.width < StreetsideImageDisplay.this.getSize().width / 2) {
                    visibleRect.width = StreetsideImageDisplay.this.getSize().width / 2;
                }
                if (visibleRect.height < StreetsideImageDisplay.this.getSize().height / 2) {
                    visibleRect.height = StreetsideImageDisplay.this.getSize().height / 2;
                }
                if ((hFact = visibleRect.height * StreetsideImageDisplay.this.getSize().width) > (wFact = visibleRect.width * StreetsideImageDisplay.this.getSize().height)) {
                    visibleRect.width = hFact / StreetsideImageDisplay.this.getSize().height;
                } else {
                    visibleRect.height = wFact / StreetsideImageDisplay.this.getSize().width;
                }
                StreetsideImageDisplay.checkVisibleRectSize(image, visibleRect);
                Rectangle drawRect = StreetsideImageDisplay.this.calculateDrawImageRectangle(visibleRect);
                visibleRect.x = this.mousePointInImg.x + (drawRect.x - e.getX()) * visibleRect.width / drawRect.width;
                visibleRect.y = this.mousePointInImg.y + (drawRect.y - e.getY()) * visibleRect.height / drawRect.height;
                StreetsideImageDisplay.checkVisibleRectPos(image, visibleRect);
                StreetsideImageDisplay streetsideImageDisplay2 = StreetsideImageDisplay.this;
                synchronized (streetsideImageDisplay2) {
                    StreetsideImageDisplay.this.visibleRect = visibleRect;
                }
                StreetsideImageDisplay.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            Rectangle visibleRect;
            BufferedImage image;
            StreetsideImageDisplay streetsideImageDisplay = StreetsideImageDisplay.this;
            synchronized (streetsideImageDisplay) {
                image = StreetsideImageDisplay.this.getImage();
                visibleRect = StreetsideImageDisplay.this.visibleRect;
            }
            if (image != null && Math.min(StreetsideImageDisplay.this.getSize().getWidth(), StreetsideImageDisplay.this.getSize().getHeight()) > 0.0) {
                if (e.getButton() == StreetsideProperties.PICTURE_OPTION_BUTTON.get().intValue()) {
                    StreetsideImageDisplay.this.visibleRect = !StreetsideImageDisplay.this.visibleRect.equals(new Rectangle(0, 0, ((Image)image).getWidth(null), ((Image)image).getHeight(null))) ? new Rectangle(0, 0, ((Image)image).getWidth(null), ((Image)image).getHeight(null)) : new Rectangle(0, (((Image)image).getHeight(null) - ((Image)image).getWidth(null) * StreetsideImageDisplay.this.getHeight() / StreetsideImageDisplay.this.getWidth()) / 2, ((Image)image).getWidth(null), ((Image)image).getWidth(null) * StreetsideImageDisplay.this.getHeight() / StreetsideImageDisplay.this.getWidth());
                    StreetsideImageDisplay.this.repaint();
                    return;
                }
                if (e.getButton() != StreetsideProperties.PICTURE_DRAG_BUTTON.get().intValue()) {
                    return;
                }
                Point click = StreetsideImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                Point center = StreetsideImageDisplay.getCenterImgCoord(visibleRect);
                visibleRect.x += click.x - center.x;
                visibleRect.y += click.y - center.y;
                StreetsideImageDisplay.checkVisibleRectPos(image, visibleRect);
                StreetsideImageDisplay streetsideImageDisplay2 = StreetsideImageDisplay.this;
                synchronized (streetsideImageDisplay2) {
                    StreetsideImageDisplay.this.visibleRect = visibleRect;
                }
                StreetsideImageDisplay.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            Rectangle visibleRect;
            BufferedImage image;
            if (StreetsideImageDisplay.this.getImage() == null) {
                this.mouseIsDragging = false;
                StreetsideImageDisplay.this.selectedRect = null;
                return;
            }
            StreetsideImageDisplay streetsideImageDisplay = StreetsideImageDisplay.this;
            synchronized (streetsideImageDisplay) {
                image = StreetsideImageDisplay.this.image;
                visibleRect = StreetsideImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (e.getButton() == StreetsideProperties.PICTURE_DRAG_BUTTON.get().intValue()) {
                this.mousePointInImg = StreetsideImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                this.mouseIsDragging = true;
                StreetsideImageDisplay.this.selectedRect = null;
            } else if (e.getButton() == StreetsideProperties.PICTURE_ZOOM_BUTTON.get().intValue()) {
                this.mousePointInImg = StreetsideImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                this.checkPointInVisibleRect(this.mousePointInImg, visibleRect);
                this.mouseIsDragging = false;
                StreetsideImageDisplay.this.selectedRect = new Rectangle(this.mousePointInImg.x, this.mousePointInImg.y, 0, 0);
                StreetsideImageDisplay.this.repaint();
            } else {
                this.mouseIsDragging = false;
                StreetsideImageDisplay.this.selectedRect = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent e) {
            Rectangle visibleRect;
            BufferedImage image;
            if (!this.mouseIsDragging && StreetsideImageDisplay.this.selectedRect == null) {
                return;
            }
            StreetsideImageDisplay streetsideImageDisplay = StreetsideImageDisplay.this;
            synchronized (streetsideImageDisplay) {
                image = StreetsideImageDisplay.this.getImage();
                visibleRect = StreetsideImageDisplay.this.visibleRect;
            }
            if (image == null) {
                this.mouseIsDragging = false;
                StreetsideImageDisplay.this.selectedRect = null;
                return;
            }
            if (this.mouseIsDragging) {
                p = StreetsideImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                visibleRect.x += this.mousePointInImg.x - p.x;
                visibleRect.y += this.mousePointInImg.y - p.y;
                StreetsideImageDisplay.checkVisibleRectPos(image, visibleRect);
                StreetsideImageDisplay streetsideImageDisplay2 = StreetsideImageDisplay.this;
                synchronized (streetsideImageDisplay2) {
                    StreetsideImageDisplay.this.visibleRect = visibleRect;
                }
                StreetsideImageDisplay.this.repaint();
            } else if (StreetsideImageDisplay.this.selectedRect != null) {
                p = StreetsideImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                this.checkPointInVisibleRect(p, visibleRect);
                Rectangle rect = new Rectangle(Math.min(p.x, this.mousePointInImg.x), Math.min(p.y, this.mousePointInImg.y), p.x < this.mousePointInImg.x ? this.mousePointInImg.x - p.x : p.x - this.mousePointInImg.x, p.y < this.mousePointInImg.y ? this.mousePointInImg.y - p.y : p.y - this.mousePointInImg.y);
                StreetsideImageDisplay.checkVisibleRectSize(image, rect);
                StreetsideImageDisplay.checkVisibleRectPos(image, rect);
                StreetsideImageDisplay.this.selectedRect = rect;
                StreetsideImageDisplay.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            BufferedImage image;
            if (!this.mouseIsDragging && StreetsideImageDisplay.this.selectedRect == null) {
                return;
            }
            StreetsideImageDisplay streetsideImageDisplay = StreetsideImageDisplay.this;
            synchronized (streetsideImageDisplay) {
                image = StreetsideImageDisplay.this.getImage();
            }
            if (image == null) {
                this.mouseIsDragging = false;
                StreetsideImageDisplay.this.selectedRect = null;
                return;
            }
            if (this.mouseIsDragging) {
                this.mouseIsDragging = false;
            } else if (StreetsideImageDisplay.this.selectedRect != null) {
                int wFact;
                int hFact;
                int oldWidth = StreetsideImageDisplay.this.selectedRect.width;
                int oldHeight = StreetsideImageDisplay.this.selectedRect.height;
                if (StreetsideImageDisplay.this.selectedRect.width < StreetsideImageDisplay.this.getSize().width / 2) {
                    StreetsideImageDisplay.this.selectedRect.width = StreetsideImageDisplay.this.getSize().width / 2;
                }
                if (StreetsideImageDisplay.this.selectedRect.height < StreetsideImageDisplay.this.getSize().height / 2) {
                    StreetsideImageDisplay.this.selectedRect.height = StreetsideImageDisplay.this.getSize().height / 2;
                }
                if ((hFact = StreetsideImageDisplay.this.selectedRect.height * StreetsideImageDisplay.this.getSize().width) > (wFact = StreetsideImageDisplay.this.selectedRect.width * StreetsideImageDisplay.this.getSize().height)) {
                    StreetsideImageDisplay.this.selectedRect.width = hFact / StreetsideImageDisplay.this.getSize().height;
                } else {
                    StreetsideImageDisplay.this.selectedRect.height = wFact / StreetsideImageDisplay.this.getSize().width;
                }
                if (StreetsideImageDisplay.this.selectedRect.width != oldWidth) {
                    StreetsideImageDisplay.this.selectedRect.x -= (StreetsideImageDisplay.this.selectedRect.width - oldWidth) / 2;
                }
                if (StreetsideImageDisplay.this.selectedRect.height != oldHeight) {
                    StreetsideImageDisplay.this.selectedRect.y -= (StreetsideImageDisplay.this.selectedRect.height - oldHeight) / 2;
                }
                StreetsideImageDisplay.checkVisibleRectSize(image, StreetsideImageDisplay.this.selectedRect);
                StreetsideImageDisplay.checkVisibleRectPos(image, StreetsideImageDisplay.this.selectedRect);
                StreetsideImageDisplay streetsideImageDisplay2 = StreetsideImageDisplay.this;
                synchronized (streetsideImageDisplay2) {
                    StreetsideImageDisplay.this.visibleRect = StreetsideImageDisplay.this.selectedRect;
                }
                StreetsideImageDisplay.this.selectedRect = null;
                StreetsideImageDisplay.this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void checkPointInVisibleRect(Point p, Rectangle visibleRect) {
            if (p.x < visibleRect.x) {
                p.x = visibleRect.x;
            }
            if (p.x > visibleRect.x + visibleRect.width) {
                p.x = visibleRect.x + visibleRect.width;
            }
            if (p.y < visibleRect.y) {
                p.y = visibleRect.y;
            }
            if (p.y > visibleRect.y + visibleRect.height) {
                p.y = visibleRect.y + visibleRect.height;
            }
        }
    }
}

