/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cache;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.data.imagery.TileJobOptions;
import org.openstreetmap.josm.plugins.streetside.cache.Caches;

public class StreetsideCache
extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry> {
    private final String url;

    public StreetsideCache(String url) {
        super(Caches.ImageCache.getInstance().getCache(), new TileJobOptions(50000, 50000, new HashMap(), 50000L));
        this.url = url;
    }

    public String getCacheKey() {
        return this.url;
    }

    public URL getUrl() {
        try {
            return URI.create(this.url).toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected BufferedImageCacheEntry createCacheEntry(byte[] content) {
        return new BufferedImageCacheEntry(content);
    }

    protected boolean isObjectLoadable() {
        if (this.cacheData == null) {
            return false;
        }
        byte[] content = ((BufferedImageCacheEntry)this.cacheData).getContent();
        return content != null && content.length > 0;
    }
}

