/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.commons.jcs3.access.CacheAccess;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.IQuadBucketType;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.cache.CacheUtils;
import org.openstreetmap.josm.plugins.streetside.cache.Caches;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideViewerDialog;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ImageInfoPanel;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;

public class StreetsideData
implements Data {
    private final QuadBuckets<StreetsideImage> images = new QuadBuckets();
    private final List<StreetsideImage> sortedImages = new ArrayList<StreetsideImage>();
    private final List<StreetsideDataListener> listeners = new CopyOnWriteArrayList<StreetsideDataListener>();
    private final List<Bounds> bounds = new CopyOnWriteArrayList<Bounds>();
    private StreetsideImage selectedImage = null;
    private StreetsideImage highlightedImage;

    protected StreetsideData() {
        Arrays.stream(StreetsidePlugin.getStreetsideDataListeners()).forEach(this::addListener);
        this.addListener(StreetsideViewerDialog.getInstance().getStreetsideViewerPanel());
        this.addListener(StreetsideMainDialog.getInstance());
        this.addListener(ImageInfoPanel.getInstance());
    }

    private void downloadSurroundingImages(StreetsideImage streetsideImage) {
        MainApplication.worker.execute(() -> this.downloadSurrounding(streetsideImage, CacheUtils::downloadPicture));
    }

    public void downloadSurroundingCubemaps(StreetsideImage streetsideImage) {
        MainApplication.worker.execute(() -> this.downloadSurrounding(streetsideImage, CacheUtils::downloadCubemap));
    }

    private void downloadSurrounding(StreetsideImage streetsideImage, Consumer<StreetsideImage> imageDownloader) {
        int prefetchCount = StreetsideProperties.PRE_FETCH_IMAGE_COUNT.get();
        CacheAccess<String, BufferedImageCacheEntry> imageCache = Caches.ImageCache.getInstance().getCache();
        StreetsideImage nextImage = this.next(streetsideImage);
        StreetsideImage prevImage = this.previous(streetsideImage);
        for (int i = 0; i < prefetchCount; ++i) {
            if (nextImage != null) {
                if (imageCache.get((Object)nextImage.id()) == null) {
                    imageDownloader.accept(nextImage);
                }
                nextImage = this.next(nextImage);
            }
            if (prevImage == null) continue;
            if (imageCache.get((Object)prevImage.id()) == null) {
                imageDownloader.accept(prevImage);
            }
            prevImage = this.previous(prevImage);
        }
    }

    public void add(StreetsideImage image) {
        this.add(image, true);
    }

    public void add(StreetsideImage image, boolean update) {
        if (this.images.contains((Object)image)) {
            return;
        }
        this.images.add((IQuadBucketType)image);
        if (update) {
            StreetsideLayer.invalidateInstance();
        }
        this.fireImagesAdded();
    }

    public void addAll(Collection<StreetsideImage> images) {
        this.addAll(images, true);
    }

    public void addAll(Collection<StreetsideImage> newImages, boolean update) {
        newImages = new HashSet<StreetsideImage>(newImages);
        newImages.removeIf(arg_0 -> this.images.contains(arg_0));
        this.images.addAll(newImages);
        this.sortedImages.addAll(newImages);
        this.sortedImages.sort(Comparator.naturalOrder());
        if (update) {
            StreetsideLayer.invalidateInstance();
        }
        this.fireImagesAdded();
    }

    public final void addListener(StreetsideDataListener lis) {
        this.listeners.add(lis);
    }

    public List<Bounds> getBounds() {
        return this.bounds;
    }

    public void removeListener(StreetsideDataListener lis) {
        this.listeners.remove(lis);
    }

    public StreetsideImage getHighlightedImage() {
        return this.highlightedImage;
    }

    public void setHighlightedImage(StreetsideImage image) {
        this.highlightedImage = image;
    }

    public Collection<StreetsideImage> getImages() {
        return this.images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImages(Collection<StreetsideImage> newImages) {
        StreetsideData streetsideData = this;
        synchronized (streetsideData) {
            this.images.clear();
            this.sortedImages.clear();
            this.addAll(newImages);
        }
    }

    public StreetsideImage getSelectedImage() {
        return this.selectedImage;
    }

    public void setSelectedImage(StreetsideImage image) {
        this.setSelectedImage(image, false);
    }

    private void fireImagesAdded() {
        this.listeners.stream().filter(Objects::nonNull).forEach(StreetsideDataListener::imagesAdded);
    }

    public void selectNext() {
        this.selectNext(StreetsideProperties.MOVE_TO_IMG.get());
    }

    public void selectNext(boolean moveToPicture) {
        StreetsideImage tempImage = this.selectedImage;
        if (this.selectedImage != null) {
            while (this.next(tempImage) != null) {
                if ((tempImage = this.next(tempImage)) == null || !tempImage.visible()) continue;
                this.setSelectedImage(tempImage, moveToPicture);
                break;
            }
        }
    }

    public void selectPrevious() {
        this.selectPrevious(StreetsideProperties.MOVE_TO_IMG.get());
    }

    public void selectPrevious(boolean moveToPicture) {
        if (this.selectedImage != null) {
            StreetsideImage tempImage = this.selectedImage;
            while (this.previous(tempImage) != null) {
                if ((tempImage = this.previous(tempImage)) == null || !tempImage.visible()) continue;
                this.setSelectedImage(tempImage, moveToPicture);
                break;
            }
        }
    }

    public void setSelectedImage(StreetsideImage image, boolean zoom) {
        StreetsideImage oldImage = this.selectedImage;
        this.selectedImage = image;
        MapView mv = StreetsidePlugin.getMapView();
        if (image != null && mv != null) {
            this.downloadSurroundingImages(image);
        }
        if (mv != null && zoom && this.selectedImage != null) {
            mv.zoomTo((ILatLon)this.selectedImage);
        }
        this.fireSelectedImageChanged(oldImage, this.selectedImage);
        StreetsideLayer.invalidateInstance();
    }

    private void fireSelectedImageChanged(StreetsideImage oldImage, StreetsideImage newImage) {
        this.listeners.stream().filter(Objects::nonNull).forEach(lis -> lis.selectedImageChanged(oldImage, newImage));
    }

    public Collection<DataSource> getDataSources() {
        return Collections.emptyList();
    }

    public StreetsideImage next(StreetsideImage current) {
        int currentIndex = this.sortedImages.indexOf(current);
        if (currentIndex + 1 >= this.sortedImages.size()) {
            return null;
        }
        return this.sortedImages.get(currentIndex + 1);
    }

    public StreetsideImage previous(StreetsideImage current) {
        int currentIndex = this.sortedImages.indexOf(current);
        if (currentIndex - 1 < 0) {
            return null;
        }
        return this.sortedImages.get(currentIndex - 1);
    }

    public Collection<StreetsideImage> search(StreetsideImage target, double v) {
        BBox searchBox = new BBox((ILatLon)target);
        searchBox.addLatLon(new LatLon(target.lat(), target.lon()), v);
        return this.images.search(searchBox);
    }

    public Collection<StreetsideImage> search(BBox searchBox) {
        return this.images.search(searchBox);
    }
}

