/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.models;

import com.bric.colorpicker.listeners.ColorListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;

public class ColorModel {
    private final Collection<ColorListener> listeners = new ArrayList<ColorListener>(6);
    private Color color = Color.GREEN;
    private boolean changing;

    public void addColorListener(ColorListener changeListener) {
        this.listeners.add(changeListener);
    }

    private void fireColorChanged() {
        this.changing = true;
        for (ColorListener listener : this.listeners) {
            listener.colorChanged(this);
        }
        this.changing = false;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.changing) {
            return;
        }
        this.color = color;
        this.fireColorChanged();
    }

    public float getHue() {
        return this.getHSB()[0];
    }

    public void setHue(float hue) {
        if (this.changing) {
            return;
        }
        float[] hsb = this.getHSB();
        this.color = Color.getHSBColor(hue, hsb[1], hsb[2]);
        this.fireColorChanged();
    }

    public float getSaturation() {
        return this.getHSB()[1];
    }

    public void setSaturation(float saturation) {
        if (this.changing) {
            return;
        }
        float[] hsb = this.getHSB();
        this.color = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        this.fireColorChanged();
    }

    public float getBrightness() {
        return this.getHSB()[2];
    }

    public void setBrightness(float brightness) {
        if (this.changing) {
            return;
        }
        float[] hsb = this.getHSB();
        this.color = Color.getHSBColor(hsb[0], hsb[1], brightness);
        this.fireColorChanged();
    }

    public int[] getRGB() {
        return new int[]{this.getRed(), this.getGreen(), this.getBlue()};
    }

    public float[] getHSB() {
        return Color.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), new float[3]);
    }

    public int getAlpha() {
        return this.color.getAlpha();
    }

    public void setAlpha(int alpha) {
        this.color = new Color(this.getRed(), this.getGreen(), this.getBlue(), alpha);
        this.fireColorChanged();
    }

    public int getBlue() {
        return this.color.getBlue();
    }

    public void setBlue(int blue) {
        if (this.changing) {
            return;
        }
        this.color = new Color(this.getRed(), this.getGreen(), blue);
        this.fireColorChanged();
    }

    public int getGreen() {
        return this.color.getGreen();
    }

    public void setGreen(int green) {
        if (this.changing) {
            return;
        }
        this.color = new Color(this.getRed(), green, this.getBlue());
        this.fireColorChanged();
    }

    public int getRed() {
        return this.color.getRed();
    }

    public void setRed(int red) {
        if (this.changing) {
            return;
        }
        this.color = new Color(red, this.getGreen(), this.getBlue());
        this.fireColorChanged();
    }

    public void removeColorListener(ColorListener listener) {
        this.listeners.remove(listener);
    }
}

