/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery_offset_db;

import java.util.Date;
import java.util.Map;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.DecimalDegreesCoordinateFormat;

public class ImageryOffsetBase {
    protected long offsetId;
    protected LatLon position;
    protected Date date;
    protected String author;
    protected String description;
    protected Date abandonDate;
    protected String abandonAuthor;
    protected String abandonReason;
    protected boolean flagged;

    public void setBasicInfo(LatLon position, String author, String description, Date date) {
        this.position = position;
        this.author = author;
        this.description = description;
        this.date = date;
        this.abandonDate = null;
        this.flagged = false;
    }

    public void setId(long id) {
        this.offsetId = id;
    }

    public long getId() {
        return this.offsetId;
    }

    public void setDeprecated(Date abandonDate, String author, String reason) {
        this.abandonDate = abandonDate;
        this.abandonAuthor = author;
        this.abandonReason = reason;
    }

    public boolean isFlagged() {
        return this.flagged;
    }

    public void setFlagged(boolean flagged) {
        this.flagged = flagged;
    }

    public Date getAbandonDate() {
        return this.abandonDate;
    }

    public String getAbandonAuthor() {
        return this.abandonAuthor;
    }

    public String getAbandonReason() {
        return this.abandonReason;
    }

    public boolean isDeprecated() {
        return this.abandonDate != null;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LatLon getPosition() {
        return this.position;
    }

    public void putServerParams(Map<String, String> map) {
        map.put("lat", DecimalDegreesCoordinateFormat.INSTANCE.latToString((ILatLon)this.position));
        map.put("lon", DecimalDegreesCoordinateFormat.INSTANCE.lonToString((ILatLon)this.position));
        map.put("author", this.author);
        map.put("description", this.description);
    }

    public String toString() {
        return "ImageryOffsetBase{position=" + String.valueOf(this.position) + ", date=" + String.valueOf(this.date) + ", author=" + this.author + ", description=" + this.description + ", abandonDate=" + String.valueOf(this.abandonDate) + "}";
    }
}

