/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.bytesource;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.imaging.bytesource.InputStreamByteSource;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractOrigin;

public class ByteSource {
    private final String fileName;
    private final AbstractOrigin<?, ?> origin;

    public static ByteSource array(byte[] array) {
        return new ByteSource(new AbstractOrigin.ByteArrayOrigin(array), null);
    }

    public static ByteSource array(byte[] array, String name) {
        return new ByteSource(new AbstractOrigin.ByteArrayOrigin(array), name);
    }

    public static ByteSource file(File file) {
        return new ByteSource(new AbstractOrigin.FileOrigin(file), file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final InputStream getInputStream(ByteSource byteSource, long skip) throws IOException {
        InputStream is = null;
        boolean succeeded = false;
        try {
            is = byteSource.getInputStream();
            BinaryFunctions.skipBytes(is, skip);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                IOUtils.close((Closeable)is);
            }
        }
        return is;
    }

    public static ByteSource inputStream(InputStream is, String name) throws IOException {
        return new InputStreamByteSource(is, name);
    }

    public static ByteSource path(Path file) {
        return new ByteSource(new AbstractOrigin.PathOrigin(file), Objects.toString(file.getFileName(), null));
    }

    ByteSource(AbstractOrigin<?, ?> origin, String fileName) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.fileName = fileName;
    }

    public byte[] getByteArray(long position, int length) throws IOException {
        return this.origin.getByteArray(position, length);
    }

    public final String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        return this.origin.getInputStream(new OpenOption[0]);
    }

    public long size() throws IOException {
        return this.origin.size();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getFileName() + "]";
    }
}

