/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.saudinationaladdress;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.DecimalDegreesCoordinateFormat;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class SaudiNationalAddressAction
extends JosmAction {
    static final String baseUrl = "https://apina.address.gov.sa/NationalAddress/v3.1/Address/address-geocode";
    private static final String GET_ADDRESS = I18n.marktr((String)"Get Address");

    public SaudiNationalAddressAction() {
        super(I18n.tr((String)GET_ADDRESS, (Object[])new Object[0]), new ImageProvider("icon.png"), I18n.tr((String)GET_ADDRESS, (Object[])new Object[0]), Shortcut.registerShortcut((String)"Get Address", (String)I18n.tr((String)GET_ADDRESS, (Object[])new Object[0]), (int)71, (int)5006), true, "getAddress", true);
    }

    public static OsmPrimitive loadAddress(OsmPrimitive selectedObject) {
        block7: {
            String apiKey = Config.getPref().get("saudi-national-address.api.key");
            if (!apiKey.isEmpty()) {
                LatLon center = selectedObject.getBBox().getCenter();
                URL url = SaudiNationalAddressAction.generateUrl((ILatLon)center);
                JsonObject json = SaudiNationalAddressAction.getJson(apiKey, url);
                try {
                    if (json == null) break block7;
                    if (json.containsKey((Object)"statusCode")) {
                        if (json.getInt("statusCode") != 200) {
                            SaudiNationalAddressAction.notification(json.getString("message"), 0);
                        }
                        break block7;
                    }
                    if (json.isNull("Addresses")) {
                        SaudiNationalAddressAction.notification(I18n.tr((String)"No address was found for this object.", (Object[])new Object[0]), 2);
                        break block7;
                    }
                    return SaudiNationalAddressAction.createAddress(selectedObject, json);
                }
                catch (NullPointerException e) {
                    Logging.error((Throwable)e);
                    SaudiNationalAddressAction.notification(I18n.tr((String)"Unknown Error: ", (Object[])new Object[0]) + e.getMessage(), 0);
                }
            } else {
                SaudiNationalAddressAction.notification(I18n.tr((String)"Please set your API key in the preference window!", (Object[])new Object[0]), 0);
            }
        }
        return null;
    }

    private static URL generateUrl(ILatLon center) {
        try {
            return new URI("https://apina.address.gov.sa/NationalAddress/v3.1/Address/address-geocode?lat=" + URLEncoder.encode(DecimalDegreesCoordinateFormat.INSTANCE.latToString(center), StandardCharsets.UTF_8) + "&long=" + URLEncoder.encode(DecimalDegreesCoordinateFormat.INSTANCE.lonToString(center), StandardCharsets.UTF_8) + "&language=A&format=json&encode=utf8").toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            Logging.trace((Throwable)e);
            SaudiNationalAddressAction.notification(e.getMessage(), 0);
            return null;
        }
    }

    private static OsmPrimitive createAddress(OsmPrimitive selectedObject, JsonObject json) {
        JsonArray addressItems = json.getJsonArray("Addresses");
        JsonObject firstAddress = addressItems.getJsonObject(0);
        String country = "SA";
        String district = firstAddress.getString("District");
        String postcode = firstAddress.getString("PostCode") + "-" + firstAddress.getString("AdditionalNumber");
        String city = firstAddress.getString("City");
        String buildingNumber = firstAddress.getString("BuildingNumber");
        String street = firstAddress.getString("Street");
        OsmPrimitive newObject = SaudiNationalAddressAction.createPrimitive(selectedObject);
        String[] districtArray = district.split(",");
        String[] cityArray = city.split(",");
        newObject.put("addr:postcode", postcode);
        newObject.put("addr:city", cityArray[1]);
        newObject.put("addr:city:en", cityArray[0]);
        newObject.put("addr:district", districtArray[1]);
        newObject.put("addr:district:en", districtArray[0]);
        newObject.put("addr:housenumber", buildingNumber);
        if (!street.isEmpty()) {
            newObject.put("addr:street", street);
        }
        String msg = I18n.tr((String)"Successfully added address to selected object:", (Object[])new Object[0]) + "<br />" + SaudiNationalAddressAction.encodeHTML(street) + " " + SaudiNationalAddressAction.encodeHTML(buildingNumber) + ", " + SaudiNationalAddressAction.encodeHTML(postcode) + " " + SaudiNationalAddressAction.encodeHTML(district) + " (" + SaudiNationalAddressAction.encodeHTML(country) + ")<br/>";
        SaudiNationalAddressAction.notification(msg, 1);
        return newObject;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonObject getJson(String apiKey, URL url) {
        try (BufferedReader in = HttpClient.create((URL)url).setReasonForRequest("JOSM Plugin Saudi National Address").setHeader("api_key", apiKey).connect().getContentReader();){
            JsonObject jsonObject;
            block14: {
                JsonReader reader = Json.createReader((Reader)in);
                try {
                    jsonObject = reader.readObject();
                    if (reader == null) break block14;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return jsonObject;
        }
        catch (IOException e) {
            Logging.trace((Throwable)e);
            SaudiNationalAddressAction.notification(e.getMessage(), 0);
            return null;
        }
    }

    private static OsmPrimitive createPrimitive(OsmPrimitive selectedObject) {
        if (selectedObject instanceof Node) {
            return new Node((Node)selectedObject);
        }
        if (selectedObject instanceof Way) {
            return new Way((Way)selectedObject);
        }
        if (selectedObject instanceof Relation) {
            return new Relation((Relation)selectedObject);
        }
        throw new IllegalStateException("Unknown object type: " + selectedObject.getClass().getName());
    }

    private static String encodeHTML(String s) {
        StringBuilder out = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>') {
                out.append("&#").append((int)c).append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private static void notification(String message, int messageType) {
        new Notification("<strong>" + I18n.tr((String)"Saudi National Address", (Object[])new Object[0]) + "</strong><br>" + message).setIcon(messageType).setDuration(3000).show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Collection sel = MainApplication.getLayerManager().getEditDataSet().getSelected();
        if (sel.size() != 1) {
            SaudiNationalAddressAction.notification(I18n.tr((String)"Please select exactly one object.", (Object[])new Object[0]), 0);
            return;
        }
        ArrayList<ChangeCommand> commands = new ArrayList<ChangeCommand>();
        for (OsmPrimitive selectedObject : sel) {
            OsmPrimitive newObject = SaudiNationalAddressAction.loadAddress(selectedObject);
            if (newObject == null) continue;
            commands.add(new ChangeCommand(selectedObject, newObject));
        }
        if (!commands.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.trn((String)"Get address", (String)"Get addresses", (long)commands.size(), (Object[])new Object[0]), commands));
        }
    }

    protected void updateEnabledState() {
        if (this.getLayerManager().getEditDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && selection.size() == 1);
    }
}

