/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import relcontext.relationfix.MultipolygonFixer;

public class BoundaryFixer
extends MultipolygonFixer {
    public BoundaryFixer() {
        super("boundary", "multipolygon");
    }

    @Override
    public boolean isFixerApplicable(Relation rel) {
        return super.isFixerApplicable(rel) && "administrative".equals(rel.get("boundary"));
    }

    @Override
    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (m.getType() == OsmPrimitiveType.RELATION && !"subarea".equals(m.getRole())) {
                this.setWarningMessage(I18n.tr((String)"Relation without ''subarea'' role found", (Object[])new Object[0]));
                return false;
            }
            if (m.getType() == OsmPrimitiveType.NODE && !"label".equals(m.getRole()) && !"admin_centre".equals(m.getRole())) {
                this.setWarningMessage(I18n.tr((String)"Node without ''label'' or ''admin_centre'' role found", (Object[])new Object[0]));
                return false;
            }
            if (m.getType() != OsmPrimitiveType.WAY || "outer".equals(m.getRole()) || "inner".equals(m.getRole())) continue;
            this.setWarningMessage(I18n.tr((String)"Way without ''inner'' or ''outer'' role found", (Object[])new Object[0]));
            return false;
        }
        this.clearWarningMessage();
        return true;
    }

    @Override
    public Command fixRelation(Relation rel) {
        List<RelationMember> members = this.fixMultipolygonRoles(rel.getMembers());
        if (members.isEmpty()) {
            members = rel.getMembers();
        }
        if (!(members = BoundaryFixer.fixBoundaryRoles(members)).equals(rel.getMembers())) {
            DataSet ds = (DataSet)Utils.firstNonNull((Object[])new DataSet[]{rel.getDataSet(), MainApplication.getLayerManager().getEditDataSet()});
            return new ChangeMembersCommand(ds, rel, members);
        }
        return null;
    }

    private static List<RelationMember> fixBoundaryRoles(List<RelationMember> origMembers) {
        List<RelationMember> members = origMembers;
        for (int i = 0; i < members.size(); ++i) {
            RelationMember m = members.get(i);
            String role = null;
            if (m.isRelation()) {
                role = "subarea";
            } else if (m.isNode() && !m.getMember().isIncomplete()) {
                String place;
                Node n = (Node)m.getMember();
                role = n.hasKey("place") ? ("state".equals(place = n.get("place")) || "country".equals(place) || "county".equals(place) || "region".equals(place) ? "label" : "admin_centre") : "label";
            }
            if (role == null || role.equals(m.getRole())) continue;
            if (members == origMembers) {
                members = new ArrayList<RelationMember>(origMembers);
            }
            members.set(i, new RelationMember(role, m.getMember()));
        }
        return members;
    }
}

