/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageio;

import jakarta.annotation.Nullable;
import org.openstreetmap.josm.spi.preferences.Config;

record Artifact(String group, String artifact, @Nullable String version) implements Comparable<Artifact>
{
    public String getLocalName() {
        if (this.version() == null) {
            return this.group() + "." + this.artifact();
        }
        return this.group() + "." + this.artifact() + "-" + this.version() + ".jar";
    }

    public String jar() {
        if (this.version == null) {
            throw new IllegalStateException("jar cannot be called when no version is set");
        }
        return this.getBaseUrl() + ".jar";
    }

    public String pom() {
        if (this.version == null) {
            throw new IllegalStateException("pom cannot be called when no version is set");
        }
        return this.getBaseUrl() + ".pom";
    }

    public String versions() {
        return this.baseUrl() + this.dotGroup() + "/" + this.artifact() + "/maven-metadata.xml";
    }

    private String getBaseUrl() {
        String dotGroup = this.dotGroup();
        return this.baseUrl() + dotGroup + "/" + this.artifact() + "/" + this.version() + "/" + this.artifact() + "-" + this.version();
    }

    private String baseUrl() {
        return Config.getPref().get("imageio.nexus.url", "https://josm.openstreetmap.de/repository/public/");
    }

    private String dotGroup() {
        return this.group().replace(".", "/");
    }

    @Override
    public int compareTo(Artifact o) {
        int gComp = this.group.compareTo(o.group);
        if (gComp != 0) {
            return gComp;
        }
        int aComp = this.artifact.compareTo(o.artifact);
        if (aComp != 0) {
            return aComp;
        }
        if (this.version == null && o.version == null) {
            return 0;
        }
        if (this.version == null) {
            return -1;
        }
        if (o.version == null) {
            return 1;
        }
        return this.version.compareTo(o.version);
    }
}

