/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoH265PpsFlags;
import org.lwjgl.vulkan.video.StdVideoH265PredictorPaletteEntries;
import org.lwjgl.vulkan.video.StdVideoH265ScalingLists;

public class StdVideoH265PictureParameterSet
extends Struct<StdVideoH265PictureParameterSet>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PPS_PIC_PARAMETER_SET_ID;
    public static final int PPS_SEQ_PARAMETER_SET_ID;
    public static final int SPS_VIDEO_PARAMETER_SET_ID;
    public static final int NUM_EXTRA_SLICE_HEADER_BITS;
    public static final int NUM_REF_IDX_L0_DEFAULT_ACTIVE_MINUS1;
    public static final int NUM_REF_IDX_L1_DEFAULT_ACTIVE_MINUS1;
    public static final int INIT_QP_MINUS26;
    public static final int DIFF_CU_QP_DELTA_DEPTH;
    public static final int PPS_CB_QP_OFFSET;
    public static final int PPS_CR_QP_OFFSET;
    public static final int PPS_BETA_OFFSET_DIV2;
    public static final int PPS_TC_OFFSET_DIV2;
    public static final int LOG2_PARALLEL_MERGE_LEVEL_MINUS2;
    public static final int LOG2_MAX_TRANSFORM_SKIP_BLOCK_SIZE_MINUS2;
    public static final int DIFF_CU_CHROMA_QP_OFFSET_DEPTH;
    public static final int CHROMA_QP_OFFSET_LIST_LEN_MINUS1;
    public static final int CB_QP_OFFSET_LIST;
    public static final int CR_QP_OFFSET_LIST;
    public static final int LOG2_SAO_OFFSET_SCALE_LUMA;
    public static final int LOG2_SAO_OFFSET_SCALE_CHROMA;
    public static final int PPS_ACT_Y_QP_OFFSET_PLUS5;
    public static final int PPS_ACT_CB_QP_OFFSET_PLUS5;
    public static final int PPS_ACT_CR_QP_OFFSET_PLUS3;
    public static final int PPS_NUM_PALETTE_PREDICTOR_INITIALIZERS;
    public static final int LUMA_BIT_DEPTH_ENTRY_MINUS8;
    public static final int CHROMA_BIT_DEPTH_ENTRY_MINUS8;
    public static final int NUM_TILE_COLUMNS_MINUS1;
    public static final int NUM_TILE_ROWS_MINUS1;
    public static final int RESERVED1;
    public static final int RESERVED2;
    public static final int COLUMN_WIDTH_MINUS1;
    public static final int ROW_HEIGHT_MINUS1;
    public static final int RESERVED3;
    public static final int PSCALINGLISTS;
    public static final int PPREDICTORPALETTEENTRIES;

    protected StdVideoH265PictureParameterSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoH265PictureParameterSet create(long address, @Nullable ByteBuffer container) {
        return new StdVideoH265PictureParameterSet(address, container);
    }

    public StdVideoH265PictureParameterSet(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoH265PictureParameterSet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoH265PpsFlags flags() {
        return StdVideoH265PictureParameterSet.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pps_pic_parameter_set_id() {
        return StdVideoH265PictureParameterSet.npps_pic_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pps_seq_parameter_set_id() {
        return StdVideoH265PictureParameterSet.npps_seq_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte sps_video_parameter_set_id() {
        return StdVideoH265PictureParameterSet.nsps_video_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_extra_slice_header_bits() {
        return StdVideoH265PictureParameterSet.nnum_extra_slice_header_bits(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l0_default_active_minus1() {
        return StdVideoH265PictureParameterSet.nnum_ref_idx_l0_default_active_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l1_default_active_minus1() {
        return StdVideoH265PictureParameterSet.nnum_ref_idx_l1_default_active_minus1(this.address());
    }

    @NativeType(value="int8_t")
    public byte init_qp_minus26() {
        return StdVideoH265PictureParameterSet.ninit_qp_minus26(this.address());
    }

    @NativeType(value="uint8_t")
    public byte diff_cu_qp_delta_depth() {
        return StdVideoH265PictureParameterSet.ndiff_cu_qp_delta_depth(this.address());
    }

    @NativeType(value="int8_t")
    public byte pps_cb_qp_offset() {
        return StdVideoH265PictureParameterSet.npps_cb_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte pps_cr_qp_offset() {
        return StdVideoH265PictureParameterSet.npps_cr_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte pps_beta_offset_div2() {
        return StdVideoH265PictureParameterSet.npps_beta_offset_div2(this.address());
    }

    @NativeType(value="int8_t")
    public byte pps_tc_offset_div2() {
        return StdVideoH265PictureParameterSet.npps_tc_offset_div2(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_parallel_merge_level_minus2() {
        return StdVideoH265PictureParameterSet.nlog2_parallel_merge_level_minus2(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_max_transform_skip_block_size_minus2() {
        return StdVideoH265PictureParameterSet.nlog2_max_transform_skip_block_size_minus2(this.address());
    }

    @NativeType(value="uint8_t")
    public byte diff_cu_chroma_qp_offset_depth() {
        return StdVideoH265PictureParameterSet.ndiff_cu_chroma_qp_offset_depth(this.address());
    }

    @NativeType(value="uint8_t")
    public byte chroma_qp_offset_list_len_minus1() {
        return StdVideoH265PictureParameterSet.nchroma_qp_offset_list_len_minus1(this.address());
    }

    @NativeType(value="int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]")
    public ByteBuffer cb_qp_offset_list() {
        return StdVideoH265PictureParameterSet.ncb_qp_offset_list(this.address());
    }

    @NativeType(value="int8_t")
    public byte cb_qp_offset_list(int index) {
        return StdVideoH265PictureParameterSet.ncb_qp_offset_list(this.address(), index);
    }

    @NativeType(value="int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]")
    public ByteBuffer cr_qp_offset_list() {
        return StdVideoH265PictureParameterSet.ncr_qp_offset_list(this.address());
    }

    @NativeType(value="int8_t")
    public byte cr_qp_offset_list(int index) {
        return StdVideoH265PictureParameterSet.ncr_qp_offset_list(this.address(), index);
    }

    @NativeType(value="uint8_t")
    public byte log2_sao_offset_scale_luma() {
        return StdVideoH265PictureParameterSet.nlog2_sao_offset_scale_luma(this.address());
    }

    @NativeType(value="uint8_t")
    public byte log2_sao_offset_scale_chroma() {
        return StdVideoH265PictureParameterSet.nlog2_sao_offset_scale_chroma(this.address());
    }

    @NativeType(value="int8_t")
    public byte pps_act_y_qp_offset_plus5() {
        return StdVideoH265PictureParameterSet.npps_act_y_qp_offset_plus5(this.address());
    }

    @NativeType(value="int8_t")
    public byte pps_act_cb_qp_offset_plus5() {
        return StdVideoH265PictureParameterSet.npps_act_cb_qp_offset_plus5(this.address());
    }

    @NativeType(value="int8_t")
    public byte pps_act_cr_qp_offset_plus3() {
        return StdVideoH265PictureParameterSet.npps_act_cr_qp_offset_plus3(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pps_num_palette_predictor_initializers() {
        return StdVideoH265PictureParameterSet.npps_num_palette_predictor_initializers(this.address());
    }

    @NativeType(value="uint8_t")
    public byte luma_bit_depth_entry_minus8() {
        return StdVideoH265PictureParameterSet.nluma_bit_depth_entry_minus8(this.address());
    }

    @NativeType(value="uint8_t")
    public byte chroma_bit_depth_entry_minus8() {
        return StdVideoH265PictureParameterSet.nchroma_bit_depth_entry_minus8(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_tile_columns_minus1() {
        return StdVideoH265PictureParameterSet.nnum_tile_columns_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_tile_rows_minus1() {
        return StdVideoH265PictureParameterSet.nnum_tile_rows_minus1(this.address());
    }

    @NativeType(value="uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_COLS_LIST_SIZE]")
    public ShortBuffer column_width_minus1() {
        return StdVideoH265PictureParameterSet.ncolumn_width_minus1(this.address());
    }

    @NativeType(value="uint16_t")
    public short column_width_minus1(int index) {
        return StdVideoH265PictureParameterSet.ncolumn_width_minus1(this.address(), index);
    }

    @NativeType(value="uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_ROWS_LIST_SIZE]")
    public ShortBuffer row_height_minus1() {
        return StdVideoH265PictureParameterSet.nrow_height_minus1(this.address());
    }

    @NativeType(value="uint16_t")
    public short row_height_minus1(int index) {
        return StdVideoH265PictureParameterSet.nrow_height_minus1(this.address(), index);
    }

    @NativeType(value="StdVideoH265ScalingLists const *")
    public StdVideoH265ScalingLists pScalingLists() {
        return StdVideoH265PictureParameterSet.npScalingLists(this.address());
    }

    @NativeType(value="StdVideoH265PredictorPaletteEntries const *")
    public StdVideoH265PredictorPaletteEntries pPredictorPaletteEntries() {
        return StdVideoH265PictureParameterSet.npPredictorPaletteEntries(this.address());
    }

    public StdVideoH265PictureParameterSet flags(StdVideoH265PpsFlags value) {
        StdVideoH265PictureParameterSet.nflags(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet flags(Consumer<StdVideoH265PpsFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoH265PictureParameterSet pps_pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_pic_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pps_seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_seq_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet sps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nsps_video_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet num_extra_slice_header_bits(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nnum_extra_slice_header_bits(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet num_ref_idx_l0_default_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nnum_ref_idx_l0_default_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet num_ref_idx_l1_default_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nnum_ref_idx_l1_default_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet init_qp_minus26(@NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.ninit_qp_minus26(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet diff_cu_qp_delta_depth(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.ndiff_cu_qp_delta_depth(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pps_cb_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_cb_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pps_cr_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_cr_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pps_beta_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_beta_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pps_tc_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_tc_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet log2_parallel_merge_level_minus2(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nlog2_parallel_merge_level_minus2(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet log2_max_transform_skip_block_size_minus2(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nlog2_max_transform_skip_block_size_minus2(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet diff_cu_chroma_qp_offset_depth(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.ndiff_cu_chroma_qp_offset_depth(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet chroma_qp_offset_list_len_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nchroma_qp_offset_list_len_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet cb_qp_offset_list(@NativeType(value="int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]") ByteBuffer value) {
        StdVideoH265PictureParameterSet.ncb_qp_offset_list(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet cb_qp_offset_list(int index, @NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.ncb_qp_offset_list(this.address(), index, value);
        return this;
    }

    public StdVideoH265PictureParameterSet cr_qp_offset_list(@NativeType(value="int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]") ByteBuffer value) {
        StdVideoH265PictureParameterSet.ncr_qp_offset_list(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet cr_qp_offset_list(int index, @NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.ncr_qp_offset_list(this.address(), index, value);
        return this;
    }

    public StdVideoH265PictureParameterSet log2_sao_offset_scale_luma(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nlog2_sao_offset_scale_luma(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet log2_sao_offset_scale_chroma(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nlog2_sao_offset_scale_chroma(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pps_act_y_qp_offset_plus5(@NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_act_y_qp_offset_plus5(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pps_act_cb_qp_offset_plus5(@NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_act_cb_qp_offset_plus5(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pps_act_cr_qp_offset_plus3(@NativeType(value="int8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_act_cr_qp_offset_plus3(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pps_num_palette_predictor_initializers(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.npps_num_palette_predictor_initializers(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet luma_bit_depth_entry_minus8(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nluma_bit_depth_entry_minus8(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet chroma_bit_depth_entry_minus8(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nchroma_bit_depth_entry_minus8(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet num_tile_columns_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nnum_tile_columns_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet num_tile_rows_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoH265PictureParameterSet.nnum_tile_rows_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet column_width_minus1(@NativeType(value="uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_COLS_LIST_SIZE]") ShortBuffer value) {
        StdVideoH265PictureParameterSet.ncolumn_width_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet column_width_minus1(int index, @NativeType(value="uint16_t") short value) {
        StdVideoH265PictureParameterSet.ncolumn_width_minus1(this.address(), index, value);
        return this;
    }

    public StdVideoH265PictureParameterSet row_height_minus1(@NativeType(value="uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_ROWS_LIST_SIZE]") ShortBuffer value) {
        StdVideoH265PictureParameterSet.nrow_height_minus1(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet row_height_minus1(int index, @NativeType(value="uint16_t") short value) {
        StdVideoH265PictureParameterSet.nrow_height_minus1(this.address(), index, value);
        return this;
    }

    public StdVideoH265PictureParameterSet pScalingLists(@NativeType(value="StdVideoH265ScalingLists const *") StdVideoH265ScalingLists value) {
        StdVideoH265PictureParameterSet.npScalingLists(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet pPredictorPaletteEntries(@NativeType(value="StdVideoH265PredictorPaletteEntries const *") StdVideoH265PredictorPaletteEntries value) {
        StdVideoH265PictureParameterSet.npPredictorPaletteEntries(this.address(), value);
        return this;
    }

    public StdVideoH265PictureParameterSet set(StdVideoH265PpsFlags flags, byte pps_pic_parameter_set_id, byte pps_seq_parameter_set_id, byte sps_video_parameter_set_id, byte num_extra_slice_header_bits, byte num_ref_idx_l0_default_active_minus1, byte num_ref_idx_l1_default_active_minus1, byte init_qp_minus26, byte diff_cu_qp_delta_depth, byte pps_cb_qp_offset, byte pps_cr_qp_offset, byte pps_beta_offset_div2, byte pps_tc_offset_div2, byte log2_parallel_merge_level_minus2, byte log2_max_transform_skip_block_size_minus2, byte diff_cu_chroma_qp_offset_depth, byte chroma_qp_offset_list_len_minus1, ByteBuffer cb_qp_offset_list, ByteBuffer cr_qp_offset_list, byte log2_sao_offset_scale_luma, byte log2_sao_offset_scale_chroma, byte pps_act_y_qp_offset_plus5, byte pps_act_cb_qp_offset_plus5, byte pps_act_cr_qp_offset_plus3, byte pps_num_palette_predictor_initializers, byte luma_bit_depth_entry_minus8, byte chroma_bit_depth_entry_minus8, byte num_tile_columns_minus1, byte num_tile_rows_minus1, ShortBuffer column_width_minus1, ShortBuffer row_height_minus1, StdVideoH265ScalingLists pScalingLists, StdVideoH265PredictorPaletteEntries pPredictorPaletteEntries) {
        this.flags(flags);
        this.pps_pic_parameter_set_id(pps_pic_parameter_set_id);
        this.pps_seq_parameter_set_id(pps_seq_parameter_set_id);
        this.sps_video_parameter_set_id(sps_video_parameter_set_id);
        this.num_extra_slice_header_bits(num_extra_slice_header_bits);
        this.num_ref_idx_l0_default_active_minus1(num_ref_idx_l0_default_active_minus1);
        this.num_ref_idx_l1_default_active_minus1(num_ref_idx_l1_default_active_minus1);
        this.init_qp_minus26(init_qp_minus26);
        this.diff_cu_qp_delta_depth(diff_cu_qp_delta_depth);
        this.pps_cb_qp_offset(pps_cb_qp_offset);
        this.pps_cr_qp_offset(pps_cr_qp_offset);
        this.pps_beta_offset_div2(pps_beta_offset_div2);
        this.pps_tc_offset_div2(pps_tc_offset_div2);
        this.log2_parallel_merge_level_minus2(log2_parallel_merge_level_minus2);
        this.log2_max_transform_skip_block_size_minus2(log2_max_transform_skip_block_size_minus2);
        this.diff_cu_chroma_qp_offset_depth(diff_cu_chroma_qp_offset_depth);
        this.chroma_qp_offset_list_len_minus1(chroma_qp_offset_list_len_minus1);
        this.cb_qp_offset_list(cb_qp_offset_list);
        this.cr_qp_offset_list(cr_qp_offset_list);
        this.log2_sao_offset_scale_luma(log2_sao_offset_scale_luma);
        this.log2_sao_offset_scale_chroma(log2_sao_offset_scale_chroma);
        this.pps_act_y_qp_offset_plus5(pps_act_y_qp_offset_plus5);
        this.pps_act_cb_qp_offset_plus5(pps_act_cb_qp_offset_plus5);
        this.pps_act_cr_qp_offset_plus3(pps_act_cr_qp_offset_plus3);
        this.pps_num_palette_predictor_initializers(pps_num_palette_predictor_initializers);
        this.luma_bit_depth_entry_minus8(luma_bit_depth_entry_minus8);
        this.chroma_bit_depth_entry_minus8(chroma_bit_depth_entry_minus8);
        this.num_tile_columns_minus1(num_tile_columns_minus1);
        this.num_tile_rows_minus1(num_tile_rows_minus1);
        this.column_width_minus1(column_width_minus1);
        this.row_height_minus1(row_height_minus1);
        this.pScalingLists(pScalingLists);
        this.pPredictorPaletteEntries(pPredictorPaletteEntries);
        return this;
    }

    public StdVideoH265PictureParameterSet set(StdVideoH265PictureParameterSet src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoH265PictureParameterSet malloc() {
        return new StdVideoH265PictureParameterSet(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoH265PictureParameterSet calloc() {
        return new StdVideoH265PictureParameterSet(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoH265PictureParameterSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoH265PictureParameterSet(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoH265PictureParameterSet create(long address) {
        return new StdVideoH265PictureParameterSet(address, null);
    }

    @Nullable
    public static StdVideoH265PictureParameterSet createSafe(long address) {
        return address == 0L ? null : new StdVideoH265PictureParameterSet(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoH265PictureParameterSet.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH265PictureParameterSet.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoH265PictureParameterSet malloc(MemoryStack stack) {
        return new StdVideoH265PictureParameterSet(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoH265PictureParameterSet calloc(MemoryStack stack) {
        return new StdVideoH265PictureParameterSet(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoH265PpsFlags nflags(long struct) {
        return StdVideoH265PpsFlags.create(struct + (long)FLAGS);
    }

    public static byte npps_pic_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_PIC_PARAMETER_SET_ID);
    }

    public static byte npps_seq_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_SEQ_PARAMETER_SET_ID);
    }

    public static byte nsps_video_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)SPS_VIDEO_PARAMETER_SET_ID);
    }

    public static byte nnum_extra_slice_header_bits(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_EXTRA_SLICE_HEADER_BITS);
    }

    public static byte nnum_ref_idx_l0_default_active_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_REF_IDX_L0_DEFAULT_ACTIVE_MINUS1);
    }

    public static byte nnum_ref_idx_l1_default_active_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_REF_IDX_L1_DEFAULT_ACTIVE_MINUS1);
    }

    public static byte ninit_qp_minus26(long struct) {
        return UNSAFE.getByte(null, struct + (long)INIT_QP_MINUS26);
    }

    public static byte ndiff_cu_qp_delta_depth(long struct) {
        return UNSAFE.getByte(null, struct + (long)DIFF_CU_QP_DELTA_DEPTH);
    }

    public static byte npps_cb_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_CB_QP_OFFSET);
    }

    public static byte npps_cr_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_CR_QP_OFFSET);
    }

    public static byte npps_beta_offset_div2(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_BETA_OFFSET_DIV2);
    }

    public static byte npps_tc_offset_div2(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_TC_OFFSET_DIV2);
    }

    public static byte nlog2_parallel_merge_level_minus2(long struct) {
        return UNSAFE.getByte(null, struct + (long)LOG2_PARALLEL_MERGE_LEVEL_MINUS2);
    }

    public static byte nlog2_max_transform_skip_block_size_minus2(long struct) {
        return UNSAFE.getByte(null, struct + (long)LOG2_MAX_TRANSFORM_SKIP_BLOCK_SIZE_MINUS2);
    }

    public static byte ndiff_cu_chroma_qp_offset_depth(long struct) {
        return UNSAFE.getByte(null, struct + (long)DIFF_CU_CHROMA_QP_OFFSET_DEPTH);
    }

    public static byte nchroma_qp_offset_list_len_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)CHROMA_QP_OFFSET_LIST_LEN_MINUS1);
    }

    public static ByteBuffer ncb_qp_offset_list(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)CB_QP_OFFSET_LIST, 6);
    }

    public static byte ncb_qp_offset_list(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)CB_QP_OFFSET_LIST + Checks.check(index, 6) * 1L);
    }

    public static ByteBuffer ncr_qp_offset_list(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)CR_QP_OFFSET_LIST, 6);
    }

    public static byte ncr_qp_offset_list(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)CR_QP_OFFSET_LIST + Checks.check(index, 6) * 1L);
    }

    public static byte nlog2_sao_offset_scale_luma(long struct) {
        return UNSAFE.getByte(null, struct + (long)LOG2_SAO_OFFSET_SCALE_LUMA);
    }

    public static byte nlog2_sao_offset_scale_chroma(long struct) {
        return UNSAFE.getByte(null, struct + (long)LOG2_SAO_OFFSET_SCALE_CHROMA);
    }

    public static byte npps_act_y_qp_offset_plus5(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_ACT_Y_QP_OFFSET_PLUS5);
    }

    public static byte npps_act_cb_qp_offset_plus5(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_ACT_CB_QP_OFFSET_PLUS5);
    }

    public static byte npps_act_cr_qp_offset_plus3(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_ACT_CR_QP_OFFSET_PLUS3);
    }

    public static byte npps_num_palette_predictor_initializers(long struct) {
        return UNSAFE.getByte(null, struct + (long)PPS_NUM_PALETTE_PREDICTOR_INITIALIZERS);
    }

    public static byte nluma_bit_depth_entry_minus8(long struct) {
        return UNSAFE.getByte(null, struct + (long)LUMA_BIT_DEPTH_ENTRY_MINUS8);
    }

    public static byte nchroma_bit_depth_entry_minus8(long struct) {
        return UNSAFE.getByte(null, struct + (long)CHROMA_BIT_DEPTH_ENTRY_MINUS8);
    }

    public static byte nnum_tile_columns_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_TILE_COLUMNS_MINUS1);
    }

    public static byte nnum_tile_rows_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_TILE_ROWS_MINUS1);
    }

    public static byte nreserved1(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED1);
    }

    public static byte nreserved2(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED2);
    }

    public static ShortBuffer ncolumn_width_minus1(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)COLUMN_WIDTH_MINUS1, 19);
    }

    public static short ncolumn_width_minus1(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)COLUMN_WIDTH_MINUS1 + Checks.check(index, 19) * 2L);
    }

    public static ShortBuffer nrow_height_minus1(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)ROW_HEIGHT_MINUS1, 21);
    }

    public static short nrow_height_minus1(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)ROW_HEIGHT_MINUS1 + Checks.check(index, 21) * 2L);
    }

    public static int nreserved3(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESERVED3);
    }

    public static StdVideoH265ScalingLists npScalingLists(long struct) {
        return StdVideoH265ScalingLists.create(MemoryUtil.memGetAddress(struct + (long)PSCALINGLISTS));
    }

    public static StdVideoH265PredictorPaletteEntries npPredictorPaletteEntries(long struct) {
        return StdVideoH265PredictorPaletteEntries.create(MemoryUtil.memGetAddress(struct + (long)PPREDICTORPALETTEENTRIES));
    }

    public static void nflags(long struct, StdVideoH265PpsFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoH265PpsFlags.SIZEOF);
    }

    public static void npps_pic_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_PIC_PARAMETER_SET_ID, value);
    }

    public static void npps_seq_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_SEQ_PARAMETER_SET_ID, value);
    }

    public static void nsps_video_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SPS_VIDEO_PARAMETER_SET_ID, value);
    }

    public static void nnum_extra_slice_header_bits(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_EXTRA_SLICE_HEADER_BITS, value);
    }

    public static void nnum_ref_idx_l0_default_active_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_REF_IDX_L0_DEFAULT_ACTIVE_MINUS1, value);
    }

    public static void nnum_ref_idx_l1_default_active_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_REF_IDX_L1_DEFAULT_ACTIVE_MINUS1, value);
    }

    public static void ninit_qp_minus26(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)INIT_QP_MINUS26, value);
    }

    public static void ndiff_cu_qp_delta_depth(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)DIFF_CU_QP_DELTA_DEPTH, value);
    }

    public static void npps_cb_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_CB_QP_OFFSET, value);
    }

    public static void npps_cr_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_CR_QP_OFFSET, value);
    }

    public static void npps_beta_offset_div2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_BETA_OFFSET_DIV2, value);
    }

    public static void npps_tc_offset_div2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_TC_OFFSET_DIV2, value);
    }

    public static void nlog2_parallel_merge_level_minus2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LOG2_PARALLEL_MERGE_LEVEL_MINUS2, value);
    }

    public static void nlog2_max_transform_skip_block_size_minus2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LOG2_MAX_TRANSFORM_SKIP_BLOCK_SIZE_MINUS2, value);
    }

    public static void ndiff_cu_chroma_qp_offset_depth(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)DIFF_CU_CHROMA_QP_OFFSET_DEPTH, value);
    }

    public static void nchroma_qp_offset_list_len_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)CHROMA_QP_OFFSET_LIST_LEN_MINUS1, value);
    }

    public static void ncb_qp_offset_list(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)CB_QP_OFFSET_LIST, value.remaining() * 1);
    }

    public static void ncb_qp_offset_list(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)CB_QP_OFFSET_LIST + Checks.check(index, 6) * 1L, value);
    }

    public static void ncr_qp_offset_list(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)CR_QP_OFFSET_LIST, value.remaining() * 1);
    }

    public static void ncr_qp_offset_list(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)CR_QP_OFFSET_LIST + Checks.check(index, 6) * 1L, value);
    }

    public static void nlog2_sao_offset_scale_luma(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LOG2_SAO_OFFSET_SCALE_LUMA, value);
    }

    public static void nlog2_sao_offset_scale_chroma(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LOG2_SAO_OFFSET_SCALE_CHROMA, value);
    }

    public static void npps_act_y_qp_offset_plus5(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_ACT_Y_QP_OFFSET_PLUS5, value);
    }

    public static void npps_act_cb_qp_offset_plus5(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_ACT_CB_QP_OFFSET_PLUS5, value);
    }

    public static void npps_act_cr_qp_offset_plus3(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_ACT_CR_QP_OFFSET_PLUS3, value);
    }

    public static void npps_num_palette_predictor_initializers(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PPS_NUM_PALETTE_PREDICTOR_INITIALIZERS, value);
    }

    public static void nluma_bit_depth_entry_minus8(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LUMA_BIT_DEPTH_ENTRY_MINUS8, value);
    }

    public static void nchroma_bit_depth_entry_minus8(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)CHROMA_BIT_DEPTH_ENTRY_MINUS8, value);
    }

    public static void nnum_tile_columns_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_TILE_COLUMNS_MINUS1, value);
    }

    public static void nnum_tile_rows_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_TILE_ROWS_MINUS1, value);
    }

    public static void nreserved1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED1, value);
    }

    public static void nreserved2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED2, value);
    }

    public static void ncolumn_width_minus1(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 19);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLUMN_WIDTH_MINUS1, value.remaining() * 2);
    }

    public static void ncolumn_width_minus1(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)COLUMN_WIDTH_MINUS1 + Checks.check(index, 19) * 2L, value);
    }

    public static void nrow_height_minus1(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 21);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ROW_HEIGHT_MINUS1, value.remaining() * 2);
    }

    public static void nrow_height_minus1(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)ROW_HEIGHT_MINUS1 + Checks.check(index, 21) * 2L, value);
    }

    public static void nreserved3(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED3, value);
    }

    public static void npScalingLists(long struct, StdVideoH265ScalingLists value) {
        MemoryUtil.memPutAddress(struct + (long)PSCALINGLISTS, value.address());
    }

    public static void npPredictorPaletteEntries(long struct, StdVideoH265PredictorPaletteEntries value) {
        MemoryUtil.memPutAddress(struct + (long)PPREDICTORPALETTEENTRIES, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSCALINGLISTS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PPREDICTORPALETTEENTRIES));
    }

    static {
        Struct.Layout layout = StdVideoH265PictureParameterSet.__struct(StdVideoH265PictureParameterSet.__member(StdVideoH265PpsFlags.SIZEOF, StdVideoH265PpsFlags.ALIGNOF), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__array(1, 6), StdVideoH265PictureParameterSet.__array(1, 6), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__member(1), StdVideoH265PictureParameterSet.__array(2, 19), StdVideoH265PictureParameterSet.__array(2, 21), StdVideoH265PictureParameterSet.__member(4), StdVideoH265PictureParameterSet.__member(POINTER_SIZE), StdVideoH265PictureParameterSet.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PPS_PIC_PARAMETER_SET_ID = layout.offsetof(1);
        PPS_SEQ_PARAMETER_SET_ID = layout.offsetof(2);
        SPS_VIDEO_PARAMETER_SET_ID = layout.offsetof(3);
        NUM_EXTRA_SLICE_HEADER_BITS = layout.offsetof(4);
        NUM_REF_IDX_L0_DEFAULT_ACTIVE_MINUS1 = layout.offsetof(5);
        NUM_REF_IDX_L1_DEFAULT_ACTIVE_MINUS1 = layout.offsetof(6);
        INIT_QP_MINUS26 = layout.offsetof(7);
        DIFF_CU_QP_DELTA_DEPTH = layout.offsetof(8);
        PPS_CB_QP_OFFSET = layout.offsetof(9);
        PPS_CR_QP_OFFSET = layout.offsetof(10);
        PPS_BETA_OFFSET_DIV2 = layout.offsetof(11);
        PPS_TC_OFFSET_DIV2 = layout.offsetof(12);
        LOG2_PARALLEL_MERGE_LEVEL_MINUS2 = layout.offsetof(13);
        LOG2_MAX_TRANSFORM_SKIP_BLOCK_SIZE_MINUS2 = layout.offsetof(14);
        DIFF_CU_CHROMA_QP_OFFSET_DEPTH = layout.offsetof(15);
        CHROMA_QP_OFFSET_LIST_LEN_MINUS1 = layout.offsetof(16);
        CB_QP_OFFSET_LIST = layout.offsetof(17);
        CR_QP_OFFSET_LIST = layout.offsetof(18);
        LOG2_SAO_OFFSET_SCALE_LUMA = layout.offsetof(19);
        LOG2_SAO_OFFSET_SCALE_CHROMA = layout.offsetof(20);
        PPS_ACT_Y_QP_OFFSET_PLUS5 = layout.offsetof(21);
        PPS_ACT_CB_QP_OFFSET_PLUS5 = layout.offsetof(22);
        PPS_ACT_CR_QP_OFFSET_PLUS3 = layout.offsetof(23);
        PPS_NUM_PALETTE_PREDICTOR_INITIALIZERS = layout.offsetof(24);
        LUMA_BIT_DEPTH_ENTRY_MINUS8 = layout.offsetof(25);
        CHROMA_BIT_DEPTH_ENTRY_MINUS8 = layout.offsetof(26);
        NUM_TILE_COLUMNS_MINUS1 = layout.offsetof(27);
        NUM_TILE_ROWS_MINUS1 = layout.offsetof(28);
        RESERVED1 = layout.offsetof(29);
        RESERVED2 = layout.offsetof(30);
        COLUMN_WIDTH_MINUS1 = layout.offsetof(31);
        ROW_HEIGHT_MINUS1 = layout.offsetof(32);
        RESERVED3 = layout.offsetof(33);
        PSCALINGLISTS = layout.offsetof(34);
        PPREDICTORPALETTEENTRIES = layout.offsetof(35);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH265PictureParameterSet, Buffer>
    implements NativeResource {
        private static final StdVideoH265PictureParameterSet ELEMENT_FACTORY = StdVideoH265PictureParameterSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoH265PictureParameterSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoH265PpsFlags flags() {
            return StdVideoH265PictureParameterSet.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pps_pic_parameter_set_id() {
            return StdVideoH265PictureParameterSet.npps_pic_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pps_seq_parameter_set_id() {
            return StdVideoH265PictureParameterSet.npps_seq_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte sps_video_parameter_set_id() {
            return StdVideoH265PictureParameterSet.nsps_video_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_extra_slice_header_bits() {
            return StdVideoH265PictureParameterSet.nnum_extra_slice_header_bits(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l0_default_active_minus1() {
            return StdVideoH265PictureParameterSet.nnum_ref_idx_l0_default_active_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l1_default_active_minus1() {
            return StdVideoH265PictureParameterSet.nnum_ref_idx_l1_default_active_minus1(this.address());
        }

        @NativeType(value="int8_t")
        public byte init_qp_minus26() {
            return StdVideoH265PictureParameterSet.ninit_qp_minus26(this.address());
        }

        @NativeType(value="uint8_t")
        public byte diff_cu_qp_delta_depth() {
            return StdVideoH265PictureParameterSet.ndiff_cu_qp_delta_depth(this.address());
        }

        @NativeType(value="int8_t")
        public byte pps_cb_qp_offset() {
            return StdVideoH265PictureParameterSet.npps_cb_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte pps_cr_qp_offset() {
            return StdVideoH265PictureParameterSet.npps_cr_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte pps_beta_offset_div2() {
            return StdVideoH265PictureParameterSet.npps_beta_offset_div2(this.address());
        }

        @NativeType(value="int8_t")
        public byte pps_tc_offset_div2() {
            return StdVideoH265PictureParameterSet.npps_tc_offset_div2(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_parallel_merge_level_minus2() {
            return StdVideoH265PictureParameterSet.nlog2_parallel_merge_level_minus2(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_max_transform_skip_block_size_minus2() {
            return StdVideoH265PictureParameterSet.nlog2_max_transform_skip_block_size_minus2(this.address());
        }

        @NativeType(value="uint8_t")
        public byte diff_cu_chroma_qp_offset_depth() {
            return StdVideoH265PictureParameterSet.ndiff_cu_chroma_qp_offset_depth(this.address());
        }

        @NativeType(value="uint8_t")
        public byte chroma_qp_offset_list_len_minus1() {
            return StdVideoH265PictureParameterSet.nchroma_qp_offset_list_len_minus1(this.address());
        }

        @NativeType(value="int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]")
        public ByteBuffer cb_qp_offset_list() {
            return StdVideoH265PictureParameterSet.ncb_qp_offset_list(this.address());
        }

        @NativeType(value="int8_t")
        public byte cb_qp_offset_list(int index) {
            return StdVideoH265PictureParameterSet.ncb_qp_offset_list(this.address(), index);
        }

        @NativeType(value="int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]")
        public ByteBuffer cr_qp_offset_list() {
            return StdVideoH265PictureParameterSet.ncr_qp_offset_list(this.address());
        }

        @NativeType(value="int8_t")
        public byte cr_qp_offset_list(int index) {
            return StdVideoH265PictureParameterSet.ncr_qp_offset_list(this.address(), index);
        }

        @NativeType(value="uint8_t")
        public byte log2_sao_offset_scale_luma() {
            return StdVideoH265PictureParameterSet.nlog2_sao_offset_scale_luma(this.address());
        }

        @NativeType(value="uint8_t")
        public byte log2_sao_offset_scale_chroma() {
            return StdVideoH265PictureParameterSet.nlog2_sao_offset_scale_chroma(this.address());
        }

        @NativeType(value="int8_t")
        public byte pps_act_y_qp_offset_plus5() {
            return StdVideoH265PictureParameterSet.npps_act_y_qp_offset_plus5(this.address());
        }

        @NativeType(value="int8_t")
        public byte pps_act_cb_qp_offset_plus5() {
            return StdVideoH265PictureParameterSet.npps_act_cb_qp_offset_plus5(this.address());
        }

        @NativeType(value="int8_t")
        public byte pps_act_cr_qp_offset_plus3() {
            return StdVideoH265PictureParameterSet.npps_act_cr_qp_offset_plus3(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pps_num_palette_predictor_initializers() {
            return StdVideoH265PictureParameterSet.npps_num_palette_predictor_initializers(this.address());
        }

        @NativeType(value="uint8_t")
        public byte luma_bit_depth_entry_minus8() {
            return StdVideoH265PictureParameterSet.nluma_bit_depth_entry_minus8(this.address());
        }

        @NativeType(value="uint8_t")
        public byte chroma_bit_depth_entry_minus8() {
            return StdVideoH265PictureParameterSet.nchroma_bit_depth_entry_minus8(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_tile_columns_minus1() {
            return StdVideoH265PictureParameterSet.nnum_tile_columns_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_tile_rows_minus1() {
            return StdVideoH265PictureParameterSet.nnum_tile_rows_minus1(this.address());
        }

        @NativeType(value="uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_COLS_LIST_SIZE]")
        public ShortBuffer column_width_minus1() {
            return StdVideoH265PictureParameterSet.ncolumn_width_minus1(this.address());
        }

        @NativeType(value="uint16_t")
        public short column_width_minus1(int index) {
            return StdVideoH265PictureParameterSet.ncolumn_width_minus1(this.address(), index);
        }

        @NativeType(value="uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_ROWS_LIST_SIZE]")
        public ShortBuffer row_height_minus1() {
            return StdVideoH265PictureParameterSet.nrow_height_minus1(this.address());
        }

        @NativeType(value="uint16_t")
        public short row_height_minus1(int index) {
            return StdVideoH265PictureParameterSet.nrow_height_minus1(this.address(), index);
        }

        @NativeType(value="StdVideoH265ScalingLists const *")
        public StdVideoH265ScalingLists pScalingLists() {
            return StdVideoH265PictureParameterSet.npScalingLists(this.address());
        }

        @NativeType(value="StdVideoH265PredictorPaletteEntries const *")
        public StdVideoH265PredictorPaletteEntries pPredictorPaletteEntries() {
            return StdVideoH265PictureParameterSet.npPredictorPaletteEntries(this.address());
        }

        public Buffer flags(StdVideoH265PpsFlags value) {
            StdVideoH265PictureParameterSet.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoH265PpsFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer pps_pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_pic_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer pps_seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_seq_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer sps_video_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nsps_video_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer num_extra_slice_header_bits(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nnum_extra_slice_header_bits(this.address(), value);
            return this;
        }

        public Buffer num_ref_idx_l0_default_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nnum_ref_idx_l0_default_active_minus1(this.address(), value);
            return this;
        }

        public Buffer num_ref_idx_l1_default_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nnum_ref_idx_l1_default_active_minus1(this.address(), value);
            return this;
        }

        public Buffer init_qp_minus26(@NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.ninit_qp_minus26(this.address(), value);
            return this;
        }

        public Buffer diff_cu_qp_delta_depth(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.ndiff_cu_qp_delta_depth(this.address(), value);
            return this;
        }

        public Buffer pps_cb_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_cb_qp_offset(this.address(), value);
            return this;
        }

        public Buffer pps_cr_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_cr_qp_offset(this.address(), value);
            return this;
        }

        public Buffer pps_beta_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_beta_offset_div2(this.address(), value);
            return this;
        }

        public Buffer pps_tc_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_tc_offset_div2(this.address(), value);
            return this;
        }

        public Buffer log2_parallel_merge_level_minus2(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nlog2_parallel_merge_level_minus2(this.address(), value);
            return this;
        }

        public Buffer log2_max_transform_skip_block_size_minus2(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nlog2_max_transform_skip_block_size_minus2(this.address(), value);
            return this;
        }

        public Buffer diff_cu_chroma_qp_offset_depth(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.ndiff_cu_chroma_qp_offset_depth(this.address(), value);
            return this;
        }

        public Buffer chroma_qp_offset_list_len_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nchroma_qp_offset_list_len_minus1(this.address(), value);
            return this;
        }

        public Buffer cb_qp_offset_list(@NativeType(value="int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]") ByteBuffer value) {
            StdVideoH265PictureParameterSet.ncb_qp_offset_list(this.address(), value);
            return this;
        }

        public Buffer cb_qp_offset_list(int index, @NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.ncb_qp_offset_list(this.address(), index, value);
            return this;
        }

        public Buffer cr_qp_offset_list(@NativeType(value="int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]") ByteBuffer value) {
            StdVideoH265PictureParameterSet.ncr_qp_offset_list(this.address(), value);
            return this;
        }

        public Buffer cr_qp_offset_list(int index, @NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.ncr_qp_offset_list(this.address(), index, value);
            return this;
        }

        public Buffer log2_sao_offset_scale_luma(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nlog2_sao_offset_scale_luma(this.address(), value);
            return this;
        }

        public Buffer log2_sao_offset_scale_chroma(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nlog2_sao_offset_scale_chroma(this.address(), value);
            return this;
        }

        public Buffer pps_act_y_qp_offset_plus5(@NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_act_y_qp_offset_plus5(this.address(), value);
            return this;
        }

        public Buffer pps_act_cb_qp_offset_plus5(@NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_act_cb_qp_offset_plus5(this.address(), value);
            return this;
        }

        public Buffer pps_act_cr_qp_offset_plus3(@NativeType(value="int8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_act_cr_qp_offset_plus3(this.address(), value);
            return this;
        }

        public Buffer pps_num_palette_predictor_initializers(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.npps_num_palette_predictor_initializers(this.address(), value);
            return this;
        }

        public Buffer luma_bit_depth_entry_minus8(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nluma_bit_depth_entry_minus8(this.address(), value);
            return this;
        }

        public Buffer chroma_bit_depth_entry_minus8(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nchroma_bit_depth_entry_minus8(this.address(), value);
            return this;
        }

        public Buffer num_tile_columns_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nnum_tile_columns_minus1(this.address(), value);
            return this;
        }

        public Buffer num_tile_rows_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoH265PictureParameterSet.nnum_tile_rows_minus1(this.address(), value);
            return this;
        }

        public Buffer column_width_minus1(@NativeType(value="uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_COLS_LIST_SIZE]") ShortBuffer value) {
            StdVideoH265PictureParameterSet.ncolumn_width_minus1(this.address(), value);
            return this;
        }

        public Buffer column_width_minus1(int index, @NativeType(value="uint16_t") short value) {
            StdVideoH265PictureParameterSet.ncolumn_width_minus1(this.address(), index, value);
            return this;
        }

        public Buffer row_height_minus1(@NativeType(value="uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_ROWS_LIST_SIZE]") ShortBuffer value) {
            StdVideoH265PictureParameterSet.nrow_height_minus1(this.address(), value);
            return this;
        }

        public Buffer row_height_minus1(int index, @NativeType(value="uint16_t") short value) {
            StdVideoH265PictureParameterSet.nrow_height_minus1(this.address(), index, value);
            return this;
        }

        public Buffer pScalingLists(@NativeType(value="StdVideoH265ScalingLists const *") StdVideoH265ScalingLists value) {
            StdVideoH265PictureParameterSet.npScalingLists(this.address(), value);
            return this;
        }

        public Buffer pPredictorPaletteEntries(@NativeType(value="StdVideoH265PredictorPaletteEntries const *") StdVideoH265PredictorPaletteEntries value) {
            StdVideoH265PictureParameterSet.npPredictorPaletteEntries(this.address(), value);
            return this;
        }
    }
}

