/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoDecodeH264PictureInfoFlags;

public class StdVideoDecodeH264PictureInfo
extends Struct<StdVideoDecodeH264PictureInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int SEQ_PARAMETER_SET_ID;
    public static final int PIC_PARAMETER_SET_ID;
    public static final int RESERVED1;
    public static final int RESERVED2;
    public static final int FRAME_NUM;
    public static final int IDR_PIC_ID;
    public static final int PICORDERCNT;

    protected StdVideoDecodeH264PictureInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoDecodeH264PictureInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoDecodeH264PictureInfo(address, container);
    }

    public StdVideoDecodeH264PictureInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoDecodeH264PictureInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoDecodeH264PictureInfoFlags flags() {
        return StdVideoDecodeH264PictureInfo.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte seq_parameter_set_id() {
        return StdVideoDecodeH264PictureInfo.nseq_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pic_parameter_set_id() {
        return StdVideoDecodeH264PictureInfo.npic_parameter_set_id(this.address());
    }

    @NativeType(value="uint16_t")
    public short frame_num() {
        return StdVideoDecodeH264PictureInfo.nframe_num(this.address());
    }

    @NativeType(value="uint16_t")
    public short idr_pic_id() {
        return StdVideoDecodeH264PictureInfo.nidr_pic_id(this.address());
    }

    @NativeType(value="int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]")
    public IntBuffer PicOrderCnt() {
        return StdVideoDecodeH264PictureInfo.nPicOrderCnt(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCnt(int index) {
        return StdVideoDecodeH264PictureInfo.nPicOrderCnt(this.address(), index);
    }

    public StdVideoDecodeH264PictureInfo flags(StdVideoDecodeH264PictureInfoFlags value) {
        StdVideoDecodeH264PictureInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264PictureInfo flags(Consumer<StdVideoDecodeH264PictureInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoDecodeH264PictureInfo seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH264PictureInfo.nseq_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264PictureInfo pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeH264PictureInfo.npic_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264PictureInfo frame_num(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264PictureInfo.nframe_num(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264PictureInfo idr_pic_id(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264PictureInfo.nidr_pic_id(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264PictureInfo PicOrderCnt(@NativeType(value="int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]") IntBuffer value) {
        StdVideoDecodeH264PictureInfo.nPicOrderCnt(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264PictureInfo PicOrderCnt(int index, @NativeType(value="int32_t") int value) {
        StdVideoDecodeH264PictureInfo.nPicOrderCnt(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH264PictureInfo set(StdVideoDecodeH264PictureInfoFlags flags, byte seq_parameter_set_id, byte pic_parameter_set_id, short frame_num, short idr_pic_id, IntBuffer PicOrderCnt) {
        this.flags(flags);
        this.seq_parameter_set_id(seq_parameter_set_id);
        this.pic_parameter_set_id(pic_parameter_set_id);
        this.frame_num(frame_num);
        this.idr_pic_id(idr_pic_id);
        this.PicOrderCnt(PicOrderCnt);
        return this;
    }

    public StdVideoDecodeH264PictureInfo set(StdVideoDecodeH264PictureInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoDecodeH264PictureInfo malloc() {
        return new StdVideoDecodeH264PictureInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoDecodeH264PictureInfo calloc() {
        return new StdVideoDecodeH264PictureInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoDecodeH264PictureInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoDecodeH264PictureInfo(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoDecodeH264PictureInfo create(long address) {
        return new StdVideoDecodeH264PictureInfo(address, null);
    }

    @Nullable
    public static StdVideoDecodeH264PictureInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoDecodeH264PictureInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoDecodeH264PictureInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoDecodeH264PictureInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoDecodeH264PictureInfo malloc(MemoryStack stack) {
        return new StdVideoDecodeH264PictureInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoDecodeH264PictureInfo calloc(MemoryStack stack) {
        return new StdVideoDecodeH264PictureInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoDecodeH264PictureInfoFlags nflags(long struct) {
        return StdVideoDecodeH264PictureInfoFlags.create(struct + (long)FLAGS);
    }

    public static byte nseq_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)SEQ_PARAMETER_SET_ID);
    }

    public static byte npic_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)PIC_PARAMETER_SET_ID);
    }

    public static byte nreserved1(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED1);
    }

    public static byte nreserved2(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED2);
    }

    public static short nframe_num(long struct) {
        return UNSAFE.getShort(null, struct + (long)FRAME_NUM);
    }

    public static short nidr_pic_id(long struct) {
        return UNSAFE.getShort(null, struct + (long)IDR_PIC_ID);
    }

    public static IntBuffer nPicOrderCnt(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)PICORDERCNT, 2);
    }

    public static int nPicOrderCnt(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)PICORDERCNT + Checks.check(index, 2) * 4L);
    }

    public static void nflags(long struct, StdVideoDecodeH264PictureInfoFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoDecodeH264PictureInfoFlags.SIZEOF);
    }

    public static void nseq_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SEQ_PARAMETER_SET_ID, value);
    }

    public static void npic_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PIC_PARAMETER_SET_ID, value);
    }

    public static void nreserved1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED1, value);
    }

    public static void nreserved2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED2, value);
    }

    public static void nframe_num(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)FRAME_NUM, value);
    }

    public static void nidr_pic_id(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)IDR_PIC_ID, value);
    }

    public static void nPicOrderCnt(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)PICORDERCNT, value.remaining() * 4);
    }

    public static void nPicOrderCnt(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)PICORDERCNT + Checks.check(index, 2) * 4L, value);
    }

    static {
        Struct.Layout layout = StdVideoDecodeH264PictureInfo.__struct(StdVideoDecodeH264PictureInfo.__member(StdVideoDecodeH264PictureInfoFlags.SIZEOF, StdVideoDecodeH264PictureInfoFlags.ALIGNOF), StdVideoDecodeH264PictureInfo.__member(1), StdVideoDecodeH264PictureInfo.__member(1), StdVideoDecodeH264PictureInfo.__member(1), StdVideoDecodeH264PictureInfo.__member(1), StdVideoDecodeH264PictureInfo.__member(2), StdVideoDecodeH264PictureInfo.__member(2), StdVideoDecodeH264PictureInfo.__array(4, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        SEQ_PARAMETER_SET_ID = layout.offsetof(1);
        PIC_PARAMETER_SET_ID = layout.offsetof(2);
        RESERVED1 = layout.offsetof(3);
        RESERVED2 = layout.offsetof(4);
        FRAME_NUM = layout.offsetof(5);
        IDR_PIC_ID = layout.offsetof(6);
        PICORDERCNT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<StdVideoDecodeH264PictureInfo, Buffer>
    implements NativeResource {
        private static final StdVideoDecodeH264PictureInfo ELEMENT_FACTORY = StdVideoDecodeH264PictureInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoDecodeH264PictureInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoDecodeH264PictureInfoFlags flags() {
            return StdVideoDecodeH264PictureInfo.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte seq_parameter_set_id() {
            return StdVideoDecodeH264PictureInfo.nseq_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pic_parameter_set_id() {
            return StdVideoDecodeH264PictureInfo.npic_parameter_set_id(this.address());
        }

        @NativeType(value="uint16_t")
        public short frame_num() {
            return StdVideoDecodeH264PictureInfo.nframe_num(this.address());
        }

        @NativeType(value="uint16_t")
        public short idr_pic_id() {
            return StdVideoDecodeH264PictureInfo.nidr_pic_id(this.address());
        }

        @NativeType(value="int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]")
        public IntBuffer PicOrderCnt() {
            return StdVideoDecodeH264PictureInfo.nPicOrderCnt(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCnt(int index) {
            return StdVideoDecodeH264PictureInfo.nPicOrderCnt(this.address(), index);
        }

        public Buffer flags(StdVideoDecodeH264PictureInfoFlags value) {
            StdVideoDecodeH264PictureInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoDecodeH264PictureInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH264PictureInfo.nseq_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeH264PictureInfo.npic_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer frame_num(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264PictureInfo.nframe_num(this.address(), value);
            return this;
        }

        public Buffer idr_pic_id(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264PictureInfo.nidr_pic_id(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(@NativeType(value="int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]") IntBuffer value) {
            StdVideoDecodeH264PictureInfo.nPicOrderCnt(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(int index, @NativeType(value="int32_t") int value) {
            StdVideoDecodeH264PictureInfo.nPicOrderCnt(this.address(), index, value);
            return this;
        }
    }
}

