/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoAV1ColorConfig;
import org.lwjgl.vulkan.video.StdVideoAV1SequenceHeaderFlags;
import org.lwjgl.vulkan.video.StdVideoAV1TimingInfo;

public class StdVideoAV1SequenceHeader
extends Struct<StdVideoAV1SequenceHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int SEQ_PROFILE;
    public static final int FRAME_WIDTH_BITS_MINUS_1;
    public static final int FRAME_HEIGHT_BITS_MINUS_1;
    public static final int MAX_FRAME_WIDTH_MINUS_1;
    public static final int MAX_FRAME_HEIGHT_MINUS_1;
    public static final int DELTA_FRAME_ID_LENGTH_MINUS_2;
    public static final int ADDITIONAL_FRAME_ID_LENGTH_MINUS_1;
    public static final int ORDER_HINT_BITS_MINUS_1;
    public static final int SEQ_FORCE_INTEGER_MV;
    public static final int SEQ_FORCE_SCREEN_CONTENT_TOOLS;
    public static final int RESERVED1;
    public static final int PCOLORCONFIG;
    public static final int PTIMINGINFO;

    protected StdVideoAV1SequenceHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoAV1SequenceHeader create(long address, @Nullable ByteBuffer container) {
        return new StdVideoAV1SequenceHeader(address, container);
    }

    public StdVideoAV1SequenceHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoAV1SequenceHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoAV1SequenceHeaderFlags flags() {
        return StdVideoAV1SequenceHeader.nflags(this.address());
    }

    @NativeType(value="StdVideoAV1Profile")
    public int seq_profile() {
        return StdVideoAV1SequenceHeader.nseq_profile(this.address());
    }

    @NativeType(value="uint8_t")
    public byte frame_width_bits_minus_1() {
        return StdVideoAV1SequenceHeader.nframe_width_bits_minus_1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte frame_height_bits_minus_1() {
        return StdVideoAV1SequenceHeader.nframe_height_bits_minus_1(this.address());
    }

    @NativeType(value="uint16_t")
    public short max_frame_width_minus_1() {
        return StdVideoAV1SequenceHeader.nmax_frame_width_minus_1(this.address());
    }

    @NativeType(value="uint16_t")
    public short max_frame_height_minus_1() {
        return StdVideoAV1SequenceHeader.nmax_frame_height_minus_1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_frame_id_length_minus_2() {
        return StdVideoAV1SequenceHeader.ndelta_frame_id_length_minus_2(this.address());
    }

    @NativeType(value="uint8_t")
    public byte additional_frame_id_length_minus_1() {
        return StdVideoAV1SequenceHeader.nadditional_frame_id_length_minus_1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte order_hint_bits_minus_1() {
        return StdVideoAV1SequenceHeader.norder_hint_bits_minus_1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte seq_force_integer_mv() {
        return StdVideoAV1SequenceHeader.nseq_force_integer_mv(this.address());
    }

    @NativeType(value="uint8_t")
    public byte seq_force_screen_content_tools() {
        return StdVideoAV1SequenceHeader.nseq_force_screen_content_tools(this.address());
    }

    @NativeType(value="StdVideoAV1ColorConfig const *")
    public StdVideoAV1ColorConfig pColorConfig() {
        return StdVideoAV1SequenceHeader.npColorConfig(this.address());
    }

    @NativeType(value="StdVideoAV1TimingInfo const *")
    public StdVideoAV1TimingInfo pTimingInfo() {
        return StdVideoAV1SequenceHeader.npTimingInfo(this.address());
    }

    public StdVideoAV1SequenceHeader flags(StdVideoAV1SequenceHeaderFlags value) {
        StdVideoAV1SequenceHeader.nflags(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader flags(Consumer<StdVideoAV1SequenceHeaderFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoAV1SequenceHeader seq_profile(@NativeType(value="StdVideoAV1Profile") int value) {
        StdVideoAV1SequenceHeader.nseq_profile(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader frame_width_bits_minus_1(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1SequenceHeader.nframe_width_bits_minus_1(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader frame_height_bits_minus_1(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1SequenceHeader.nframe_height_bits_minus_1(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader max_frame_width_minus_1(@NativeType(value="uint16_t") short value) {
        StdVideoAV1SequenceHeader.nmax_frame_width_minus_1(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader max_frame_height_minus_1(@NativeType(value="uint16_t") short value) {
        StdVideoAV1SequenceHeader.nmax_frame_height_minus_1(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader delta_frame_id_length_minus_2(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1SequenceHeader.ndelta_frame_id_length_minus_2(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader additional_frame_id_length_minus_1(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1SequenceHeader.nadditional_frame_id_length_minus_1(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader order_hint_bits_minus_1(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1SequenceHeader.norder_hint_bits_minus_1(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader seq_force_integer_mv(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1SequenceHeader.nseq_force_integer_mv(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader seq_force_screen_content_tools(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1SequenceHeader.nseq_force_screen_content_tools(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader pColorConfig(@NativeType(value="StdVideoAV1ColorConfig const *") StdVideoAV1ColorConfig value) {
        StdVideoAV1SequenceHeader.npColorConfig(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader pTimingInfo(@NativeType(value="StdVideoAV1TimingInfo const *") StdVideoAV1TimingInfo value) {
        StdVideoAV1SequenceHeader.npTimingInfo(this.address(), value);
        return this;
    }

    public StdVideoAV1SequenceHeader set(StdVideoAV1SequenceHeaderFlags flags, int seq_profile, byte frame_width_bits_minus_1, byte frame_height_bits_minus_1, short max_frame_width_minus_1, short max_frame_height_minus_1, byte delta_frame_id_length_minus_2, byte additional_frame_id_length_minus_1, byte order_hint_bits_minus_1, byte seq_force_integer_mv, byte seq_force_screen_content_tools, StdVideoAV1ColorConfig pColorConfig, StdVideoAV1TimingInfo pTimingInfo) {
        this.flags(flags);
        this.seq_profile(seq_profile);
        this.frame_width_bits_minus_1(frame_width_bits_minus_1);
        this.frame_height_bits_minus_1(frame_height_bits_minus_1);
        this.max_frame_width_minus_1(max_frame_width_minus_1);
        this.max_frame_height_minus_1(max_frame_height_minus_1);
        this.delta_frame_id_length_minus_2(delta_frame_id_length_minus_2);
        this.additional_frame_id_length_minus_1(additional_frame_id_length_minus_1);
        this.order_hint_bits_minus_1(order_hint_bits_minus_1);
        this.seq_force_integer_mv(seq_force_integer_mv);
        this.seq_force_screen_content_tools(seq_force_screen_content_tools);
        this.pColorConfig(pColorConfig);
        this.pTimingInfo(pTimingInfo);
        return this;
    }

    public StdVideoAV1SequenceHeader set(StdVideoAV1SequenceHeader src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoAV1SequenceHeader malloc() {
        return new StdVideoAV1SequenceHeader(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoAV1SequenceHeader calloc() {
        return new StdVideoAV1SequenceHeader(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoAV1SequenceHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoAV1SequenceHeader(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoAV1SequenceHeader create(long address) {
        return new StdVideoAV1SequenceHeader(address, null);
    }

    @Nullable
    public static StdVideoAV1SequenceHeader createSafe(long address) {
        return address == 0L ? null : new StdVideoAV1SequenceHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoAV1SequenceHeader.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoAV1SequenceHeader.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoAV1SequenceHeader malloc(MemoryStack stack) {
        return new StdVideoAV1SequenceHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoAV1SequenceHeader calloc(MemoryStack stack) {
        return new StdVideoAV1SequenceHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoAV1SequenceHeaderFlags nflags(long struct) {
        return StdVideoAV1SequenceHeaderFlags.create(struct + (long)FLAGS);
    }

    public static int nseq_profile(long struct) {
        return UNSAFE.getInt(null, struct + (long)SEQ_PROFILE);
    }

    public static byte nframe_width_bits_minus_1(long struct) {
        return UNSAFE.getByte(null, struct + (long)FRAME_WIDTH_BITS_MINUS_1);
    }

    public static byte nframe_height_bits_minus_1(long struct) {
        return UNSAFE.getByte(null, struct + (long)FRAME_HEIGHT_BITS_MINUS_1);
    }

    public static short nmax_frame_width_minus_1(long struct) {
        return UNSAFE.getShort(null, struct + (long)MAX_FRAME_WIDTH_MINUS_1);
    }

    public static short nmax_frame_height_minus_1(long struct) {
        return UNSAFE.getShort(null, struct + (long)MAX_FRAME_HEIGHT_MINUS_1);
    }

    public static byte ndelta_frame_id_length_minus_2(long struct) {
        return UNSAFE.getByte(null, struct + (long)DELTA_FRAME_ID_LENGTH_MINUS_2);
    }

    public static byte nadditional_frame_id_length_minus_1(long struct) {
        return UNSAFE.getByte(null, struct + (long)ADDITIONAL_FRAME_ID_LENGTH_MINUS_1);
    }

    public static byte norder_hint_bits_minus_1(long struct) {
        return UNSAFE.getByte(null, struct + (long)ORDER_HINT_BITS_MINUS_1);
    }

    public static byte nseq_force_integer_mv(long struct) {
        return UNSAFE.getByte(null, struct + (long)SEQ_FORCE_INTEGER_MV);
    }

    public static byte nseq_force_screen_content_tools(long struct) {
        return UNSAFE.getByte(null, struct + (long)SEQ_FORCE_SCREEN_CONTENT_TOOLS);
    }

    public static ByteBuffer nreserved1(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED1, 5);
    }

    public static byte nreserved1(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)RESERVED1 + Checks.check(index, 5) * 1L);
    }

    public static StdVideoAV1ColorConfig npColorConfig(long struct) {
        return StdVideoAV1ColorConfig.create(MemoryUtil.memGetAddress(struct + (long)PCOLORCONFIG));
    }

    public static StdVideoAV1TimingInfo npTimingInfo(long struct) {
        return StdVideoAV1TimingInfo.create(MemoryUtil.memGetAddress(struct + (long)PTIMINGINFO));
    }

    public static void nflags(long struct, StdVideoAV1SequenceHeaderFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoAV1SequenceHeaderFlags.SIZEOF);
    }

    public static void nseq_profile(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SEQ_PROFILE, value);
    }

    public static void nframe_width_bits_minus_1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)FRAME_WIDTH_BITS_MINUS_1, value);
    }

    public static void nframe_height_bits_minus_1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)FRAME_HEIGHT_BITS_MINUS_1, value);
    }

    public static void nmax_frame_width_minus_1(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)MAX_FRAME_WIDTH_MINUS_1, value);
    }

    public static void nmax_frame_height_minus_1(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)MAX_FRAME_HEIGHT_MINUS_1, value);
    }

    public static void ndelta_frame_id_length_minus_2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_FRAME_ID_LENGTH_MINUS_2, value);
    }

    public static void nadditional_frame_id_length_minus_1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)ADDITIONAL_FRAME_ID_LENGTH_MINUS_1, value);
    }

    public static void norder_hint_bits_minus_1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)ORDER_HINT_BITS_MINUS_1, value);
    }

    public static void nseq_force_integer_mv(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SEQ_FORCE_INTEGER_MV, value);
    }

    public static void nseq_force_screen_content_tools(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SEQ_FORCE_SCREEN_CONTENT_TOOLS, value);
    }

    public static void nreserved1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 5);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED1, value.remaining() * 1);
    }

    public static void nreserved1(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED1 + Checks.check(index, 5) * 1L, value);
    }

    public static void npColorConfig(long struct, StdVideoAV1ColorConfig value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORCONFIG, value.address());
    }

    public static void npTimingInfo(long struct, StdVideoAV1TimingInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PTIMINGINFO, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOLORCONFIG));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PTIMINGINFO));
    }

    static {
        Struct.Layout layout = StdVideoAV1SequenceHeader.__struct(StdVideoAV1SequenceHeader.__member(StdVideoAV1SequenceHeaderFlags.SIZEOF, StdVideoAV1SequenceHeaderFlags.ALIGNOF), StdVideoAV1SequenceHeader.__member(4), StdVideoAV1SequenceHeader.__member(1), StdVideoAV1SequenceHeader.__member(1), StdVideoAV1SequenceHeader.__member(2), StdVideoAV1SequenceHeader.__member(2), StdVideoAV1SequenceHeader.__member(1), StdVideoAV1SequenceHeader.__member(1), StdVideoAV1SequenceHeader.__member(1), StdVideoAV1SequenceHeader.__member(1), StdVideoAV1SequenceHeader.__member(1), StdVideoAV1SequenceHeader.__array(1, 5), StdVideoAV1SequenceHeader.__member(POINTER_SIZE), StdVideoAV1SequenceHeader.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        SEQ_PROFILE = layout.offsetof(1);
        FRAME_WIDTH_BITS_MINUS_1 = layout.offsetof(2);
        FRAME_HEIGHT_BITS_MINUS_1 = layout.offsetof(3);
        MAX_FRAME_WIDTH_MINUS_1 = layout.offsetof(4);
        MAX_FRAME_HEIGHT_MINUS_1 = layout.offsetof(5);
        DELTA_FRAME_ID_LENGTH_MINUS_2 = layout.offsetof(6);
        ADDITIONAL_FRAME_ID_LENGTH_MINUS_1 = layout.offsetof(7);
        ORDER_HINT_BITS_MINUS_1 = layout.offsetof(8);
        SEQ_FORCE_INTEGER_MV = layout.offsetof(9);
        SEQ_FORCE_SCREEN_CONTENT_TOOLS = layout.offsetof(10);
        RESERVED1 = layout.offsetof(11);
        PCOLORCONFIG = layout.offsetof(12);
        PTIMINGINFO = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<StdVideoAV1SequenceHeader, Buffer>
    implements NativeResource {
        private static final StdVideoAV1SequenceHeader ELEMENT_FACTORY = StdVideoAV1SequenceHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoAV1SequenceHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoAV1SequenceHeaderFlags flags() {
            return StdVideoAV1SequenceHeader.nflags(this.address());
        }

        @NativeType(value="StdVideoAV1Profile")
        public int seq_profile() {
            return StdVideoAV1SequenceHeader.nseq_profile(this.address());
        }

        @NativeType(value="uint8_t")
        public byte frame_width_bits_minus_1() {
            return StdVideoAV1SequenceHeader.nframe_width_bits_minus_1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte frame_height_bits_minus_1() {
            return StdVideoAV1SequenceHeader.nframe_height_bits_minus_1(this.address());
        }

        @NativeType(value="uint16_t")
        public short max_frame_width_minus_1() {
            return StdVideoAV1SequenceHeader.nmax_frame_width_minus_1(this.address());
        }

        @NativeType(value="uint16_t")
        public short max_frame_height_minus_1() {
            return StdVideoAV1SequenceHeader.nmax_frame_height_minus_1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_frame_id_length_minus_2() {
            return StdVideoAV1SequenceHeader.ndelta_frame_id_length_minus_2(this.address());
        }

        @NativeType(value="uint8_t")
        public byte additional_frame_id_length_minus_1() {
            return StdVideoAV1SequenceHeader.nadditional_frame_id_length_minus_1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte order_hint_bits_minus_1() {
            return StdVideoAV1SequenceHeader.norder_hint_bits_minus_1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte seq_force_integer_mv() {
            return StdVideoAV1SequenceHeader.nseq_force_integer_mv(this.address());
        }

        @NativeType(value="uint8_t")
        public byte seq_force_screen_content_tools() {
            return StdVideoAV1SequenceHeader.nseq_force_screen_content_tools(this.address());
        }

        @NativeType(value="StdVideoAV1ColorConfig const *")
        public StdVideoAV1ColorConfig pColorConfig() {
            return StdVideoAV1SequenceHeader.npColorConfig(this.address());
        }

        @NativeType(value="StdVideoAV1TimingInfo const *")
        public StdVideoAV1TimingInfo pTimingInfo() {
            return StdVideoAV1SequenceHeader.npTimingInfo(this.address());
        }

        public Buffer flags(StdVideoAV1SequenceHeaderFlags value) {
            StdVideoAV1SequenceHeader.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoAV1SequenceHeaderFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer seq_profile(@NativeType(value="StdVideoAV1Profile") int value) {
            StdVideoAV1SequenceHeader.nseq_profile(this.address(), value);
            return this;
        }

        public Buffer frame_width_bits_minus_1(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1SequenceHeader.nframe_width_bits_minus_1(this.address(), value);
            return this;
        }

        public Buffer frame_height_bits_minus_1(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1SequenceHeader.nframe_height_bits_minus_1(this.address(), value);
            return this;
        }

        public Buffer max_frame_width_minus_1(@NativeType(value="uint16_t") short value) {
            StdVideoAV1SequenceHeader.nmax_frame_width_minus_1(this.address(), value);
            return this;
        }

        public Buffer max_frame_height_minus_1(@NativeType(value="uint16_t") short value) {
            StdVideoAV1SequenceHeader.nmax_frame_height_minus_1(this.address(), value);
            return this;
        }

        public Buffer delta_frame_id_length_minus_2(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1SequenceHeader.ndelta_frame_id_length_minus_2(this.address(), value);
            return this;
        }

        public Buffer additional_frame_id_length_minus_1(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1SequenceHeader.nadditional_frame_id_length_minus_1(this.address(), value);
            return this;
        }

        public Buffer order_hint_bits_minus_1(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1SequenceHeader.norder_hint_bits_minus_1(this.address(), value);
            return this;
        }

        public Buffer seq_force_integer_mv(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1SequenceHeader.nseq_force_integer_mv(this.address(), value);
            return this;
        }

        public Buffer seq_force_screen_content_tools(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1SequenceHeader.nseq_force_screen_content_tools(this.address(), value);
            return this;
        }

        public Buffer pColorConfig(@NativeType(value="StdVideoAV1ColorConfig const *") StdVideoAV1ColorConfig value) {
            StdVideoAV1SequenceHeader.npColorConfig(this.address(), value);
            return this;
        }

        public Buffer pTimingInfo(@NativeType(value="StdVideoAV1TimingInfo const *") StdVideoAV1TimingInfo value) {
            StdVideoAV1SequenceHeader.npTimingInfo(this.address(), value);
            return this;
        }
    }
}

