/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.awt;

import java.awt.AWTException;
import java.awt.Canvas;
import org.lwjgl.system.Platform;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.awt.PlatformMacOSXVKCanvas;
import org.lwjgl.vulkan.awt.PlatformWin32VKCanvas;
import org.lwjgl.vulkan.awt.PlatformX11VKCanvas;

public class AWTVK {
    public static String getSurfaceExtensionName() {
        switch (Platform.get()) {
            case WINDOWS: {
                return "VK_KHR_win32_surface";
            }
            case MACOSX: {
                return "VK_EXT_metal_surface";
            }
            case LINUX: {
                return "VK_KHR_xlib_surface";
            }
        }
        throw new RuntimeException("Platform " + (Object)((Object)Platform.get()) + " not supported in lwjgl3-awt.");
    }

    public static boolean checkSupport(VkPhysicalDevice physicalDevice, int queueFamilyIndex) {
        switch (Platform.get()) {
            case WINDOWS: {
                return PlatformWin32VKCanvas.checkSupport(physicalDevice, queueFamilyIndex);
            }
            case MACOSX: {
                return PlatformMacOSXVKCanvas.checkSupport(physicalDevice, queueFamilyIndex);
            }
            case LINUX: {
                return PlatformX11VKCanvas.checkSupport(physicalDevice, queueFamilyIndex);
            }
        }
        throw new RuntimeException("Platform " + (Object)((Object)Platform.get()) + " not supported in lwjgl3-awt.");
    }

    public static long create(Canvas canvas, VkInstance instance) throws AWTException {
        switch (Platform.get()) {
            case WINDOWS: {
                return PlatformWin32VKCanvas.create(canvas, instance);
            }
            case MACOSX: {
                return PlatformMacOSXVKCanvas.create(canvas, instance);
            }
            case LINUX: {
                return PlatformX11VKCanvas.create(canvas, instance);
            }
        }
        throw new RuntimeException("Platform " + (Object)((Object)Platform.get()) + " not supported in lwjgl3-awt.");
    }
}

