/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkXlibSurfaceCreateInfoKHR
extends Struct<VkXlibSurfaceCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DPY;
    public static final int WINDOW;

    protected VkXlibSurfaceCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkXlibSurfaceCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkXlibSurfaceCreateInfoKHR(address, container);
    }

    public VkXlibSurfaceCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkXlibSurfaceCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkXlibSurfaceCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkXlibSurfaceCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkXlibSurfaceCreateFlagsKHR")
    public int flags() {
        return VkXlibSurfaceCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="Display *")
    public long dpy() {
        return VkXlibSurfaceCreateInfoKHR.ndpy(this.address());
    }

    @NativeType(value="Window")
    public long window() {
        return VkXlibSurfaceCreateInfoKHR.nwindow(this.address());
    }

    public VkXlibSurfaceCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkXlibSurfaceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR sType$Default() {
        return this.sType(1000004000);
    }

    public VkXlibSurfaceCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkXlibSurfaceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR flags(@NativeType(value="VkXlibSurfaceCreateFlagsKHR") int value) {
        VkXlibSurfaceCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR dpy(@NativeType(value="Display *") long value) {
        VkXlibSurfaceCreateInfoKHR.ndpy(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR window(@NativeType(value="Window") long value) {
        VkXlibSurfaceCreateInfoKHR.nwindow(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR set(int sType, long pNext, int flags, long dpy, long window) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.dpy(dpy);
        this.window(window);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR set(VkXlibSurfaceCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkXlibSurfaceCreateInfoKHR malloc() {
        return new VkXlibSurfaceCreateInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkXlibSurfaceCreateInfoKHR calloc() {
        return new VkXlibSurfaceCreateInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkXlibSurfaceCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkXlibSurfaceCreateInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkXlibSurfaceCreateInfoKHR create(long address) {
        return new VkXlibSurfaceCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkXlibSurfaceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkXlibSurfaceCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkXlibSurfaceCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkXlibSurfaceCreateInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkXlibSurfaceCreateInfoKHR mallocStack() {
        return VkXlibSurfaceCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkXlibSurfaceCreateInfoKHR callocStack() {
        return VkXlibSurfaceCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkXlibSurfaceCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkXlibSurfaceCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkXlibSurfaceCreateInfoKHR callocStack(MemoryStack stack) {
        return VkXlibSurfaceCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkXlibSurfaceCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkXlibSurfaceCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkXlibSurfaceCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkXlibSurfaceCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkXlibSurfaceCreateInfoKHR malloc(MemoryStack stack) {
        return new VkXlibSurfaceCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkXlibSurfaceCreateInfoKHR calloc(MemoryStack stack) {
        return new VkXlibSurfaceCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long ndpy(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DPY);
    }

    public static long nwindow(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)WINDOW);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndpy(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DPY, value);
    }

    public static void nwindow(long struct, long value) {
        MemoryUtil.memPutCLong(struct + (long)WINDOW, value);
    }

    static {
        Struct.Layout layout = VkXlibSurfaceCreateInfoKHR.__struct(VkXlibSurfaceCreateInfoKHR.__member(4), VkXlibSurfaceCreateInfoKHR.__member(POINTER_SIZE), VkXlibSurfaceCreateInfoKHR.__member(4), VkXlibSurfaceCreateInfoKHR.__member(POINTER_SIZE), VkXlibSurfaceCreateInfoKHR.__member(CLONG_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DPY = layout.offsetof(3);
        WINDOW = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkXlibSurfaceCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkXlibSurfaceCreateInfoKHR ELEMENT_FACTORY = VkXlibSurfaceCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkXlibSurfaceCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkXlibSurfaceCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkXlibSurfaceCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkXlibSurfaceCreateFlagsKHR")
        public int flags() {
            return VkXlibSurfaceCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="Display *")
        public long dpy() {
            return VkXlibSurfaceCreateInfoKHR.ndpy(this.address());
        }

        @NativeType(value="Window")
        public long window() {
            return VkXlibSurfaceCreateInfoKHR.nwindow(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkXlibSurfaceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000004000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkXlibSurfaceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkXlibSurfaceCreateFlagsKHR") int value) {
            VkXlibSurfaceCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer dpy(@NativeType(value="Display *") long value) {
            VkXlibSurfaceCreateInfoKHR.ndpy(this.address(), value);
            return this;
        }

        public Buffer window(@NativeType(value="Window") long value) {
            VkXlibSurfaceCreateInfoKHR.nwindow(this.address(), value);
            return this;
        }
    }
}

