/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkSurfaceCapabilities2EXT
extends Struct<VkSurfaceCapabilities2EXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MINIMAGECOUNT;
    public static final int MAXIMAGECOUNT;
    public static final int CURRENTEXTENT;
    public static final int MINIMAGEEXTENT;
    public static final int MAXIMAGEEXTENT;
    public static final int MAXIMAGEARRAYLAYERS;
    public static final int SUPPORTEDTRANSFORMS;
    public static final int CURRENTTRANSFORM;
    public static final int SUPPORTEDCOMPOSITEALPHA;
    public static final int SUPPORTEDUSAGEFLAGS;
    public static final int SUPPORTEDSURFACECOUNTERS;

    protected VkSurfaceCapabilities2EXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSurfaceCapabilities2EXT create(long address, @Nullable ByteBuffer container) {
        return new VkSurfaceCapabilities2EXT(address, container);
    }

    public VkSurfaceCapabilities2EXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSurfaceCapabilities2EXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSurfaceCapabilities2EXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkSurfaceCapabilities2EXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int minImageCount() {
        return VkSurfaceCapabilities2EXT.nminImageCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageCount() {
        return VkSurfaceCapabilities2EXT.nmaxImageCount(this.address());
    }

    public VkExtent2D currentExtent() {
        return VkSurfaceCapabilities2EXT.ncurrentExtent(this.address());
    }

    public VkExtent2D minImageExtent() {
        return VkSurfaceCapabilities2EXT.nminImageExtent(this.address());
    }

    public VkExtent2D maxImageExtent() {
        return VkSurfaceCapabilities2EXT.nmaxImageExtent(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageArrayLayers() {
        return VkSurfaceCapabilities2EXT.nmaxImageArrayLayers(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagsKHR")
    public int supportedTransforms() {
        return VkSurfaceCapabilities2EXT.nsupportedTransforms(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagBitsKHR")
    public int currentTransform() {
        return VkSurfaceCapabilities2EXT.ncurrentTransform(this.address());
    }

    @NativeType(value="VkCompositeAlphaFlagsKHR")
    public int supportedCompositeAlpha() {
        return VkSurfaceCapabilities2EXT.nsupportedCompositeAlpha(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int supportedUsageFlags() {
        return VkSurfaceCapabilities2EXT.nsupportedUsageFlags(this.address());
    }

    @NativeType(value="VkSurfaceCounterFlagsEXT")
    public int supportedSurfaceCounters() {
        return VkSurfaceCapabilities2EXT.nsupportedSurfaceCounters(this.address());
    }

    public VkSurfaceCapabilities2EXT sType(@NativeType(value="VkStructureType") int value) {
        VkSurfaceCapabilities2EXT.nsType(this.address(), value);
        return this;
    }

    public VkSurfaceCapabilities2EXT sType$Default() {
        return this.sType(1000090000);
    }

    public VkSurfaceCapabilities2EXT pNext(@NativeType(value="void *") long value) {
        VkSurfaceCapabilities2EXT.npNext(this.address(), value);
        return this;
    }

    public VkSurfaceCapabilities2EXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSurfaceCapabilities2EXT set(VkSurfaceCapabilities2EXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSurfaceCapabilities2EXT malloc() {
        return new VkSurfaceCapabilities2EXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSurfaceCapabilities2EXT calloc() {
        return new VkSurfaceCapabilities2EXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSurfaceCapabilities2EXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSurfaceCapabilities2EXT(MemoryUtil.memAddress(container), container);
    }

    public static VkSurfaceCapabilities2EXT create(long address) {
        return new VkSurfaceCapabilities2EXT(address, null);
    }

    @Nullable
    public static VkSurfaceCapabilities2EXT createSafe(long address) {
        return address == 0L ? null : new VkSurfaceCapabilities2EXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSurfaceCapabilities2EXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSurfaceCapabilities2EXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSurfaceCapabilities2EXT mallocStack() {
        return VkSurfaceCapabilities2EXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceCapabilities2EXT callocStack() {
        return VkSurfaceCapabilities2EXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceCapabilities2EXT mallocStack(MemoryStack stack) {
        return VkSurfaceCapabilities2EXT.malloc(stack);
    }

    @Deprecated
    public static VkSurfaceCapabilities2EXT callocStack(MemoryStack stack) {
        return VkSurfaceCapabilities2EXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSurfaceCapabilities2EXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSurfaceCapabilities2EXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilities2EXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilities2EXT.calloc(capacity, stack);
    }

    public static VkSurfaceCapabilities2EXT malloc(MemoryStack stack) {
        return new VkSurfaceCapabilities2EXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSurfaceCapabilities2EXT calloc(MemoryStack stack) {
        return new VkSurfaceCapabilities2EXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nminImageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINIMAGECOUNT);
    }

    public static int nmaxImageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXIMAGECOUNT);
    }

    public static VkExtent2D ncurrentExtent(long struct) {
        return VkExtent2D.create(struct + (long)CURRENTEXTENT);
    }

    public static VkExtent2D nminImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINIMAGEEXTENT);
    }

    public static VkExtent2D nmaxImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXIMAGEEXTENT);
    }

    public static int nmaxImageArrayLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXIMAGEARRAYLAYERS);
    }

    public static int nsupportedTransforms(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDTRANSFORMS);
    }

    public static int ncurrentTransform(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURRENTTRANSFORM);
    }

    public static int nsupportedCompositeAlpha(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDCOMPOSITEALPHA);
    }

    public static int nsupportedUsageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDUSAGEFLAGS);
    }

    public static int nsupportedSurfaceCounters(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDSURFACECOUNTERS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkSurfaceCapabilities2EXT.__struct(VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(POINTER_SIZE), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilities2EXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilities2EXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4), VkSurfaceCapabilities2EXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MINIMAGECOUNT = layout.offsetof(2);
        MAXIMAGECOUNT = layout.offsetof(3);
        CURRENTEXTENT = layout.offsetof(4);
        MINIMAGEEXTENT = layout.offsetof(5);
        MAXIMAGEEXTENT = layout.offsetof(6);
        MAXIMAGEARRAYLAYERS = layout.offsetof(7);
        SUPPORTEDTRANSFORMS = layout.offsetof(8);
        CURRENTTRANSFORM = layout.offsetof(9);
        SUPPORTEDCOMPOSITEALPHA = layout.offsetof(10);
        SUPPORTEDUSAGEFLAGS = layout.offsetof(11);
        SUPPORTEDSURFACECOUNTERS = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceCapabilities2EXT, Buffer>
    implements NativeResource {
        private static final VkSurfaceCapabilities2EXT ELEMENT_FACTORY = VkSurfaceCapabilities2EXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSurfaceCapabilities2EXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSurfaceCapabilities2EXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkSurfaceCapabilities2EXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int minImageCount() {
            return VkSurfaceCapabilities2EXT.nminImageCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageCount() {
            return VkSurfaceCapabilities2EXT.nmaxImageCount(this.address());
        }

        public VkExtent2D currentExtent() {
            return VkSurfaceCapabilities2EXT.ncurrentExtent(this.address());
        }

        public VkExtent2D minImageExtent() {
            return VkSurfaceCapabilities2EXT.nminImageExtent(this.address());
        }

        public VkExtent2D maxImageExtent() {
            return VkSurfaceCapabilities2EXT.nmaxImageExtent(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageArrayLayers() {
            return VkSurfaceCapabilities2EXT.nmaxImageArrayLayers(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagsKHR")
        public int supportedTransforms() {
            return VkSurfaceCapabilities2EXT.nsupportedTransforms(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagBitsKHR")
        public int currentTransform() {
            return VkSurfaceCapabilities2EXT.ncurrentTransform(this.address());
        }

        @NativeType(value="VkCompositeAlphaFlagsKHR")
        public int supportedCompositeAlpha() {
            return VkSurfaceCapabilities2EXT.nsupportedCompositeAlpha(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int supportedUsageFlags() {
            return VkSurfaceCapabilities2EXT.nsupportedUsageFlags(this.address());
        }

        @NativeType(value="VkSurfaceCounterFlagsEXT")
        public int supportedSurfaceCounters() {
            return VkSurfaceCapabilities2EXT.nsupportedSurfaceCounters(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSurfaceCapabilities2EXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000090000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkSurfaceCapabilities2EXT.npNext(this.address(), value);
            return this;
        }
    }
}

