/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineLayoutCreateInfo;

public class VkSetDescriptorBufferOffsetsInfoEXT
extends Struct<VkSetDescriptorBufferOffsetsInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STAGEFLAGS;
    public static final int LAYOUT;
    public static final int FIRSTSET;
    public static final int SETCOUNT;
    public static final int PBUFFERINDICES;
    public static final int POFFSETS;

    protected VkSetDescriptorBufferOffsetsInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSetDescriptorBufferOffsetsInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkSetDescriptorBufferOffsetsInfoEXT(address, container);
    }

    public VkSetDescriptorBufferOffsetsInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSetDescriptorBufferOffsetsInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSetDescriptorBufferOffsetsInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSetDescriptorBufferOffsetsInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkSetDescriptorBufferOffsetsInfoEXT.nstageFlags(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkSetDescriptorBufferOffsetsInfoEXT.nlayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstSet() {
        return VkSetDescriptorBufferOffsetsInfoEXT.nfirstSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int setCount() {
        return VkSetDescriptorBufferOffsetsInfoEXT.nsetCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer pBufferIndices() {
        return VkSetDescriptorBufferOffsetsInfoEXT.npBufferIndices(this.address());
    }

    @NativeType(value="VkDeviceSize const *")
    public LongBuffer pOffsets() {
        return VkSetDescriptorBufferOffsetsInfoEXT.npOffsets(this.address());
    }

    public VkSetDescriptorBufferOffsetsInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkSetDescriptorBufferOffsetsInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkSetDescriptorBufferOffsetsInfoEXT sType$Default() {
        return this.sType(1000545007);
    }

    public VkSetDescriptorBufferOffsetsInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkSetDescriptorBufferOffsetsInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkSetDescriptorBufferOffsetsInfoEXT pNext(VkPipelineLayoutCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSetDescriptorBufferOffsetsInfoEXT stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkSetDescriptorBufferOffsetsInfoEXT.nstageFlags(this.address(), value);
        return this;
    }

    public VkSetDescriptorBufferOffsetsInfoEXT layout(@NativeType(value="VkPipelineLayout") long value) {
        VkSetDescriptorBufferOffsetsInfoEXT.nlayout(this.address(), value);
        return this;
    }

    public VkSetDescriptorBufferOffsetsInfoEXT firstSet(@NativeType(value="uint32_t") int value) {
        VkSetDescriptorBufferOffsetsInfoEXT.nfirstSet(this.address(), value);
        return this;
    }

    public VkSetDescriptorBufferOffsetsInfoEXT setCount(@NativeType(value="uint32_t") int value) {
        VkSetDescriptorBufferOffsetsInfoEXT.nsetCount(this.address(), value);
        return this;
    }

    public VkSetDescriptorBufferOffsetsInfoEXT pBufferIndices(@NativeType(value="uint32_t const *") IntBuffer value) {
        VkSetDescriptorBufferOffsetsInfoEXT.npBufferIndices(this.address(), value);
        return this;
    }

    public VkSetDescriptorBufferOffsetsInfoEXT pOffsets(@NativeType(value="VkDeviceSize const *") LongBuffer value) {
        VkSetDescriptorBufferOffsetsInfoEXT.npOffsets(this.address(), value);
        return this;
    }

    public VkSetDescriptorBufferOffsetsInfoEXT set(int sType, long pNext, int stageFlags, long layout, int firstSet, int setCount, IntBuffer pBufferIndices, LongBuffer pOffsets) {
        this.sType(sType);
        this.pNext(pNext);
        this.stageFlags(stageFlags);
        this.layout(layout);
        this.firstSet(firstSet);
        this.setCount(setCount);
        this.pBufferIndices(pBufferIndices);
        this.pOffsets(pOffsets);
        return this;
    }

    public VkSetDescriptorBufferOffsetsInfoEXT set(VkSetDescriptorBufferOffsetsInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSetDescriptorBufferOffsetsInfoEXT malloc() {
        return new VkSetDescriptorBufferOffsetsInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSetDescriptorBufferOffsetsInfoEXT calloc() {
        return new VkSetDescriptorBufferOffsetsInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSetDescriptorBufferOffsetsInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSetDescriptorBufferOffsetsInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkSetDescriptorBufferOffsetsInfoEXT create(long address) {
        return new VkSetDescriptorBufferOffsetsInfoEXT(address, null);
    }

    @Nullable
    public static VkSetDescriptorBufferOffsetsInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkSetDescriptorBufferOffsetsInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSetDescriptorBufferOffsetsInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSetDescriptorBufferOffsetsInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkSetDescriptorBufferOffsetsInfoEXT malloc(MemoryStack stack) {
        return new VkSetDescriptorBufferOffsetsInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSetDescriptorBufferOffsetsInfoEXT calloc(MemoryStack stack) {
        return new VkSetDescriptorBufferOffsetsInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nstageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGEFLAGS);
    }

    public static long nlayout(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYOUT);
    }

    public static int nfirstSet(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTSET);
    }

    public static int nsetCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SETCOUNT);
    }

    public static IntBuffer npBufferIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PBUFFERINDICES), VkSetDescriptorBufferOffsetsInfoEXT.nsetCount(struct));
    }

    public static LongBuffer npOffsets(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)POFFSETS), VkSetDescriptorBufferOffsetsInfoEXT.nsetCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nstageFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGEFLAGS, value);
    }

    public static void nlayout(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYOUT, value);
    }

    public static void nfirstSet(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTSET, value);
    }

    public static void nsetCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SETCOUNT, value);
    }

    public static void npBufferIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBUFFERINDICES, MemoryUtil.memAddress(value));
    }

    public static void npOffsets(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)POFFSETS, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PBUFFERINDICES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)POFFSETS));
    }

    static {
        Struct.Layout layout = VkSetDescriptorBufferOffsetsInfoEXT.__struct(VkSetDescriptorBufferOffsetsInfoEXT.__member(4), VkSetDescriptorBufferOffsetsInfoEXT.__member(POINTER_SIZE), VkSetDescriptorBufferOffsetsInfoEXT.__member(4), VkSetDescriptorBufferOffsetsInfoEXT.__member(8), VkSetDescriptorBufferOffsetsInfoEXT.__member(4), VkSetDescriptorBufferOffsetsInfoEXT.__member(4), VkSetDescriptorBufferOffsetsInfoEXT.__member(POINTER_SIZE), VkSetDescriptorBufferOffsetsInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STAGEFLAGS = layout.offsetof(2);
        LAYOUT = layout.offsetof(3);
        FIRSTSET = layout.offsetof(4);
        SETCOUNT = layout.offsetof(5);
        PBUFFERINDICES = layout.offsetof(6);
        POFFSETS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkSetDescriptorBufferOffsetsInfoEXT, Buffer>
    implements NativeResource {
        private static final VkSetDescriptorBufferOffsetsInfoEXT ELEMENT_FACTORY = VkSetDescriptorBufferOffsetsInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSetDescriptorBufferOffsetsInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSetDescriptorBufferOffsetsInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSetDescriptorBufferOffsetsInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkSetDescriptorBufferOffsetsInfoEXT.nstageFlags(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkSetDescriptorBufferOffsetsInfoEXT.nlayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstSet() {
            return VkSetDescriptorBufferOffsetsInfoEXT.nfirstSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int setCount() {
            return VkSetDescriptorBufferOffsetsInfoEXT.nsetCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer pBufferIndices() {
            return VkSetDescriptorBufferOffsetsInfoEXT.npBufferIndices(this.address());
        }

        @NativeType(value="VkDeviceSize const *")
        public LongBuffer pOffsets() {
            return VkSetDescriptorBufferOffsetsInfoEXT.npOffsets(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSetDescriptorBufferOffsetsInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000545007);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSetDescriptorBufferOffsetsInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineLayoutCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkSetDescriptorBufferOffsetsInfoEXT.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkSetDescriptorBufferOffsetsInfoEXT.nlayout(this.address(), value);
            return this;
        }

        public Buffer firstSet(@NativeType(value="uint32_t") int value) {
            VkSetDescriptorBufferOffsetsInfoEXT.nfirstSet(this.address(), value);
            return this;
        }

        public Buffer setCount(@NativeType(value="uint32_t") int value) {
            VkSetDescriptorBufferOffsetsInfoEXT.nsetCount(this.address(), value);
            return this;
        }

        public Buffer pBufferIndices(@NativeType(value="uint32_t const *") IntBuffer value) {
            VkSetDescriptorBufferOffsetsInfoEXT.npBufferIndices(this.address(), value);
            return this;
        }

        public Buffer pOffsets(@NativeType(value="VkDeviceSize const *") LongBuffer value) {
            VkSetDescriptorBufferOffsetsInfoEXT.npOffsets(this.address(), value);
            return this;
        }
    }
}

