/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSemaphoreSubmitInfo;

public class VkRenderPassStripeSubmitInfoARM
extends Struct<VkRenderPassStripeSubmitInfoARM>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STRIPESEMAPHOREINFOCOUNT;
    public static final int PSTRIPESEMAPHOREINFOS;

    protected VkRenderPassStripeSubmitInfoARM(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRenderPassStripeSubmitInfoARM create(long address, @Nullable ByteBuffer container) {
        return new VkRenderPassStripeSubmitInfoARM(address, container);
    }

    public VkRenderPassStripeSubmitInfoARM(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkRenderPassStripeSubmitInfoARM.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassStripeSubmitInfoARM.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassStripeSubmitInfoARM.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int stripeSemaphoreInfoCount() {
        return VkRenderPassStripeSubmitInfoARM.nstripeSemaphoreInfoCount(this.address());
    }

    @NativeType(value="VkSemaphoreSubmitInfo const *")
    public VkSemaphoreSubmitInfo.Buffer pStripeSemaphoreInfos() {
        return VkRenderPassStripeSubmitInfoARM.npStripeSemaphoreInfos(this.address());
    }

    public VkRenderPassStripeSubmitInfoARM sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassStripeSubmitInfoARM.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassStripeSubmitInfoARM sType$Default() {
        return this.sType(1000424004);
    }

    public VkRenderPassStripeSubmitInfoARM pNext(@NativeType(value="void const *") long value) {
        VkRenderPassStripeSubmitInfoARM.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassStripeSubmitInfoARM pStripeSemaphoreInfos(@NativeType(value="VkSemaphoreSubmitInfo const *") VkSemaphoreSubmitInfo.Buffer value) {
        VkRenderPassStripeSubmitInfoARM.npStripeSemaphoreInfos(this.address(), value);
        return this;
    }

    public VkRenderPassStripeSubmitInfoARM set(int sType, long pNext, VkSemaphoreSubmitInfo.Buffer pStripeSemaphoreInfos) {
        this.sType(sType);
        this.pNext(pNext);
        this.pStripeSemaphoreInfos(pStripeSemaphoreInfos);
        return this;
    }

    public VkRenderPassStripeSubmitInfoARM set(VkRenderPassStripeSubmitInfoARM src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassStripeSubmitInfoARM malloc() {
        return new VkRenderPassStripeSubmitInfoARM(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkRenderPassStripeSubmitInfoARM calloc() {
        return new VkRenderPassStripeSubmitInfoARM(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkRenderPassStripeSubmitInfoARM create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkRenderPassStripeSubmitInfoARM(MemoryUtil.memAddress(container), container);
    }

    public static VkRenderPassStripeSubmitInfoARM create(long address) {
        return new VkRenderPassStripeSubmitInfoARM(address, null);
    }

    @Nullable
    public static VkRenderPassStripeSubmitInfoARM createSafe(long address) {
        return address == 0L ? null : new VkRenderPassStripeSubmitInfoARM(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkRenderPassStripeSubmitInfoARM.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassStripeSubmitInfoARM.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderPassStripeSubmitInfoARM malloc(MemoryStack stack) {
        return new VkRenderPassStripeSubmitInfoARM(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderPassStripeSubmitInfoARM calloc(MemoryStack stack) {
        return new VkRenderPassStripeSubmitInfoARM(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nstripeSemaphoreInfoCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)STRIPESEMAPHOREINFOCOUNT);
    }

    public static VkSemaphoreSubmitInfo.Buffer npStripeSemaphoreInfos(long struct) {
        return VkSemaphoreSubmitInfo.create(MemoryUtil.memGetAddress(struct + (long)PSTRIPESEMAPHOREINFOS), VkRenderPassStripeSubmitInfoARM.nstripeSemaphoreInfoCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nstripeSemaphoreInfoCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STRIPESEMAPHOREINFOCOUNT, value);
    }

    public static void npStripeSemaphoreInfos(long struct, VkSemaphoreSubmitInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSTRIPESEMAPHOREINFOS, value.address());
        VkRenderPassStripeSubmitInfoARM.nstripeSemaphoreInfoCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSTRIPESEMAPHOREINFOS));
    }

    static {
        Struct.Layout layout = VkRenderPassStripeSubmitInfoARM.__struct(VkRenderPassStripeSubmitInfoARM.__member(4), VkRenderPassStripeSubmitInfoARM.__member(POINTER_SIZE), VkRenderPassStripeSubmitInfoARM.__member(4), VkRenderPassStripeSubmitInfoARM.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STRIPESEMAPHOREINFOCOUNT = layout.offsetof(2);
        PSTRIPESEMAPHOREINFOS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassStripeSubmitInfoARM, Buffer>
    implements NativeResource {
        private static final VkRenderPassStripeSubmitInfoARM ELEMENT_FACTORY = VkRenderPassStripeSubmitInfoARM.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRenderPassStripeSubmitInfoARM getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassStripeSubmitInfoARM.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassStripeSubmitInfoARM.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int stripeSemaphoreInfoCount() {
            return VkRenderPassStripeSubmitInfoARM.nstripeSemaphoreInfoCount(this.address());
        }

        @NativeType(value="VkSemaphoreSubmitInfo const *")
        public VkSemaphoreSubmitInfo.Buffer pStripeSemaphoreInfos() {
            return VkRenderPassStripeSubmitInfoARM.npStripeSemaphoreInfos(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassStripeSubmitInfoARM.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000424004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassStripeSubmitInfoARM.npNext(this.address(), value);
            return this;
        }

        public Buffer pStripeSemaphoreInfos(@NativeType(value="VkSemaphoreSubmitInfo const *") VkSemaphoreSubmitInfo.Buffer value) {
            VkRenderPassStripeSubmitInfoARM.npStripeSemaphoreInfos(this.address(), value);
            return this;
        }
    }
}

