/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkOffset2D
extends Struct<VkOffset2D>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected VkOffset2D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkOffset2D create(long address, @Nullable ByteBuffer container) {
        return new VkOffset2D(address, container);
    }

    public VkOffset2D(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkOffset2D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int x() {
        return VkOffset2D.nx(this.address());
    }

    @NativeType(value="int32_t")
    public int y() {
        return VkOffset2D.ny(this.address());
    }

    public VkOffset2D x(@NativeType(value="int32_t") int value) {
        VkOffset2D.nx(this.address(), value);
        return this;
    }

    public VkOffset2D y(@NativeType(value="int32_t") int value) {
        VkOffset2D.ny(this.address(), value);
        return this;
    }

    public VkOffset2D set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public VkOffset2D set(VkOffset2D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkOffset2D malloc() {
        return new VkOffset2D(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkOffset2D calloc() {
        return new VkOffset2D(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkOffset2D create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkOffset2D(MemoryUtil.memAddress(container), container);
    }

    public static VkOffset2D create(long address) {
        return new VkOffset2D(address, null);
    }

    @Nullable
    public static VkOffset2D createSafe(long address) {
        return address == 0L ? null : new VkOffset2D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkOffset2D.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkOffset2D.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkOffset2D mallocStack() {
        return VkOffset2D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkOffset2D callocStack() {
        return VkOffset2D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkOffset2D mallocStack(MemoryStack stack) {
        return VkOffset2D.malloc(stack);
    }

    @Deprecated
    public static VkOffset2D callocStack(MemoryStack stack) {
        return VkOffset2D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkOffset2D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkOffset2D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkOffset2D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkOffset2D.calloc(capacity, stack);
    }

    public static VkOffset2D malloc(MemoryStack stack) {
        return new VkOffset2D(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkOffset2D calloc(MemoryStack stack) {
        return new VkOffset2D(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return UNSAFE.getInt(null, struct + (long)X);
    }

    public static int ny(long struct) {
        return UNSAFE.getInt(null, struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = VkOffset2D.__struct(VkOffset2D.__member(4), VkOffset2D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkOffset2D, Buffer>
    implements NativeResource {
        private static final VkOffset2D ELEMENT_FACTORY = VkOffset2D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkOffset2D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int x() {
            return VkOffset2D.nx(this.address());
        }

        @NativeType(value="int32_t")
        public int y() {
            return VkOffset2D.ny(this.address());
        }

        public Buffer x(@NativeType(value="int32_t") int value) {
            VkOffset2D.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int32_t") int value) {
            VkOffset2D.ny(this.address(), value);
            return this;
        }
    }
}

