/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryRequirements
extends Struct<VkMemoryRequirements>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int MEMORYTYPEBITS;

    protected VkMemoryRequirements(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryRequirements create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryRequirements(address, container);
    }

    public VkMemoryRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryRequirements.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryRequirements.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long alignment() {
        return VkMemoryRequirements.nalignment(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryRequirements.nmemoryTypeBits(this.address());
    }

    public VkMemoryRequirements size(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryRequirements.nsize(this.address(), value);
        return this;
    }

    public VkMemoryRequirements alignment(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryRequirements.nalignment(this.address(), value);
        return this;
    }

    public VkMemoryRequirements memoryTypeBits(@NativeType(value="uint32_t") int value) {
        VkMemoryRequirements.nmemoryTypeBits(this.address(), value);
        return this;
    }

    public VkMemoryRequirements set(long size, long alignment, int memoryTypeBits) {
        this.size(size);
        this.alignment(alignment);
        this.memoryTypeBits(memoryTypeBits);
        return this;
    }

    public VkMemoryRequirements set(VkMemoryRequirements src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryRequirements malloc() {
        return new VkMemoryRequirements(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryRequirements calloc() {
        return new VkMemoryRequirements(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryRequirements(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryRequirements create(long address) {
        return new VkMemoryRequirements(address, null);
    }

    @Nullable
    public static VkMemoryRequirements createSafe(long address) {
        return address == 0L ? null : new VkMemoryRequirements(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryRequirements.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryRequirements.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryRequirements mallocStack() {
        return VkMemoryRequirements.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements callocStack() {
        return VkMemoryRequirements.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements mallocStack(MemoryStack stack) {
        return VkMemoryRequirements.malloc(stack);
    }

    @Deprecated
    public static VkMemoryRequirements callocStack(MemoryStack stack) {
        return VkMemoryRequirements.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryRequirements.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryRequirements.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.calloc(capacity, stack);
    }

    public static VkMemoryRequirements malloc(MemoryStack stack) {
        return new VkMemoryRequirements(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryRequirements calloc(MemoryStack stack) {
        return new VkMemoryRequirements(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long nalignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALIGNMENT);
    }

    public static int nmemoryTypeBits(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPEBITS);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nalignment(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ALIGNMENT, value);
    }

    public static void nmemoryTypeBits(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYTYPEBITS, value);
    }

    static {
        Struct.Layout layout = VkMemoryRequirements.__struct(VkMemoryRequirements.__member(8), VkMemoryRequirements.__member(8), VkMemoryRequirements.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        ALIGNMENT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryRequirements, Buffer>
    implements NativeResource {
        private static final VkMemoryRequirements ELEMENT_FACTORY = VkMemoryRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryRequirements.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long alignment() {
            return VkMemoryRequirements.nalignment(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryRequirements.nmemoryTypeBits(this.address());
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryRequirements.nsize(this.address(), value);
            return this;
        }

        public Buffer alignment(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryRequirements.nalignment(this.address(), value);
            return this;
        }

        public Buffer memoryTypeBits(@NativeType(value="uint32_t") int value) {
            VkMemoryRequirements.nmemoryTypeBits(this.address(), value);
            return this;
        }
    }
}

