/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryMapPlacedInfoEXT;

public class VkMemoryMapInfoKHR
extends Struct<VkMemoryMapInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MEMORY;
    public static final int OFFSET;
    public static final int SIZE;

    protected VkMemoryMapInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryMapInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryMapInfoKHR(address, container);
    }

    public VkMemoryMapInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryMapInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryMapInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryMapInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkMemoryMapFlags")
    public int flags() {
        return VkMemoryMapInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMemoryMapInfoKHR.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkMemoryMapInfoKHR.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryMapInfoKHR.nsize(this.address());
    }

    public VkMemoryMapInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryMapInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkMemoryMapInfoKHR sType$Default() {
        return this.sType(1000271000);
    }

    public VkMemoryMapInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryMapInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkMemoryMapInfoKHR pNext(VkMemoryMapPlacedInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryMapInfoKHR flags(@NativeType(value="VkMemoryMapFlags") int value) {
        VkMemoryMapInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkMemoryMapInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryMapInfoKHR.nmemory(this.address(), value);
        return this;
    }

    public VkMemoryMapInfoKHR offset(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryMapInfoKHR.noffset(this.address(), value);
        return this;
    }

    public VkMemoryMapInfoKHR size(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryMapInfoKHR.nsize(this.address(), value);
        return this;
    }

    public VkMemoryMapInfoKHR set(int sType, long pNext, int flags, long memory, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.memory(memory);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkMemoryMapInfoKHR set(VkMemoryMapInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryMapInfoKHR malloc() {
        return new VkMemoryMapInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryMapInfoKHR calloc() {
        return new VkMemoryMapInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryMapInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryMapInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryMapInfoKHR create(long address) {
        return new VkMemoryMapInfoKHR(address, null);
    }

    @Nullable
    public static VkMemoryMapInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkMemoryMapInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryMapInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryMapInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryMapInfoKHR malloc(MemoryStack stack) {
        return new VkMemoryMapInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryMapInfoKHR calloc(MemoryStack stack) {
        return new VkMemoryMapInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void noffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkMemoryMapInfoKHR.__struct(VkMemoryMapInfoKHR.__member(4), VkMemoryMapInfoKHR.__member(POINTER_SIZE), VkMemoryMapInfoKHR.__member(4), VkMemoryMapInfoKHR.__member(8), VkMemoryMapInfoKHR.__member(8), VkMemoryMapInfoKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        SIZE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryMapInfoKHR, Buffer>
    implements NativeResource {
        private static final VkMemoryMapInfoKHR ELEMENT_FACTORY = VkMemoryMapInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryMapInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryMapInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryMapInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkMemoryMapFlags")
        public int flags() {
            return VkMemoryMapInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMemoryMapInfoKHR.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkMemoryMapInfoKHR.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryMapInfoKHR.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryMapInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000271000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryMapInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkMemoryMapPlacedInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkMemoryMapFlags") int value) {
            VkMemoryMapInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryMapInfoKHR.nmemory(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryMapInfoKHR.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryMapInfoKHR.nsize(this.address(), value);
            return this;
        }
    }
}

