/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentSampleCountInfoAMD;
import org.lwjgl.vulkan.VkAttachmentSampleCountInfoNV;
import org.lwjgl.vulkan.VkExternalFormatANDROID;
import org.lwjgl.vulkan.VkGraphicsPipelineLibraryCreateInfoEXT;
import org.lwjgl.vulkan.VkGraphicsPipelineShaderGroupsCreateInfoNV;
import org.lwjgl.vulkan.VkMultiviewPerViewAttributesInfoNVX;
import org.lwjgl.vulkan.VkPipelineColorBlendStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineCompilerControlCreateInfoAMD;
import org.lwjgl.vulkan.VkPipelineCreateFlags2CreateInfoKHR;
import org.lwjgl.vulkan.VkPipelineCreationFeedbackCreateInfo;
import org.lwjgl.vulkan.VkPipelineCreationFeedbackCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineDepthStencilStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineDiscardRectangleStateCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineDynamicStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineFragmentShadingRateEnumStateCreateInfoNV;
import org.lwjgl.vulkan.VkPipelineFragmentShadingRateStateCreateInfoKHR;
import org.lwjgl.vulkan.VkPipelineInputAssemblyStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineLibraryCreateInfoKHR;
import org.lwjgl.vulkan.VkPipelineMultisampleStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineRasterizationStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineRenderingCreateInfo;
import org.lwjgl.vulkan.VkPipelineRenderingCreateInfoKHR;
import org.lwjgl.vulkan.VkPipelineRepresentativeFragmentTestStateCreateInfoNV;
import org.lwjgl.vulkan.VkPipelineRobustnessCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineShaderStageCreateInfo;
import org.lwjgl.vulkan.VkPipelineTessellationStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineVertexInputStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineViewportStateCreateInfo;
import org.lwjgl.vulkan.VkRenderingAttachmentLocationInfoKHR;
import org.lwjgl.vulkan.VkRenderingInputAttachmentIndexInfoKHR;

public class VkGraphicsPipelineCreateInfo
extends Struct<VkGraphicsPipelineCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGECOUNT;
    public static final int PSTAGES;
    public static final int PVERTEXINPUTSTATE;
    public static final int PINPUTASSEMBLYSTATE;
    public static final int PTESSELLATIONSTATE;
    public static final int PVIEWPORTSTATE;
    public static final int PRASTERIZATIONSTATE;
    public static final int PMULTISAMPLESTATE;
    public static final int PDEPTHSTENCILSTATE;
    public static final int PCOLORBLENDSTATE;
    public static final int PDYNAMICSTATE;
    public static final int LAYOUT;
    public static final int RENDERPASS;
    public static final int SUBPASS;
    public static final int BASEPIPELINEHANDLE;
    public static final int BASEPIPELINEINDEX;

    protected VkGraphicsPipelineCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkGraphicsPipelineCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkGraphicsPipelineCreateInfo(address, container);
    }

    public VkGraphicsPipelineCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkGraphicsPipelineCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkGraphicsPipelineCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkGraphicsPipelineCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineCreateFlags")
    public int flags() {
        return VkGraphicsPipelineCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int stageCount() {
        return VkGraphicsPipelineCreateInfo.nstageCount(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineShaderStageCreateInfo const *")
    public VkPipelineShaderStageCreateInfo.Buffer pStages() {
        return VkGraphicsPipelineCreateInfo.npStages(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineVertexInputStateCreateInfo const *")
    public VkPipelineVertexInputStateCreateInfo pVertexInputState() {
        return VkGraphicsPipelineCreateInfo.npVertexInputState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineInputAssemblyStateCreateInfo const *")
    public VkPipelineInputAssemblyStateCreateInfo pInputAssemblyState() {
        return VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineTessellationStateCreateInfo const *")
    public VkPipelineTessellationStateCreateInfo pTessellationState() {
        return VkGraphicsPipelineCreateInfo.npTessellationState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineViewportStateCreateInfo const *")
    public VkPipelineViewportStateCreateInfo pViewportState() {
        return VkGraphicsPipelineCreateInfo.npViewportState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineRasterizationStateCreateInfo const *")
    public VkPipelineRasterizationStateCreateInfo pRasterizationState() {
        return VkGraphicsPipelineCreateInfo.npRasterizationState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineMultisampleStateCreateInfo const *")
    public VkPipelineMultisampleStateCreateInfo pMultisampleState() {
        return VkGraphicsPipelineCreateInfo.npMultisampleState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineDepthStencilStateCreateInfo const *")
    public VkPipelineDepthStencilStateCreateInfo pDepthStencilState() {
        return VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineColorBlendStateCreateInfo const *")
    public VkPipelineColorBlendStateCreateInfo pColorBlendState() {
        return VkGraphicsPipelineCreateInfo.npColorBlendState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineDynamicStateCreateInfo const *")
    public VkPipelineDynamicStateCreateInfo pDynamicState() {
        return VkGraphicsPipelineCreateInfo.npDynamicState(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkGraphicsPipelineCreateInfo.nlayout(this.address());
    }

    @NativeType(value="VkRenderPass")
    public long renderPass() {
        return VkGraphicsPipelineCreateInfo.nrenderPass(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpass() {
        return VkGraphicsPipelineCreateInfo.nsubpass(this.address());
    }

    @NativeType(value="VkPipeline")
    public long basePipelineHandle() {
        return VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address());
    }

    @NativeType(value="int32_t")
    public int basePipelineIndex() {
        return VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address());
    }

    public VkGraphicsPipelineCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkGraphicsPipelineCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo sType$Default() {
        return this.sType(28);
    }

    public VkGraphicsPipelineCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkGraphicsPipelineCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pNext(VkAttachmentSampleCountInfoAMD value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkAttachmentSampleCountInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkExternalFormatANDROID value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkGraphicsPipelineLibraryCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkGraphicsPipelineShaderGroupsCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkMultiviewPerViewAttributesInfoNVX value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineCompilerControlCreateInfoAMD value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineCreateFlags2CreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineCreationFeedbackCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineCreationFeedbackCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineDiscardRectangleStateCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineFragmentShadingRateEnumStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineFragmentShadingRateStateCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineLibraryCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineRenderingCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineRenderingCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineRepresentativeFragmentTestStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkPipelineRobustnessCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkRenderingAttachmentLocationInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo pNext(VkRenderingInputAttachmentIndexInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkGraphicsPipelineCreateInfo flags(@NativeType(value="VkPipelineCreateFlags") int value) {
        VkGraphicsPipelineCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo stageCount(@NativeType(value="uint32_t") int value) {
        VkGraphicsPipelineCreateInfo.nstageCount(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pStages(@Nullable @NativeType(value="VkPipelineShaderStageCreateInfo const *") VkPipelineShaderStageCreateInfo.Buffer value) {
        VkGraphicsPipelineCreateInfo.npStages(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pVertexInputState(@Nullable @NativeType(value="VkPipelineVertexInputStateCreateInfo const *") VkPipelineVertexInputStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npVertexInputState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pInputAssemblyState(@Nullable @NativeType(value="VkPipelineInputAssemblyStateCreateInfo const *") VkPipelineInputAssemblyStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pTessellationState(@Nullable @NativeType(value="VkPipelineTessellationStateCreateInfo const *") VkPipelineTessellationStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npTessellationState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pViewportState(@Nullable @NativeType(value="VkPipelineViewportStateCreateInfo const *") VkPipelineViewportStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npViewportState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pRasterizationState(@Nullable @NativeType(value="VkPipelineRasterizationStateCreateInfo const *") VkPipelineRasterizationStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npRasterizationState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pMultisampleState(@Nullable @NativeType(value="VkPipelineMultisampleStateCreateInfo const *") VkPipelineMultisampleStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npMultisampleState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pDepthStencilState(@Nullable @NativeType(value="VkPipelineDepthStencilStateCreateInfo const *") VkPipelineDepthStencilStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pColorBlendState(@Nullable @NativeType(value="VkPipelineColorBlendStateCreateInfo const *") VkPipelineColorBlendStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npColorBlendState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pDynamicState(@Nullable @NativeType(value="VkPipelineDynamicStateCreateInfo const *") VkPipelineDynamicStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npDynamicState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo layout(@NativeType(value="VkPipelineLayout") long value) {
        VkGraphicsPipelineCreateInfo.nlayout(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo renderPass(@NativeType(value="VkRenderPass") long value) {
        VkGraphicsPipelineCreateInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo subpass(@NativeType(value="uint32_t") int value) {
        VkGraphicsPipelineCreateInfo.nsubpass(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo basePipelineHandle(@NativeType(value="VkPipeline") long value) {
        VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo basePipelineIndex(@NativeType(value="int32_t") int value) {
        VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo set(int sType, long pNext, int flags, int stageCount, @Nullable VkPipelineShaderStageCreateInfo.Buffer pStages, @Nullable VkPipelineVertexInputStateCreateInfo pVertexInputState, @Nullable VkPipelineInputAssemblyStateCreateInfo pInputAssemblyState, @Nullable VkPipelineTessellationStateCreateInfo pTessellationState, @Nullable VkPipelineViewportStateCreateInfo pViewportState, @Nullable VkPipelineRasterizationStateCreateInfo pRasterizationState, @Nullable VkPipelineMultisampleStateCreateInfo pMultisampleState, @Nullable VkPipelineDepthStencilStateCreateInfo pDepthStencilState, @Nullable VkPipelineColorBlendStateCreateInfo pColorBlendState, @Nullable VkPipelineDynamicStateCreateInfo pDynamicState, long layout, long renderPass, int subpass, long basePipelineHandle, int basePipelineIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.stageCount(stageCount);
        this.pStages(pStages);
        this.pVertexInputState(pVertexInputState);
        this.pInputAssemblyState(pInputAssemblyState);
        this.pTessellationState(pTessellationState);
        this.pViewportState(pViewportState);
        this.pRasterizationState(pRasterizationState);
        this.pMultisampleState(pMultisampleState);
        this.pDepthStencilState(pDepthStencilState);
        this.pColorBlendState(pColorBlendState);
        this.pDynamicState(pDynamicState);
        this.layout(layout);
        this.renderPass(renderPass);
        this.subpass(subpass);
        this.basePipelineHandle(basePipelineHandle);
        this.basePipelineIndex(basePipelineIndex);
        return this;
    }

    public VkGraphicsPipelineCreateInfo set(VkGraphicsPipelineCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkGraphicsPipelineCreateInfo malloc() {
        return new VkGraphicsPipelineCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkGraphicsPipelineCreateInfo calloc() {
        return new VkGraphicsPipelineCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkGraphicsPipelineCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkGraphicsPipelineCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkGraphicsPipelineCreateInfo create(long address) {
        return new VkGraphicsPipelineCreateInfo(address, null);
    }

    @Nullable
    public static VkGraphicsPipelineCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkGraphicsPipelineCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkGraphicsPipelineCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkGraphicsPipelineCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkGraphicsPipelineCreateInfo mallocStack() {
        return VkGraphicsPipelineCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkGraphicsPipelineCreateInfo callocStack() {
        return VkGraphicsPipelineCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkGraphicsPipelineCreateInfo mallocStack(MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkGraphicsPipelineCreateInfo callocStack(MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkGraphicsPipelineCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkGraphicsPipelineCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.calloc(capacity, stack);
    }

    public static VkGraphicsPipelineCreateInfo malloc(MemoryStack stack) {
        return new VkGraphicsPipelineCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkGraphicsPipelineCreateInfo calloc(MemoryStack stack) {
        return new VkGraphicsPipelineCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nstageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGECOUNT);
    }

    @Nullable
    public static VkPipelineShaderStageCreateInfo.Buffer npStages(long struct) {
        return VkPipelineShaderStageCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PSTAGES), VkGraphicsPipelineCreateInfo.nstageCount(struct));
    }

    @Nullable
    public static VkPipelineVertexInputStateCreateInfo npVertexInputState(long struct) {
        return VkPipelineVertexInputStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PVERTEXINPUTSTATE));
    }

    @Nullable
    public static VkPipelineInputAssemblyStateCreateInfo npInputAssemblyState(long struct) {
        return VkPipelineInputAssemblyStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PINPUTASSEMBLYSTATE));
    }

    @Nullable
    public static VkPipelineTessellationStateCreateInfo npTessellationState(long struct) {
        return VkPipelineTessellationStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PTESSELLATIONSTATE));
    }

    @Nullable
    public static VkPipelineViewportStateCreateInfo npViewportState(long struct) {
        return VkPipelineViewportStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PVIEWPORTSTATE));
    }

    @Nullable
    public static VkPipelineRasterizationStateCreateInfo npRasterizationState(long struct) {
        return VkPipelineRasterizationStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PRASTERIZATIONSTATE));
    }

    @Nullable
    public static VkPipelineMultisampleStateCreateInfo npMultisampleState(long struct) {
        return VkPipelineMultisampleStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PMULTISAMPLESTATE));
    }

    @Nullable
    public static VkPipelineDepthStencilStateCreateInfo npDepthStencilState(long struct) {
        return VkPipelineDepthStencilStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PDEPTHSTENCILSTATE));
    }

    @Nullable
    public static VkPipelineColorBlendStateCreateInfo npColorBlendState(long struct) {
        return VkPipelineColorBlendStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORBLENDSTATE));
    }

    @Nullable
    public static VkPipelineDynamicStateCreateInfo npDynamicState(long struct) {
        return VkPipelineDynamicStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATE));
    }

    public static long nlayout(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYOUT);
    }

    public static long nrenderPass(long struct) {
        return UNSAFE.getLong(null, struct + (long)RENDERPASS);
    }

    public static int nsubpass(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBPASS);
    }

    public static long nbasePipelineHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)BASEPIPELINEHANDLE);
    }

    public static int nbasePipelineIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEPIPELINEINDEX);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nstageCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGECOUNT, value);
    }

    public static void npStages(long struct, @Nullable VkPipelineShaderStageCreateInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSTAGES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkGraphicsPipelineCreateInfo.nstageCount(struct, value.remaining());
        }
    }

    public static void npVertexInputState(long struct, @Nullable VkPipelineVertexInputStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PVERTEXINPUTSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npInputAssemblyState(long struct, @Nullable VkPipelineInputAssemblyStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PINPUTASSEMBLYSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npTessellationState(long struct, @Nullable VkPipelineTessellationStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PTESSELLATIONSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npViewportState(long struct, @Nullable VkPipelineViewportStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWPORTSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npRasterizationState(long struct, @Nullable VkPipelineRasterizationStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PRASTERIZATIONSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npMultisampleState(long struct, @Nullable VkPipelineMultisampleStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PMULTISAMPLESTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npDepthStencilState(long struct, @Nullable VkPipelineDepthStencilStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPTHSTENCILSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npColorBlendState(long struct, @Nullable VkPipelineColorBlendStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORBLENDSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npDynamicState(long struct, @Nullable VkPipelineDynamicStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PDYNAMICSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void nlayout(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYOUT, value);
    }

    public static void nrenderPass(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RENDERPASS, value);
    }

    public static void nsubpass(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBPASS, value);
    }

    public static void nbasePipelineHandle(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BASEPIPELINEHANDLE, value);
    }

    public static void nbasePipelineIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEPIPELINEINDEX, value);
    }

    public static void validate(long struct) {
        long pDynamicState;
        long pVertexInputState = MemoryUtil.memGetAddress(struct + (long)PVERTEXINPUTSTATE);
        if (pVertexInputState != 0L) {
            VkPipelineVertexInputStateCreateInfo.validate(pVertexInputState);
        }
        if ((pDynamicState = MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATE)) != 0L) {
            VkPipelineDynamicStateCreateInfo.validate(pDynamicState);
        }
    }

    static {
        Struct.Layout layout = VkGraphicsPipelineCreateInfo.__struct(VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(8), VkGraphicsPipelineCreateInfo.__member(8), VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(8), VkGraphicsPipelineCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGECOUNT = layout.offsetof(3);
        PSTAGES = layout.offsetof(4);
        PVERTEXINPUTSTATE = layout.offsetof(5);
        PINPUTASSEMBLYSTATE = layout.offsetof(6);
        PTESSELLATIONSTATE = layout.offsetof(7);
        PVIEWPORTSTATE = layout.offsetof(8);
        PRASTERIZATIONSTATE = layout.offsetof(9);
        PMULTISAMPLESTATE = layout.offsetof(10);
        PDEPTHSTENCILSTATE = layout.offsetof(11);
        PCOLORBLENDSTATE = layout.offsetof(12);
        PDYNAMICSTATE = layout.offsetof(13);
        LAYOUT = layout.offsetof(14);
        RENDERPASS = layout.offsetof(15);
        SUBPASS = layout.offsetof(16);
        BASEPIPELINEHANDLE = layout.offsetof(17);
        BASEPIPELINEINDEX = layout.offsetof(18);
    }

    public static class Buffer
    extends StructBuffer<VkGraphicsPipelineCreateInfo, Buffer>
    implements NativeResource {
        private static final VkGraphicsPipelineCreateInfo ELEMENT_FACTORY = VkGraphicsPipelineCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkGraphicsPipelineCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkGraphicsPipelineCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkGraphicsPipelineCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineCreateFlags")
        public int flags() {
            return VkGraphicsPipelineCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int stageCount() {
            return VkGraphicsPipelineCreateInfo.nstageCount(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineShaderStageCreateInfo const *")
        public VkPipelineShaderStageCreateInfo.Buffer pStages() {
            return VkGraphicsPipelineCreateInfo.npStages(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineVertexInputStateCreateInfo const *")
        public VkPipelineVertexInputStateCreateInfo pVertexInputState() {
            return VkGraphicsPipelineCreateInfo.npVertexInputState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineInputAssemblyStateCreateInfo const *")
        public VkPipelineInputAssemblyStateCreateInfo pInputAssemblyState() {
            return VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineTessellationStateCreateInfo const *")
        public VkPipelineTessellationStateCreateInfo pTessellationState() {
            return VkGraphicsPipelineCreateInfo.npTessellationState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineViewportStateCreateInfo const *")
        public VkPipelineViewportStateCreateInfo pViewportState() {
            return VkGraphicsPipelineCreateInfo.npViewportState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineRasterizationStateCreateInfo const *")
        public VkPipelineRasterizationStateCreateInfo pRasterizationState() {
            return VkGraphicsPipelineCreateInfo.npRasterizationState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineMultisampleStateCreateInfo const *")
        public VkPipelineMultisampleStateCreateInfo pMultisampleState() {
            return VkGraphicsPipelineCreateInfo.npMultisampleState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineDepthStencilStateCreateInfo const *")
        public VkPipelineDepthStencilStateCreateInfo pDepthStencilState() {
            return VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineColorBlendStateCreateInfo const *")
        public VkPipelineColorBlendStateCreateInfo pColorBlendState() {
            return VkGraphicsPipelineCreateInfo.npColorBlendState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineDynamicStateCreateInfo const *")
        public VkPipelineDynamicStateCreateInfo pDynamicState() {
            return VkGraphicsPipelineCreateInfo.npDynamicState(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkGraphicsPipelineCreateInfo.nlayout(this.address());
        }

        @NativeType(value="VkRenderPass")
        public long renderPass() {
            return VkGraphicsPipelineCreateInfo.nrenderPass(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpass() {
            return VkGraphicsPipelineCreateInfo.nsubpass(this.address());
        }

        @NativeType(value="VkPipeline")
        public long basePipelineHandle() {
            return VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address());
        }

        @NativeType(value="int32_t")
        public int basePipelineIndex() {
            return VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkGraphicsPipelineCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(28);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkGraphicsPipelineCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkAttachmentSampleCountInfoAMD value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkAttachmentSampleCountInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExternalFormatANDROID value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkGraphicsPipelineLibraryCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkGraphicsPipelineShaderGroupsCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMultiviewPerViewAttributesInfoNVX value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCompilerControlCreateInfoAMD value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreateFlags2CreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreationFeedbackCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreationFeedbackCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineDiscardRectangleStateCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineFragmentShadingRateEnumStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineFragmentShadingRateStateCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineLibraryCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineRenderingCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineRenderingCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineRepresentativeFragmentTestStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineRobustnessCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderingAttachmentLocationInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderingInputAttachmentIndexInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkPipelineCreateFlags") int value) {
            VkGraphicsPipelineCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer stageCount(@NativeType(value="uint32_t") int value) {
            VkGraphicsPipelineCreateInfo.nstageCount(this.address(), value);
            return this;
        }

        public Buffer pStages(@Nullable @NativeType(value="VkPipelineShaderStageCreateInfo const *") VkPipelineShaderStageCreateInfo.Buffer value) {
            VkGraphicsPipelineCreateInfo.npStages(this.address(), value);
            return this;
        }

        public Buffer pVertexInputState(@Nullable @NativeType(value="VkPipelineVertexInputStateCreateInfo const *") VkPipelineVertexInputStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npVertexInputState(this.address(), value);
            return this;
        }

        public Buffer pInputAssemblyState(@Nullable @NativeType(value="VkPipelineInputAssemblyStateCreateInfo const *") VkPipelineInputAssemblyStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address(), value);
            return this;
        }

        public Buffer pTessellationState(@Nullable @NativeType(value="VkPipelineTessellationStateCreateInfo const *") VkPipelineTessellationStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npTessellationState(this.address(), value);
            return this;
        }

        public Buffer pViewportState(@Nullable @NativeType(value="VkPipelineViewportStateCreateInfo const *") VkPipelineViewportStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npViewportState(this.address(), value);
            return this;
        }

        public Buffer pRasterizationState(@Nullable @NativeType(value="VkPipelineRasterizationStateCreateInfo const *") VkPipelineRasterizationStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npRasterizationState(this.address(), value);
            return this;
        }

        public Buffer pMultisampleState(@Nullable @NativeType(value="VkPipelineMultisampleStateCreateInfo const *") VkPipelineMultisampleStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npMultisampleState(this.address(), value);
            return this;
        }

        public Buffer pDepthStencilState(@Nullable @NativeType(value="VkPipelineDepthStencilStateCreateInfo const *") VkPipelineDepthStencilStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address(), value);
            return this;
        }

        public Buffer pColorBlendState(@Nullable @NativeType(value="VkPipelineColorBlendStateCreateInfo const *") VkPipelineColorBlendStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npColorBlendState(this.address(), value);
            return this;
        }

        public Buffer pDynamicState(@Nullable @NativeType(value="VkPipelineDynamicStateCreateInfo const *") VkPipelineDynamicStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npDynamicState(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkGraphicsPipelineCreateInfo.nlayout(this.address(), value);
            return this;
        }

        public Buffer renderPass(@NativeType(value="VkRenderPass") long value) {
            VkGraphicsPipelineCreateInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkGraphicsPipelineCreateInfo.nsubpass(this.address(), value);
            return this;
        }

        public Buffer basePipelineHandle(@NativeType(value="VkPipeline") long value) {
            VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address(), value);
            return this;
        }

        public Buffer basePipelineIndex(@NativeType(value="int32_t") int value) {
            VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address(), value);
            return this;
        }
    }
}

