/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDirectDriverLoadingInfoLUNARG
extends Struct<VkDirectDriverLoadingInfoLUNARG>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PFNGETINSTANCEPROCADDR;

    protected VkDirectDriverLoadingInfoLUNARG(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDirectDriverLoadingInfoLUNARG create(long address, @Nullable ByteBuffer container) {
        return new VkDirectDriverLoadingInfoLUNARG(address, container);
    }

    public VkDirectDriverLoadingInfoLUNARG(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDirectDriverLoadingInfoLUNARG.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDirectDriverLoadingInfoLUNARG.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkDirectDriverLoadingInfoLUNARG.npNext(this.address());
    }

    @NativeType(value="VkDirectDriverLoadingFlagsLUNARG")
    public int flags() {
        return VkDirectDriverLoadingInfoLUNARG.nflags(this.address());
    }

    @NativeType(value="PFN_vkGetInstanceProcAddrLUNARG")
    public long pfnGetInstanceProcAddr() {
        return VkDirectDriverLoadingInfoLUNARG.npfnGetInstanceProcAddr(this.address());
    }

    public VkDirectDriverLoadingInfoLUNARG sType(@NativeType(value="VkStructureType") int value) {
        VkDirectDriverLoadingInfoLUNARG.nsType(this.address(), value);
        return this;
    }

    public VkDirectDriverLoadingInfoLUNARG sType$Default() {
        return this.sType(1000459000);
    }

    public VkDirectDriverLoadingInfoLUNARG pNext(@NativeType(value="void *") long value) {
        VkDirectDriverLoadingInfoLUNARG.npNext(this.address(), value);
        return this;
    }

    public VkDirectDriverLoadingInfoLUNARG flags(@NativeType(value="VkDirectDriverLoadingFlagsLUNARG") int value) {
        VkDirectDriverLoadingInfoLUNARG.nflags(this.address(), value);
        return this;
    }

    public VkDirectDriverLoadingInfoLUNARG pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddrLUNARG") long value) {
        VkDirectDriverLoadingInfoLUNARG.npfnGetInstanceProcAddr(this.address(), value);
        return this;
    }

    public VkDirectDriverLoadingInfoLUNARG set(int sType, long pNext, int flags, long pfnGetInstanceProcAddr) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pfnGetInstanceProcAddr(pfnGetInstanceProcAddr);
        return this;
    }

    public VkDirectDriverLoadingInfoLUNARG set(VkDirectDriverLoadingInfoLUNARG src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDirectDriverLoadingInfoLUNARG malloc() {
        return new VkDirectDriverLoadingInfoLUNARG(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDirectDriverLoadingInfoLUNARG calloc() {
        return new VkDirectDriverLoadingInfoLUNARG(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDirectDriverLoadingInfoLUNARG create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDirectDriverLoadingInfoLUNARG(MemoryUtil.memAddress(container), container);
    }

    public static VkDirectDriverLoadingInfoLUNARG create(long address) {
        return new VkDirectDriverLoadingInfoLUNARG(address, null);
    }

    @Nullable
    public static VkDirectDriverLoadingInfoLUNARG createSafe(long address) {
        return address == 0L ? null : new VkDirectDriverLoadingInfoLUNARG(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDirectDriverLoadingInfoLUNARG.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDirectDriverLoadingInfoLUNARG.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDirectDriverLoadingInfoLUNARG malloc(MemoryStack stack) {
        return new VkDirectDriverLoadingInfoLUNARG(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDirectDriverLoadingInfoLUNARG calloc(MemoryStack stack) {
        return new VkDirectDriverLoadingInfoLUNARG(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long npfnGetInstanceProcAddr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PFNGETINSTANCEPROCADDR);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npfnGetInstanceProcAddr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PFNGETINSTANCEPROCADDR, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PFNGETINSTANCEPROCADDR));
    }

    static {
        Struct.Layout layout = VkDirectDriverLoadingInfoLUNARG.__struct(VkDirectDriverLoadingInfoLUNARG.__member(4), VkDirectDriverLoadingInfoLUNARG.__member(POINTER_SIZE), VkDirectDriverLoadingInfoLUNARG.__member(4), VkDirectDriverLoadingInfoLUNARG.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PFNGETINSTANCEPROCADDR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDirectDriverLoadingInfoLUNARG, Buffer>
    implements NativeResource {
        private static final VkDirectDriverLoadingInfoLUNARG ELEMENT_FACTORY = VkDirectDriverLoadingInfoLUNARG.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDirectDriverLoadingInfoLUNARG getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDirectDriverLoadingInfoLUNARG.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkDirectDriverLoadingInfoLUNARG.npNext(this.address());
        }

        @NativeType(value="VkDirectDriverLoadingFlagsLUNARG")
        public int flags() {
            return VkDirectDriverLoadingInfoLUNARG.nflags(this.address());
        }

        @NativeType(value="PFN_vkGetInstanceProcAddrLUNARG")
        public long pfnGetInstanceProcAddr() {
            return VkDirectDriverLoadingInfoLUNARG.npfnGetInstanceProcAddr(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDirectDriverLoadingInfoLUNARG.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000459000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDirectDriverLoadingInfoLUNARG.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDirectDriverLoadingFlagsLUNARG") int value) {
            VkDirectDriverLoadingInfoLUNARG.nflags(this.address(), value);
            return this;
        }

        public Buffer pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddrLUNARG") long value) {
            VkDirectDriverLoadingInfoLUNARG.npfnGetInstanceProcAddr(this.address(), value);
            return this;
        }
    }
}

