/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkBufferCreateInfo;

public class VkDeviceBufferMemoryRequirements
extends Struct<VkDeviceBufferMemoryRequirements>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PCREATEINFO;

    protected VkDeviceBufferMemoryRequirements(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceBufferMemoryRequirements create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceBufferMemoryRequirements(address, container);
    }

    public VkDeviceBufferMemoryRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceBufferMemoryRequirements.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceBufferMemoryRequirements.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceBufferMemoryRequirements.npNext(this.address());
    }

    @NativeType(value="VkBufferCreateInfo const *")
    public VkBufferCreateInfo pCreateInfo() {
        return VkDeviceBufferMemoryRequirements.npCreateInfo(this.address());
    }

    public VkDeviceBufferMemoryRequirements sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceBufferMemoryRequirements.nsType(this.address(), value);
        return this;
    }

    public VkDeviceBufferMemoryRequirements sType$Default() {
        return this.sType(1000413002);
    }

    public VkDeviceBufferMemoryRequirements pNext(@NativeType(value="void const *") long value) {
        VkDeviceBufferMemoryRequirements.npNext(this.address(), value);
        return this;
    }

    public VkDeviceBufferMemoryRequirements pCreateInfo(@NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo value) {
        VkDeviceBufferMemoryRequirements.npCreateInfo(this.address(), value);
        return this;
    }

    public VkDeviceBufferMemoryRequirements set(int sType, long pNext, VkBufferCreateInfo pCreateInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.pCreateInfo(pCreateInfo);
        return this;
    }

    public VkDeviceBufferMemoryRequirements set(VkDeviceBufferMemoryRequirements src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceBufferMemoryRequirements malloc() {
        return new VkDeviceBufferMemoryRequirements(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceBufferMemoryRequirements calloc() {
        return new VkDeviceBufferMemoryRequirements(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceBufferMemoryRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceBufferMemoryRequirements(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceBufferMemoryRequirements create(long address) {
        return new VkDeviceBufferMemoryRequirements(address, null);
    }

    @Nullable
    public static VkDeviceBufferMemoryRequirements createSafe(long address) {
        return address == 0L ? null : new VkDeviceBufferMemoryRequirements(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceBufferMemoryRequirements.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceBufferMemoryRequirements.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceBufferMemoryRequirements malloc(MemoryStack stack) {
        return new VkDeviceBufferMemoryRequirements(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceBufferMemoryRequirements calloc(MemoryStack stack) {
        return new VkDeviceBufferMemoryRequirements(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkBufferCreateInfo npCreateInfo(long struct) {
        return VkBufferCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PCREATEINFO));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npCreateInfo(long struct, VkBufferCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PCREATEINFO, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCREATEINFO));
    }

    static {
        Struct.Layout layout = VkDeviceBufferMemoryRequirements.__struct(VkDeviceBufferMemoryRequirements.__member(4), VkDeviceBufferMemoryRequirements.__member(POINTER_SIZE), VkDeviceBufferMemoryRequirements.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PCREATEINFO = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceBufferMemoryRequirements, Buffer>
    implements NativeResource {
        private static final VkDeviceBufferMemoryRequirements ELEMENT_FACTORY = VkDeviceBufferMemoryRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceBufferMemoryRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceBufferMemoryRequirements.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceBufferMemoryRequirements.npNext(this.address());
        }

        @NativeType(value="VkBufferCreateInfo const *")
        public VkBufferCreateInfo pCreateInfo() {
            return VkDeviceBufferMemoryRequirements.npCreateInfo(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceBufferMemoryRequirements.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000413002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceBufferMemoryRequirements.npNext(this.address(), value);
            return this;
        }

        public Buffer pCreateInfo(@NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo value) {
            VkDeviceBufferMemoryRequirements.npCreateInfo(this.address(), value);
            return this;
        }
    }
}

