/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDedicatedAllocationBufferCreateInfoNV
extends Struct<VkDedicatedAllocationBufferCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEDICATEDALLOCATION;

    protected VkDedicatedAllocationBufferCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDedicatedAllocationBufferCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkDedicatedAllocationBufferCreateInfoNV(address, container);
    }

    public VkDedicatedAllocationBufferCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDedicatedAllocationBufferCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDedicatedAllocationBufferCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDedicatedAllocationBufferCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean dedicatedAllocation() {
        return VkDedicatedAllocationBufferCreateInfoNV.ndedicatedAllocation(this.address()) != 0;
    }

    public VkDedicatedAllocationBufferCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkDedicatedAllocationBufferCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkDedicatedAllocationBufferCreateInfoNV sType$Default() {
        return this.sType(1000026001);
    }

    public VkDedicatedAllocationBufferCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkDedicatedAllocationBufferCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkDedicatedAllocationBufferCreateInfoNV dedicatedAllocation(@NativeType(value="VkBool32") boolean value) {
        VkDedicatedAllocationBufferCreateInfoNV.ndedicatedAllocation(this.address(), value ? 1 : 0);
        return this;
    }

    public VkDedicatedAllocationBufferCreateInfoNV set(int sType, long pNext, boolean dedicatedAllocation) {
        this.sType(sType);
        this.pNext(pNext);
        this.dedicatedAllocation(dedicatedAllocation);
        return this;
    }

    public VkDedicatedAllocationBufferCreateInfoNV set(VkDedicatedAllocationBufferCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDedicatedAllocationBufferCreateInfoNV malloc() {
        return new VkDedicatedAllocationBufferCreateInfoNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDedicatedAllocationBufferCreateInfoNV calloc() {
        return new VkDedicatedAllocationBufferCreateInfoNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDedicatedAllocationBufferCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDedicatedAllocationBufferCreateInfoNV(MemoryUtil.memAddress(container), container);
    }

    public static VkDedicatedAllocationBufferCreateInfoNV create(long address) {
        return new VkDedicatedAllocationBufferCreateInfoNV(address, null);
    }

    @Nullable
    public static VkDedicatedAllocationBufferCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkDedicatedAllocationBufferCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDedicatedAllocationBufferCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDedicatedAllocationBufferCreateInfoNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDedicatedAllocationBufferCreateInfoNV mallocStack() {
        return VkDedicatedAllocationBufferCreateInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDedicatedAllocationBufferCreateInfoNV callocStack() {
        return VkDedicatedAllocationBufferCreateInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDedicatedAllocationBufferCreateInfoNV mallocStack(MemoryStack stack) {
        return VkDedicatedAllocationBufferCreateInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkDedicatedAllocationBufferCreateInfoNV callocStack(MemoryStack stack) {
        return VkDedicatedAllocationBufferCreateInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDedicatedAllocationBufferCreateInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDedicatedAllocationBufferCreateInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDedicatedAllocationBufferCreateInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDedicatedAllocationBufferCreateInfoNV.calloc(capacity, stack);
    }

    public static VkDedicatedAllocationBufferCreateInfoNV malloc(MemoryStack stack) {
        return new VkDedicatedAllocationBufferCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDedicatedAllocationBufferCreateInfoNV calloc(MemoryStack stack) {
        return new VkDedicatedAllocationBufferCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndedicatedAllocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEDICATEDALLOCATION);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndedicatedAllocation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEDICATEDALLOCATION, value);
    }

    static {
        Struct.Layout layout = VkDedicatedAllocationBufferCreateInfoNV.__struct(VkDedicatedAllocationBufferCreateInfoNV.__member(4), VkDedicatedAllocationBufferCreateInfoNV.__member(POINTER_SIZE), VkDedicatedAllocationBufferCreateInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEDICATEDALLOCATION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDedicatedAllocationBufferCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkDedicatedAllocationBufferCreateInfoNV ELEMENT_FACTORY = VkDedicatedAllocationBufferCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDedicatedAllocationBufferCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDedicatedAllocationBufferCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDedicatedAllocationBufferCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean dedicatedAllocation() {
            return VkDedicatedAllocationBufferCreateInfoNV.ndedicatedAllocation(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDedicatedAllocationBufferCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000026001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDedicatedAllocationBufferCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer dedicatedAllocation(@NativeType(value="VkBool32") boolean value) {
            VkDedicatedAllocationBufferCreateInfoNV.ndedicatedAllocation(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

