/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindMemoryStatusKHR
extends Struct<VkBindMemoryStatusKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRESULT;

    protected VkBindMemoryStatusKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindMemoryStatusKHR create(long address, @Nullable ByteBuffer container) {
        return new VkBindMemoryStatusKHR(address, container);
    }

    public VkBindMemoryStatusKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindMemoryStatusKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindMemoryStatusKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindMemoryStatusKHR.npNext(this.address());
    }

    @NativeType(value="VkResult *")
    public IntBuffer pResult(int capacity) {
        return VkBindMemoryStatusKHR.npResult(this.address(), capacity);
    }

    public VkBindMemoryStatusKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindMemoryStatusKHR.nsType(this.address(), value);
        return this;
    }

    public VkBindMemoryStatusKHR sType$Default() {
        return this.sType(1000545002);
    }

    public VkBindMemoryStatusKHR pNext(@NativeType(value="void const *") long value) {
        VkBindMemoryStatusKHR.npNext(this.address(), value);
        return this;
    }

    public VkBindMemoryStatusKHR pResult(@NativeType(value="VkResult *") IntBuffer value) {
        VkBindMemoryStatusKHR.npResult(this.address(), value);
        return this;
    }

    public VkBindMemoryStatusKHR set(int sType, long pNext, IntBuffer pResult) {
        this.sType(sType);
        this.pNext(pNext);
        this.pResult(pResult);
        return this;
    }

    public VkBindMemoryStatusKHR set(VkBindMemoryStatusKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindMemoryStatusKHR malloc() {
        return new VkBindMemoryStatusKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBindMemoryStatusKHR calloc() {
        return new VkBindMemoryStatusKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBindMemoryStatusKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBindMemoryStatusKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkBindMemoryStatusKHR create(long address) {
        return new VkBindMemoryStatusKHR(address, null);
    }

    @Nullable
    public static VkBindMemoryStatusKHR createSafe(long address) {
        return address == 0L ? null : new VkBindMemoryStatusKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBindMemoryStatusKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindMemoryStatusKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBindMemoryStatusKHR malloc(MemoryStack stack) {
        return new VkBindMemoryStatusKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindMemoryStatusKHR calloc(MemoryStack stack) {
        return new VkBindMemoryStatusKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static IntBuffer npResult(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PRESULT), capacity);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npResult(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRESULT, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PRESULT));
    }

    static {
        Struct.Layout layout = VkBindMemoryStatusKHR.__struct(VkBindMemoryStatusKHR.__member(4), VkBindMemoryStatusKHR.__member(POINTER_SIZE), VkBindMemoryStatusKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRESULT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindMemoryStatusKHR, Buffer>
    implements NativeResource {
        private static final VkBindMemoryStatusKHR ELEMENT_FACTORY = VkBindMemoryStatusKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindMemoryStatusKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindMemoryStatusKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindMemoryStatusKHR.npNext(this.address());
        }

        @NativeType(value="VkResult *")
        public IntBuffer pResult(int capacity) {
            return VkBindMemoryStatusKHR.npResult(this.address(), capacity);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindMemoryStatusKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000545002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindMemoryStatusKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pResult(@NativeType(value="VkResult *") IntBuffer value) {
            VkBindMemoryStatusKHR.npResult(this.address(), value);
            return this;
        }
    }
}

