/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindBufferMemoryDeviceGroupInfo
extends Struct<VkBindBufferMemoryDeviceGroupInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEINDEXCOUNT;
    public static final int PDEVICEINDICES;

    protected VkBindBufferMemoryDeviceGroupInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindBufferMemoryDeviceGroupInfo create(long address, @Nullable ByteBuffer container) {
        return new VkBindBufferMemoryDeviceGroupInfo(address, container);
    }

    public VkBindBufferMemoryDeviceGroupInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindBufferMemoryDeviceGroupInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindBufferMemoryDeviceGroupInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindBufferMemoryDeviceGroupInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceIndexCount() {
        return VkBindBufferMemoryDeviceGroupInfo.ndeviceIndexCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pDeviceIndices() {
        return VkBindBufferMemoryDeviceGroupInfo.npDeviceIndices(this.address());
    }

    public VkBindBufferMemoryDeviceGroupInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindBufferMemoryDeviceGroupInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryDeviceGroupInfo sType$Default() {
        return this.sType(1000060013);
    }

    public VkBindBufferMemoryDeviceGroupInfo pNext(@NativeType(value="void const *") long value) {
        VkBindBufferMemoryDeviceGroupInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryDeviceGroupInfo pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkBindBufferMemoryDeviceGroupInfo.npDeviceIndices(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryDeviceGroupInfo set(int sType, long pNext, @Nullable IntBuffer pDeviceIndices) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDeviceIndices(pDeviceIndices);
        return this;
    }

    public VkBindBufferMemoryDeviceGroupInfo set(VkBindBufferMemoryDeviceGroupInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindBufferMemoryDeviceGroupInfo malloc() {
        return new VkBindBufferMemoryDeviceGroupInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBindBufferMemoryDeviceGroupInfo calloc() {
        return new VkBindBufferMemoryDeviceGroupInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBindBufferMemoryDeviceGroupInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBindBufferMemoryDeviceGroupInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkBindBufferMemoryDeviceGroupInfo create(long address) {
        return new VkBindBufferMemoryDeviceGroupInfo(address, null);
    }

    @Nullable
    public static VkBindBufferMemoryDeviceGroupInfo createSafe(long address) {
        return address == 0L ? null : new VkBindBufferMemoryDeviceGroupInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBindBufferMemoryDeviceGroupInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindBufferMemoryDeviceGroupInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBindBufferMemoryDeviceGroupInfo mallocStack() {
        return VkBindBufferMemoryDeviceGroupInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindBufferMemoryDeviceGroupInfo callocStack() {
        return VkBindBufferMemoryDeviceGroupInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindBufferMemoryDeviceGroupInfo mallocStack(MemoryStack stack) {
        return VkBindBufferMemoryDeviceGroupInfo.malloc(stack);
    }

    @Deprecated
    public static VkBindBufferMemoryDeviceGroupInfo callocStack(MemoryStack stack) {
        return VkBindBufferMemoryDeviceGroupInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindBufferMemoryDeviceGroupInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindBufferMemoryDeviceGroupInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryDeviceGroupInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryDeviceGroupInfo.calloc(capacity, stack);
    }

    public static VkBindBufferMemoryDeviceGroupInfo malloc(MemoryStack stack) {
        return new VkBindBufferMemoryDeviceGroupInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindBufferMemoryDeviceGroupInfo calloc(MemoryStack stack) {
        return new VkBindBufferMemoryDeviceGroupInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndeviceIndexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEINDEXCOUNT);
    }

    @Nullable
    public static IntBuffer npDeviceIndices(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDEVICEINDICES), VkBindBufferMemoryDeviceGroupInfo.ndeviceIndexCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndeviceIndexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEINDEXCOUNT, value);
    }

    public static void npDeviceIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEVICEINDICES, MemoryUtil.memAddressSafe(value));
        VkBindBufferMemoryDeviceGroupInfo.ndeviceIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkBindBufferMemoryDeviceGroupInfo.ndeviceIndexCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDEVICEINDICES));
        }
    }

    static {
        Struct.Layout layout = VkBindBufferMemoryDeviceGroupInfo.__struct(VkBindBufferMemoryDeviceGroupInfo.__member(4), VkBindBufferMemoryDeviceGroupInfo.__member(POINTER_SIZE), VkBindBufferMemoryDeviceGroupInfo.__member(4), VkBindBufferMemoryDeviceGroupInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEINDEXCOUNT = layout.offsetof(2);
        PDEVICEINDICES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkBindBufferMemoryDeviceGroupInfo, Buffer>
    implements NativeResource {
        private static final VkBindBufferMemoryDeviceGroupInfo ELEMENT_FACTORY = VkBindBufferMemoryDeviceGroupInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindBufferMemoryDeviceGroupInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindBufferMemoryDeviceGroupInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindBufferMemoryDeviceGroupInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceIndexCount() {
            return VkBindBufferMemoryDeviceGroupInfo.ndeviceIndexCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pDeviceIndices() {
            return VkBindBufferMemoryDeviceGroupInfo.npDeviceIndices(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindBufferMemoryDeviceGroupInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000060013);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindBufferMemoryDeviceGroupInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkBindBufferMemoryDeviceGroupInfo.npDeviceIndices(this.address(), value);
            return this;
        }
    }
}

