/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAttachmentReference
extends Struct<VkAttachmentReference>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ATTACHMENT;
    public static final int LAYOUT;

    protected VkAttachmentReference(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkAttachmentReference create(long address, @Nullable ByteBuffer container) {
        return new VkAttachmentReference(address, container);
    }

    public VkAttachmentReference(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAttachmentReference.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int attachment() {
        return VkAttachmentReference.nattachment(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int layout() {
        return VkAttachmentReference.nlayout(this.address());
    }

    public VkAttachmentReference attachment(@NativeType(value="uint32_t") int value) {
        VkAttachmentReference.nattachment(this.address(), value);
        return this;
    }

    public VkAttachmentReference layout(@NativeType(value="VkImageLayout") int value) {
        VkAttachmentReference.nlayout(this.address(), value);
        return this;
    }

    public VkAttachmentReference set(int attachment, int layout) {
        this.attachment(attachment);
        this.layout(layout);
        return this;
    }

    public VkAttachmentReference set(VkAttachmentReference src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAttachmentReference malloc() {
        return new VkAttachmentReference(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkAttachmentReference calloc() {
        return new VkAttachmentReference(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkAttachmentReference create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkAttachmentReference(MemoryUtil.memAddress(container), container);
    }

    public static VkAttachmentReference create(long address) {
        return new VkAttachmentReference(address, null);
    }

    @Nullable
    public static VkAttachmentReference createSafe(long address) {
        return address == 0L ? null : new VkAttachmentReference(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkAttachmentReference.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAttachmentReference.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkAttachmentReference mallocStack() {
        return VkAttachmentReference.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAttachmentReference callocStack() {
        return VkAttachmentReference.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAttachmentReference mallocStack(MemoryStack stack) {
        return VkAttachmentReference.malloc(stack);
    }

    @Deprecated
    public static VkAttachmentReference callocStack(MemoryStack stack) {
        return VkAttachmentReference.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkAttachmentReference.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkAttachmentReference.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference.calloc(capacity, stack);
    }

    public static VkAttachmentReference malloc(MemoryStack stack) {
        return new VkAttachmentReference(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAttachmentReference calloc(MemoryStack stack) {
        return new VkAttachmentReference(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nattachment(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENT);
    }

    public static int nlayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYOUT);
    }

    public static void nattachment(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENT, value);
    }

    public static void nlayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYOUT, value);
    }

    static {
        Struct.Layout layout = VkAttachmentReference.__struct(VkAttachmentReference.__member(4), VkAttachmentReference.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ATTACHMENT = layout.offsetof(0);
        LAYOUT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentReference, Buffer>
    implements NativeResource {
        private static final VkAttachmentReference ELEMENT_FACTORY = VkAttachmentReference.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAttachmentReference getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int attachment() {
            return VkAttachmentReference.nattachment(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int layout() {
            return VkAttachmentReference.nlayout(this.address());
        }

        public Buffer attachment(@NativeType(value="uint32_t") int value) {
            VkAttachmentReference.nattachment(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkImageLayout") int value) {
            VkAttachmentReference.nlayout(this.address(), value);
            return this;
        }
    }
}

