/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct JAWT_Win32DrawingSurfaceInfo")
public class JAWTWin32DrawingSurfaceInfo
extends Struct<JAWTWin32DrawingSurfaceInfo> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HWND;
    public static final int HBITMAP;
    public static final int PBITS;
    public static final int HDC;
    public static final int HPALETTE;

    protected JAWTWin32DrawingSurfaceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected JAWTWin32DrawingSurfaceInfo create(long address, @Nullable ByteBuffer container) {
        return new JAWTWin32DrawingSurfaceInfo(address, container);
    }

    public JAWTWin32DrawingSurfaceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), JAWTWin32DrawingSurfaceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HWND")
    public long hwnd() {
        return JAWTWin32DrawingSurfaceInfo.nhwnd(this.address());
    }

    @NativeType(value="HBITMAP")
    public long hbitmap() {
        return JAWTWin32DrawingSurfaceInfo.nhbitmap(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer pbits(int capacity) {
        return JAWTWin32DrawingSurfaceInfo.npbits(this.address(), capacity);
    }

    @NativeType(value="HDC")
    public long hdc() {
        return JAWTWin32DrawingSurfaceInfo.nhdc(this.address());
    }

    @NativeType(value="HPALETTE")
    public long hpalette() {
        return JAWTWin32DrawingSurfaceInfo.nhpalette(this.address());
    }

    public static JAWTWin32DrawingSurfaceInfo create(long address) {
        return new JAWTWin32DrawingSurfaceInfo(address, null);
    }

    @Nullable
    public static JAWTWin32DrawingSurfaceInfo createSafe(long address) {
        return address == 0L ? null : new JAWTWin32DrawingSurfaceInfo(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long nhwnd(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HWND);
    }

    public static long nhbitmap(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HBITMAP);
    }

    public static ByteBuffer npbits(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PBITS), capacity);
    }

    public static long nhdc(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HDC);
    }

    public static long nhpalette(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HPALETTE);
    }

    static {
        Struct.Layout layout = JAWTWin32DrawingSurfaceInfo.__struct(JAWTWin32DrawingSurfaceInfo.__union(JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE)), JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HWND = layout.offsetof(1);
        HBITMAP = layout.offsetof(2);
        PBITS = layout.offsetof(3);
        HDC = layout.offsetof(4);
        HPALETTE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<JAWTWin32DrawingSurfaceInfo, Buffer> {
        private static final JAWTWin32DrawingSurfaceInfo ELEMENT_FACTORY = JAWTWin32DrawingSurfaceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected JAWTWin32DrawingSurfaceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HWND")
        public long hwnd() {
            return JAWTWin32DrawingSurfaceInfo.nhwnd(this.address());
        }

        @NativeType(value="HBITMAP")
        public long hbitmap() {
            return JAWTWin32DrawingSurfaceInfo.nhbitmap(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer pbits(int capacity) {
            return JAWTWin32DrawingSurfaceInfo.npbits(this.address(), capacity);
        }

        @NativeType(value="HDC")
        public long hdc() {
            return JAWTWin32DrawingSurfaceInfo.nhdc(this.address());
        }

        @NativeType(value="HPALETTE")
        public long hpalette() {
            return JAWTWin32DrawingSurfaceInfo.nhpalette(this.address());
        }
    }
}

