/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.webp;

import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.webp.chunks.AbstractWebPChunk;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkAlph;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkAnim;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkAnmf;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkExif;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkIccp;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkVp8;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkVp8l;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkVp8x;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkXml;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkXyzw;

public enum WebPChunkType {
    ALPH(WebPChunkAlph::new),
    VP8(WebPChunkVp8::new),
    VP8L(WebPChunkVp8l::new),
    VP8X(WebPChunkVp8x::new),
    ANIM(WebPChunkAnim::new),
    ANMF(WebPChunkAnmf::new),
    ICCP(WebPChunkIccp::new),
    EXIF(WebPChunkExif::new),
    XMP(WebPChunkXml::new);

    private static final WebPChunkType[] types;
    private final ChunkConstructor constructor;
    final int value;

    static WebPChunkType findType(int chunkType) {
        for (WebPChunkType type : types) {
            if (type.value != chunkType) continue;
            return type;
        }
        return null;
    }

    static AbstractWebPChunk makeChunk(int chunkType, int size, byte[] bytes) throws IOException, ImagingException {
        WebPChunkType type = WebPChunkType.findType(chunkType);
        return type != null ? type.constructor.make(chunkType, size, bytes) : new WebPChunkXyzw(chunkType, size, bytes);
    }

    private WebPChunkType(ChunkConstructor constructor) {
        this.constructor = constructor;
        this.value = BinaryFunctions.charsToQuad(this.name().length() == 4 ? (char)this.name().charAt(3) : (char)' ', this.name().charAt(2), this.name().charAt(1), this.name().charAt(0));
    }

    static {
        types = WebPChunkType.values();
    }

    private static interface ChunkConstructor {
        public AbstractWebPChunk make(int var1, int var2, byte[] var3) throws IOException, ImagingException;
    }
}

