/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;
import org.apache.commons.io.IOUtils;

public final class PngChunkIccp
extends PngChunk {
    private static final Logger LOGGER = Logger.getLogger(PngChunkIccp.class.getName());
    private final String profileName;
    private final int compressionMethod;
    private final byte[] compressedProfile;
    private final byte[] uncompressedProfile;

    public PngChunkIccp(int length, int chunkType, int crc, byte[] bytes) throws ImagingException, IOException {
        super(length, chunkType, crc, bytes);
        int index = BinaryFunctions.indexOf0(bytes, "PngChunkIccp: No Profile Name");
        byte[] nameBytes = Arrays.copyOf(bytes, index);
        this.profileName = new String(nameBytes, StandardCharsets.ISO_8859_1);
        this.compressionMethod = bytes[index + 1];
        int compressedProfileLength = bytes.length - (index + 1 + 1);
        this.compressedProfile = Allocator.byteArray(compressedProfileLength);
        System.arraycopy(bytes, index + 1 + 1, this.compressedProfile, 0, compressedProfileLength);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ProfileName: " + this.profileName);
            LOGGER.finest("ProfileName.length(): " + this.profileName.length());
            LOGGER.finest("CompressionMethod: " + this.compressionMethod);
            LOGGER.finest("CompressedProfileLength: " + compressedProfileLength);
            LOGGER.finest("bytes.length: " + bytes.length);
        }
        this.uncompressedProfile = IOUtils.toByteArray(new InflaterInputStream(new ByteArrayInputStream(this.compressedProfile)));
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("UncompressedProfile: " + bytes.length);
        }
    }

    public byte[] getCompressedProfile() {
        return (byte[])this.compressedProfile.clone();
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public byte[] getUncompressedProfile() {
        return (byte[])this.uncompressedProfile.clone();
    }
}

