/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.ico;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.PixelDensity;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.AbstractBinaryOutputStream;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.LittleEndianBinaryOutputStream;
import org.apache.commons.imaging.formats.bmp.BmpImageParser;
import org.apache.commons.imaging.formats.ico.IcoImagingParameters;
import org.apache.commons.imaging.palette.PaletteFactory;
import org.apache.commons.imaging.palette.SimplePalette;

public class IcoImageParser
extends AbstractImageParser<IcoImagingParameters> {
    private static final String DEFAULT_EXTENSION = ImageFormats.ICO.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.ICO.getExtensions();

    public IcoImageParser() {
        super(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImagingException, IOException {
        ImageContents contents = this.readImage(byteSource);
        contents.fileHeader.dump(pw);
        for (IconData iconData : contents.iconDatas) {
            iconData.dump(pw);
        }
        return true;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.ICO};
    }

    @Override
    public List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        ImageContents contents = this.readImage(byteSource);
        FileHeader fileHeader = contents.fileHeader;
        ArrayList<BufferedImage> result = Allocator.arrayList(fileHeader.iconCount);
        for (int i = 0; i < fileHeader.iconCount; ++i) {
            result.add(contents.iconDatas[i].readBufferedImage());
        }
        return result;
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, IcoImagingParameters params) throws ImagingException, IOException {
        ImageContents contents = this.readImage(byteSource);
        FileHeader fileHeader = contents.fileHeader;
        if (fileHeader.iconCount > 0) {
            return contents.iconDatas[0].readBufferedImage();
        }
        throw new ImagingException("No icons in ICO file");
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    public IcoImagingParameters getDefaultParameters() {
        return new IcoImagingParameters();
    }

    @Override
    public byte[] getIccProfileBytes(ByteSource byteSource, IcoImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, IcoImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, IcoImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public ImageMetadata getMetadata(ByteSource byteSource, IcoImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public String getName() {
        return "ico-Custom";
    }

    private IconData readBitmapIconData(byte[] iconData, IconInfo fIconInfo) throws ImagingException, IOException {
        BufferedImage resultImage;
        byte[] transparencyMap;
        int tScanlineSize;
        BufferedImage bmpImage;
        BitmapHeader header;
        int bitCount;
        block22: {
            ByteArrayInputStream is = new ByteArrayInputStream(iconData);
            int size = BinaryFunctions.read4Bytes("size", is, "Not a Valid ICO File", this.getByteOrder());
            int width = BinaryFunctions.read4Bytes("width", is, "Not a Valid ICO File", this.getByteOrder());
            int height = BinaryFunctions.read4Bytes("height", is, "Not a Valid ICO File", this.getByteOrder());
            int planes = BinaryFunctions.read2Bytes("planes", is, "Not a Valid ICO File", this.getByteOrder());
            bitCount = BinaryFunctions.read2Bytes("bitCount", is, "Not a Valid ICO File", this.getByteOrder());
            int compression = BinaryFunctions.read4Bytes("compression", is, "Not a Valid ICO File", this.getByteOrder());
            int sizeImage = BinaryFunctions.read4Bytes("sizeImage", is, "Not a Valid ICO File", this.getByteOrder());
            int xPelsPerMeter = BinaryFunctions.read4Bytes("xPelsPerMeter", is, "Not a Valid ICO File", this.getByteOrder());
            int yPelsPerMeter = BinaryFunctions.read4Bytes("yPelsPerMeter", is, "Not a Valid ICO File", this.getByteOrder());
            int colorsUsed = BinaryFunctions.read4Bytes("colorsUsed", is, "Not a Valid ICO File", this.getByteOrder());
            int colorsImportant = BinaryFunctions.read4Bytes("ColorsImportant", is, "Not a Valid ICO File", this.getByteOrder());
            int redMask = 0;
            int greenMask = 0;
            int blueMask = 0;
            int alphaMask = 0;
            if (compression == 3) {
                redMask = BinaryFunctions.read4Bytes("redMask", is, "Not a Valid ICO File", this.getByteOrder());
                greenMask = BinaryFunctions.read4Bytes("greenMask", is, "Not a Valid ICO File", this.getByteOrder());
                blueMask = BinaryFunctions.read4Bytes("blueMask", is, "Not a Valid ICO File", this.getByteOrder());
            }
            byte[] restOfFile = BinaryFunctions.readBytes("RestOfFile", is, is.available());
            if (size != 40) {
                throw new ImagingException("Not a Valid ICO File: Wrong bitmap header size " + size);
            }
            if (planes != 1) {
                throw new ImagingException("Not a Valid ICO File: Planes can't be " + planes);
            }
            if (compression == 0 && bitCount == 32) {
                compression = 3;
                redMask = 0xFF0000;
                greenMask = 65280;
                blueMask = 255;
                alphaMask = -16777216;
            }
            header = new BitmapHeader(size, width, height, planes, bitCount, compression, sizeImage, xPelsPerMeter, yPelsPerMeter, colorsUsed, colorsImportant);
            int bitmapPixelsOffset = 70 + 4 * (colorsUsed == 0 && bitCount <= 8 ? 1 << bitCount : colorsUsed);
            int bitmapSize = 70 + restOfFile.length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(Allocator.checkByteArray(bitmapSize));
            try (LittleEndianBinaryOutputStream bos = AbstractBinaryOutputStream.littleEndian(baos);){
                bos.write(66);
                bos.write(77);
                ((AbstractBinaryOutputStream)bos).write4Bytes(bitmapSize);
                ((AbstractBinaryOutputStream)bos).write4Bytes(0);
                ((AbstractBinaryOutputStream)bos).write4Bytes(bitmapPixelsOffset);
                ((AbstractBinaryOutputStream)bos).write4Bytes(56);
                ((AbstractBinaryOutputStream)bos).write4Bytes(width);
                ((AbstractBinaryOutputStream)bos).write4Bytes(height / 2);
                ((AbstractBinaryOutputStream)bos).write2Bytes(planes);
                ((AbstractBinaryOutputStream)bos).write2Bytes(bitCount);
                ((AbstractBinaryOutputStream)bos).write4Bytes(compression);
                ((AbstractBinaryOutputStream)bos).write4Bytes(sizeImage);
                ((AbstractBinaryOutputStream)bos).write4Bytes(xPelsPerMeter);
                ((AbstractBinaryOutputStream)bos).write4Bytes(yPelsPerMeter);
                ((AbstractBinaryOutputStream)bos).write4Bytes(colorsUsed);
                ((AbstractBinaryOutputStream)bos).write4Bytes(colorsImportant);
                ((AbstractBinaryOutputStream)bos).write4Bytes(redMask);
                ((AbstractBinaryOutputStream)bos).write4Bytes(greenMask);
                ((AbstractBinaryOutputStream)bos).write4Bytes(blueMask);
                ((AbstractBinaryOutputStream)bos).write4Bytes(alphaMask);
                bos.write(restOfFile);
                bos.flush();
            }
            ByteArrayInputStream bmpInputStream = new ByteArrayInputStream(baos.toByteArray());
            bmpImage = new BmpImageParser().getBufferedImage(bmpInputStream, null);
            tScanlineSize = (width + 7) / 8;
            if (tScanlineSize % 4 != 0) {
                tScanlineSize += 4 - tScanlineSize % 4;
            }
            int colorMapSizeBytes = tScanlineSize * (height / 2);
            transparencyMap = null;
            try {
                transparencyMap = BinaryFunctions.readBytes("transparencyMap", bmpInputStream, colorMapSizeBytes, "Not a Valid ICO File");
            }
            catch (IOException ioEx) {
                if (bitCount == 32) break block22;
                throw ioEx;
            }
        }
        boolean allAlphasZero = true;
        if (bitCount == 32) {
            block7: for (int y = 0; allAlphasZero && y < bmpImage.getHeight(); ++y) {
                for (int x = 0; x < bmpImage.getWidth(); ++x) {
                    if ((bmpImage.getRGB(x, y) & 0xFF000000) == 0) continue;
                    allAlphasZero = false;
                    continue block7;
                }
            }
        }
        if (allAlphasZero) {
            resultImage = new BufferedImage(bmpImage.getWidth(), bmpImage.getHeight(), 2);
            for (int y = 0; y < resultImage.getHeight(); ++y) {
                for (int x = 0; x < resultImage.getWidth(); ++x) {
                    int alpha = 255;
                    if (transparencyMap != null) {
                        int alphaByte = 0xFF & transparencyMap[tScanlineSize * (bmpImage.getHeight() - y - 1) + x / 8];
                        alpha = 1 & alphaByte >> 7 - x % 8;
                        alpha = alpha == 0 ? 255 : 0;
                    }
                    resultImage.setRGB(x, y, alpha << 24 | 0xFFFFFF & bmpImage.getRGB(x, y));
                }
            }
        } else {
            resultImage = bmpImage;
        }
        return new BitmapIconData(fIconInfo, header, resultImage);
    }

    private FileHeader readFileHeader(InputStream is) throws ImagingException, IOException {
        int reserved = BinaryFunctions.read2Bytes("Reserved", is, "Not a Valid ICO File", this.getByteOrder());
        int iconType = BinaryFunctions.read2Bytes("IconType", is, "Not a Valid ICO File", this.getByteOrder());
        int iconCount = BinaryFunctions.read2Bytes("IconCount", is, "Not a Valid ICO File", this.getByteOrder());
        if (reserved != 0) {
            throw new ImagingException("Not a Valid ICO File: reserved is " + reserved);
        }
        if (iconType != 1 && iconType != 2) {
            throw new ImagingException("Not a Valid ICO File: icon type is " + iconType);
        }
        return new FileHeader(reserved, iconType, iconCount);
    }

    private IconData readIconData(byte[] iconData, IconInfo fIconInfo) throws ImagingException, IOException {
        ImageFormat imageFormat = Imaging.guessFormat(iconData);
        if (imageFormat.equals(ImageFormats.PNG)) {
            BufferedImage bufferedImage = Imaging.getBufferedImage(iconData);
            return new PngIconData(fIconInfo, bufferedImage);
        }
        return this.readBitmapIconData(iconData, fIconInfo);
    }

    private IconInfo readIconInfo(InputStream is) throws IOException {
        byte width = BinaryFunctions.readByte("Width", is, "Not a Valid ICO File");
        byte height = BinaryFunctions.readByte("Height", is, "Not a Valid ICO File");
        byte colorCount = BinaryFunctions.readByte("ColorCount", is, "Not a Valid ICO File");
        byte reserved = BinaryFunctions.readByte("Reserved", is, "Not a Valid ICO File");
        int planes = BinaryFunctions.read2Bytes("Planes", is, "Not a Valid ICO File", this.getByteOrder());
        int bitCount = BinaryFunctions.read2Bytes("BitCount", is, "Not a Valid ICO File", this.getByteOrder());
        int imageSize = BinaryFunctions.read4Bytes("ImageSize", is, "Not a Valid ICO File", this.getByteOrder());
        int imageOffset = BinaryFunctions.read4Bytes("ImageOffset", is, "Not a Valid ICO File", this.getByteOrder());
        return new IconInfo(width, height, colorCount, reserved, planes, bitCount, imageSize, imageOffset);
    }

    private ImageContents readImage(ByteSource byteSource) throws ImagingException, IOException {
        try (InputStream is = byteSource.getInputStream();){
            FileHeader fileHeader = this.readFileHeader(is);
            IconInfo[] fIconInfos = (IconInfo[])Allocator.array(fileHeader.iconCount, IconInfo[]::new, 32);
            for (int i = 0; i < fileHeader.iconCount; ++i) {
                fIconInfos[i] = this.readIconInfo(is);
            }
            IconData[] fIconDatas = (IconData[])Allocator.array(fileHeader.iconCount, IconData[]::new, 16);
            for (int i = 0; i < fileHeader.iconCount; ++i) {
                byte[] iconData = byteSource.getByteArray(fIconInfos[i].imageOffset, fIconInfos[i].imageSize);
                fIconDatas[i] = this.readIconData(iconData, fIconInfos[i]);
            }
            ImageContents imageContents = new ImageContents(fileHeader, fIconDatas);
            return imageContents;
        }
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, IcoImagingParameters params) throws ImagingException, IOException {
        boolean hasTransparency;
        if (params == null) {
            params = new IcoImagingParameters();
        }
        PixelDensity pixelDensity = params.getPixelDensity();
        PaletteFactory paletteFactory = new PaletteFactory();
        SimplePalette palette = paletteFactory.makeExactRgbPaletteSimple(src, 256);
        int bitCount = palette == null ? ((hasTransparency = paletteFactory.hasTransparency(src)) ? 32 : 24) : (palette.length() <= 2 ? 1 : (palette.length() <= 16 ? 4 : 8));
        try (LittleEndianBinaryOutputStream bos = AbstractBinaryOutputStream.littleEndian(os);){
            int tScanlineSize;
            int scanlineSize = (bitCount * src.getWidth() + 7) / 8;
            if (scanlineSize % 4 != 0) {
                scanlineSize += 4 - scanlineSize % 4;
            }
            if ((tScanlineSize = (src.getWidth() + 7) / 8) % 4 != 0) {
                tScanlineSize += 4 - tScanlineSize % 4;
            }
            int imageSize = 40 + 4 * (bitCount <= 8 ? 1 << bitCount : 0) + src.getHeight() * scanlineSize + src.getHeight() * tScanlineSize;
            ((AbstractBinaryOutputStream)bos).write2Bytes(0);
            ((AbstractBinaryOutputStream)bos).write2Bytes(1);
            ((AbstractBinaryOutputStream)bos).write2Bytes(1);
            int iconDirEntryWidth = src.getWidth();
            int iconDirEntryHeight = src.getHeight();
            if (iconDirEntryWidth > 255 || iconDirEntryHeight > 255) {
                iconDirEntryWidth = 0;
                iconDirEntryHeight = 0;
            }
            bos.write(iconDirEntryWidth);
            bos.write(iconDirEntryHeight);
            bos.write(bitCount >= 8 ? 0 : 1 << bitCount);
            bos.write(0);
            ((AbstractBinaryOutputStream)bos).write2Bytes(1);
            ((AbstractBinaryOutputStream)bos).write2Bytes(bitCount);
            ((AbstractBinaryOutputStream)bos).write4Bytes(imageSize);
            ((AbstractBinaryOutputStream)bos).write4Bytes(22);
            ((AbstractBinaryOutputStream)bos).write4Bytes(40);
            ((AbstractBinaryOutputStream)bos).write4Bytes(src.getWidth());
            ((AbstractBinaryOutputStream)bos).write4Bytes(2 * src.getHeight());
            ((AbstractBinaryOutputStream)bos).write2Bytes(1);
            ((AbstractBinaryOutputStream)bos).write2Bytes(bitCount);
            ((AbstractBinaryOutputStream)bos).write4Bytes(0);
            ((AbstractBinaryOutputStream)bos).write4Bytes(0);
            ((AbstractBinaryOutputStream)bos).write4Bytes(pixelDensity == null ? 0 : (int)Math.round(pixelDensity.horizontalDensityMetres()));
            ((AbstractBinaryOutputStream)bos).write4Bytes(pixelDensity == null ? 0 : (int)Math.round(pixelDensity.horizontalDensityMetres()));
            ((AbstractBinaryOutputStream)bos).write4Bytes(0);
            ((AbstractBinaryOutputStream)bos).write4Bytes(0);
            if (palette != null) {
                for (int i = 0; i < 1 << bitCount; ++i) {
                    if (i < palette.length()) {
                        int argb = palette.getEntry(i);
                        ((AbstractBinaryOutputStream)bos).write3Bytes(argb);
                        bos.write(0);
                        continue;
                    }
                    ((AbstractBinaryOutputStream)bos).write4Bytes(0);
                }
            }
            int bitCache = 0;
            int bitsInCache = 0;
            int rowPadding = scanlineSize - (bitCount * src.getWidth() + 7) / 8;
            for (int y = src.getHeight() - 1; y >= 0; --y) {
                int x;
                for (x = 0; x < src.getWidth(); ++x) {
                    int index;
                    int rgb;
                    int argb = src.getRGB(x, y);
                    if (palette == null) {
                        if (bitCount == 24) {
                            ((AbstractBinaryOutputStream)bos).write3Bytes(argb);
                            continue;
                        }
                        if (bitCount != 32) continue;
                        ((AbstractBinaryOutputStream)bos).write4Bytes(argb);
                        continue;
                    }
                    if (bitCount < 8) {
                        rgb = 0xFFFFFF & argb;
                        index = palette.getPaletteIndex(rgb);
                        bitCache <<= bitCount;
                        bitCache |= index;
                        if ((bitsInCache += bitCount) < 8) continue;
                        bos.write(0xFF & bitCache);
                        bitCache = 0;
                        bitsInCache = 0;
                        continue;
                    }
                    if (bitCount != 8) continue;
                    rgb = 0xFFFFFF & argb;
                    index = palette.getPaletteIndex(rgb);
                    bos.write(0xFF & index);
                }
                if (bitsInCache > 0) {
                    bos.write(0xFF & (bitCache <<= 8 - bitsInCache));
                    bitCache = 0;
                    bitsInCache = 0;
                }
                for (x = 0; x < rowPadding; ++x) {
                    bos.write(0);
                }
            }
            int tRowPadding = tScanlineSize - (src.getWidth() + 7) / 8;
            for (int y = src.getHeight() - 1; y >= 0; --y) {
                int x;
                for (x = 0; x < src.getWidth(); ++x) {
                    int argb = src.getRGB(x, y);
                    int alpha = 0xFF & argb >> 24;
                    bitCache <<= 1;
                    if (alpha == 0) {
                        bitCache |= 1;
                    }
                    if (++bitsInCache < 8) continue;
                    bos.write(0xFF & bitCache);
                    bitCache = 0;
                    bitsInCache = 0;
                }
                if (bitsInCache > 0) {
                    bos.write(0xFF & (bitCache <<= 8 - bitsInCache));
                    bitCache = 0;
                    bitsInCache = 0;
                }
                for (x = 0; x < tRowPadding; ++x) {
                    bos.write(0);
                }
            }
        }
    }

    private static final class ImageContents {
        public final FileHeader fileHeader;
        public final IconData[] iconDatas;

        ImageContents(FileHeader fileHeader, IconData[] iconDatas) {
            this.fileHeader = fileHeader;
            this.iconDatas = iconDatas;
        }
    }

    private static final class FileHeader {
        public final int reserved;
        public final int iconType;
        public final int iconCount;

        FileHeader(int reserved, int iconType, int iconCount) {
            this.reserved = reserved;
            this.iconType = iconType;
            this.iconCount = iconCount;
        }

        public void dump(PrintWriter pw) {
            pw.println("FileHeader");
            pw.println("Reserved: " + this.reserved);
            pw.println("IconType: " + this.iconType);
            pw.println("IconCount: " + this.iconCount);
            pw.println();
        }
    }

    static abstract class IconData {
        static final int SHALLOW_SIZE = 16;
        public final IconInfo iconInfo;

        IconData(IconInfo iconInfo) {
            this.iconInfo = iconInfo;
        }

        public void dump(PrintWriter pw) {
            this.iconInfo.dump(pw);
            pw.println();
            this.dumpSubclass(pw);
        }

        protected abstract void dumpSubclass(PrintWriter var1);

        public abstract BufferedImage readBufferedImage() throws ImagingException;
    }

    private static final class BitmapHeader {
        public final int size;
        public final int width;
        public final int height;
        public final int planes;
        public final int bitCount;
        public final int compression;
        public final int sizeImage;
        public final int xPelsPerMeter;
        public final int yPelsPerMeter;
        public final int colorsUsed;
        public final int colorsImportant;

        BitmapHeader(int size, int width, int height, int planes, int bitCount, int compression, int sizeImage, int pelsPerMeter, int pelsPerMeter2, int colorsUsed, int colorsImportant) {
            this.size = size;
            this.width = width;
            this.height = height;
            this.planes = planes;
            this.bitCount = bitCount;
            this.compression = compression;
            this.sizeImage = sizeImage;
            this.xPelsPerMeter = pelsPerMeter;
            this.yPelsPerMeter = pelsPerMeter2;
            this.colorsUsed = colorsUsed;
            this.colorsImportant = colorsImportant;
        }

        public void dump(PrintWriter pw) {
            pw.println("BitmapHeader");
            pw.println("Size: " + this.size);
            pw.println("Width: " + this.width);
            pw.println("Height: " + this.height);
            pw.println("Planes: " + this.planes);
            pw.println("BitCount: " + this.bitCount);
            pw.println("Compression: " + this.compression);
            pw.println("SizeImage: " + this.sizeImage);
            pw.println("XPelsPerMeter: " + this.xPelsPerMeter);
            pw.println("YPelsPerMeter: " + this.yPelsPerMeter);
            pw.println("ColorsUsed: " + this.colorsUsed);
            pw.println("ColorsImportant: " + this.colorsImportant);
        }
    }

    private static final class BitmapIconData
    extends IconData {
        public final BitmapHeader header;
        public final BufferedImage bufferedImage;

        BitmapIconData(IconInfo iconInfo, BitmapHeader header, BufferedImage bufferedImage) {
            super(iconInfo);
            this.header = header;
            this.bufferedImage = bufferedImage;
        }

        @Override
        protected void dumpSubclass(PrintWriter pw) {
            pw.println("BitmapIconData");
            this.header.dump(pw);
            pw.println();
        }

        @Override
        public BufferedImage readBufferedImage() throws ImagingException {
            return this.bufferedImage;
        }
    }

    static class IconInfo {
        static final int SHALLOW_SIZE = 32;
        public final byte width;
        public final byte height;
        public final byte colorCount;
        public final byte reserved;
        public final int planes;
        public final int bitCount;
        public final int imageSize;
        public final int imageOffset;

        IconInfo(byte width, byte height, byte colorCount, byte reserved, int planes, int bitCount, int imageSize, int imageOffset) {
            this.width = width;
            this.height = height;
            this.colorCount = colorCount;
            this.reserved = reserved;
            this.planes = planes;
            this.bitCount = bitCount;
            this.imageSize = imageSize;
            this.imageOffset = imageOffset;
        }

        public void dump(PrintWriter pw) {
            pw.println("IconInfo");
            pw.println("Width: " + this.width);
            pw.println("Height: " + this.height);
            pw.println("ColorCount: " + this.colorCount);
            pw.println("Reserved: " + this.reserved);
            pw.println("Planes: " + this.planes);
            pw.println("BitCount: " + this.bitCount);
            pw.println("ImageSize: " + this.imageSize);
            pw.println("ImageOffset: " + this.imageOffset);
        }
    }

    private static final class PngIconData
    extends IconData {
        public final BufferedImage bufferedImage;

        PngIconData(IconInfo iconInfo, BufferedImage bufferedImage) {
            super(iconInfo);
            this.bufferedImage = bufferedImage;
        }

        @Override
        protected void dumpSubclass(PrintWriter pw) {
            pw.println("PNGIconData");
            pw.println();
        }

        @Override
        public BufferedImage readBufferedImage() {
            return this.bufferedImage;
        }
    }
}

