/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryConstant;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.lang3.ArrayUtils;

public final class BinaryFunctions {
    private static final byte NUL = 0;
    private static final Logger LOGGER = Logger.getLogger(BinaryFunctions.class.getName());

    public static int charsToQuad(char c1, char c2, char c3, char c4) {
        return (0xFF & c1) << 24 | (0xFF & c2) << 16 | (0xFF & c3) << 8 | (0xFF & c4) << 0;
    }

    public static boolean compareBytes(byte[] a, int aStart, byte[] b, int bStart, int length) {
        if (a.length < aStart + length) {
            return false;
        }
        if (b.length < bStart + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[aStart + i] == b[bStart + i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] copyOfRange(byte[] original, int from, int count) {
        return Arrays.copyOfRange(original, from, from + Allocator.checkByteArray(count));
    }

    public static byte[] copyOfStart(byte[] original, int count) {
        if (count > original.length) {
            count = original.length;
        }
        return BinaryFunctions.copyOfRange(original, 0, count);
    }

    public static byte[] getBytes(RandomAccessFile raf, long pos, int length, String exception) throws IOException {
        if (length < 0) {
            throw new IOException(String.format("%s, invalid length: %d", exception, length));
        }
        Allocator.checkByteArray(length);
        return RandomAccessFiles.read(raf, pos, length);
    }

    public static int indexOf0(byte[] src, int start, String message) throws ImagingException {
        int i = ArrayUtils.indexOf(src, (byte)0, start);
        if (i < 0) {
            throw new ImagingException(message);
        }
        return i;
    }

    public static int indexOf0(byte[] src, String message) throws ImagingException {
        return BinaryFunctions.indexOf0(src, 0, message);
    }

    public static void logByteBits(String msg, byte i) {
        LOGGER.finest(msg + ": '" + Integer.toBinaryString(0xFF & i));
    }

    public static void logCharQuad(String msg, int i) {
        LOGGER.finest(msg + ": '" + (char)(0xFF & i >> 24) + (char)(0xFF & i >> 16) + (char)(0xFF & i >> 8) + (char)(0xFF & i >> 0) + "'");
    }

    public static void printCharQuad(PrintWriter pw, String msg, int i) {
        pw.println(msg + ": '" + (char)(0xFF & i >> 24) + (char)(0xFF & i >> 16) + (char)(0xFF & i >> 8) + (char)(0xFF & i >> 0) + "'");
    }

    public static byte[] quadsToByteArray(int quad) {
        byte[] arr = new byte[]{(byte)(quad >> 24), (byte)(quad >> 16), (byte)(quad >> 8), (byte)quad};
        return arr;
    }

    public static int read2Bytes(String name, InputStream in, String exception, ByteOrder byteOrder) throws IOException {
        int byte1;
        int byte0 = in.read();
        if ((byte0 | (byte1 = in.read())) < 0) {
            throw new IOException(exception);
        }
        int result = byteOrder == ByteOrder.BIG_ENDIAN ? byte0 << 8 | byte1 : byte1 << 8 | byte0;
        return result;
    }

    public static int read3Bytes(String name, InputStream in, String exception, ByteOrder byteOrder) throws IOException {
        int byte2;
        int byte1;
        int byte0 = in.read();
        if ((byte0 | (byte1 = in.read()) | (byte2 = in.read())) < 0) {
            throw new IOException(exception);
        }
        int result = byteOrder == ByteOrder.BIG_ENDIAN ? byte0 << 16 | byte1 << 8 | byte2 << 0 : byte2 << 16 | byte1 << 8 | byte0 << 0;
        return result;
    }

    public static int read4Bytes(String name, InputStream in, String exception, ByteOrder byteOrder) throws IOException {
        int byte3;
        int byte2;
        int byte1;
        int byte0 = in.read();
        if ((byte0 | (byte1 = in.read()) | (byte2 = in.read()) | (byte3 = in.read())) < 0) {
            throw new IOException(exception);
        }
        int result = byteOrder == ByteOrder.BIG_ENDIAN ? byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3 << 0 : byte3 << 24 | byte2 << 16 | byte1 << 8 | byte0 << 0;
        return result;
    }

    public static long read8Bytes(String name, InputStream in, String exception, ByteOrder byteOrder) throws IOException {
        long byte7;
        long byte6;
        long byte5;
        long byte4;
        long byte3;
        long byte2;
        long byte1;
        long byte0 = in.read();
        if ((byte0 | (byte1 = (long)in.read()) | (byte2 = (long)in.read()) | (byte3 = (long)in.read()) | (byte4 = (long)in.read()) | (byte5 = (long)in.read()) | (byte6 = (long)in.read()) | (byte7 = (long)in.read())) < 0L) {
            throw new IOException(exception);
        }
        long result = byteOrder == ByteOrder.BIG_ENDIAN ? byte0 << 56 | byte1 << 48 | byte2 << 40 | byte3 << 32 | byte4 << 24 | byte5 << 16 | byte6 << 8 | byte7 << 0 : byte7 << 56 | byte6 << 48 | byte5 << 40 | byte4 << 32 | byte3 << 24 | byte2 << 16 | byte1 << 8 | byte0 << 0;
        return result;
    }

    public static void readAndVerifyBytes(InputStream in, BinaryConstant expected, String exception) throws ImagingException, IOException {
        BinaryFunctions.readAndVerifyBytes(in, expected.rawValue(), exception);
    }

    public static void readAndVerifyBytes(InputStream in, byte[] expected, String exception) throws ImagingException, IOException {
        for (byte element : expected) {
            int data = in.read();
            byte b = (byte)(0xFF & data);
            if (data < 0) {
                throw new ImagingException("Unexpected EOF.");
            }
            if (b == element) continue;
            throw new ImagingException(exception);
        }
    }

    public static byte readByte(String name, InputStream in, String exceptionMessage) throws IOException {
        int result = in.read();
        if (result < 0) {
            throw new IOException(exceptionMessage);
        }
        return (byte)(0xFF & result);
    }

    public static byte[] readBytes(InputStream in, int count) throws IOException {
        return BinaryFunctions.readBytes("", in, count, "Unexpected EOF");
    }

    public static byte[] readBytes(String name, InputStream in, int length) throws IOException {
        return BinaryFunctions.readBytes(name, in, length, name + " could not be read.");
    }

    public static byte[] readBytes(String name, InputStream in, int length, String exception) throws IOException {
        try {
            return IOUtils.toByteArray(in, Allocator.check(length));
        }
        catch (IOException e) {
            throw new IOException(exception + ", name: " + name + ", length: " + length);
        }
    }

    public static byte[] remainingBytes(String name, byte[] bytes, int count) {
        return BinaryFunctions.copyOfRange(bytes, count, bytes.length - count);
    }

    public static boolean searchQuad(int quad, InputStream in) throws IOException {
        byte[] needle = BinaryFunctions.quadsToByteArray(quad);
        byte b = -1;
        int position = 0;
        while ((b = in.read()) != -1) {
            if (needle[position] == b) {
                if (++position != needle.length) continue;
                return true;
            }
            position = 0;
        }
        return false;
    }

    public static long skipBytes(InputStream in, long skip) throws IOException {
        return BinaryFunctions.skipBytes(in, skip, "Couldn't skip bytes");
    }

    public static long skipBytes(InputStream in, long skip, String exMessage) throws IOException {
        try {
            return IOUtils.skip(in, skip);
        }
        catch (IOException e) {
            throw new IOException(exMessage, e);
        }
    }

    public static boolean startsWith(byte[] buffer, byte[] search) {
        if (search == null) {
            return false;
        }
        if (buffer == null) {
            return false;
        }
        if (search.length > buffer.length) {
            return false;
        }
        for (int i = 0; i < search.length; ++i) {
            if (search[i] == buffer[i]) continue;
            return false;
        }
        return true;
    }

    private BinaryFunctions() {
    }
}

