/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.layers;

import java.awt.Component;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.plugins.pmtiles.data.imagery.PMTilesImageryInfo;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesImageSource;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesLayer;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesLoader;
import org.openstreetmap.josm.tools.GBC;

public class PMTilesImageLayer
extends AbstractCachedTileSourceLayer<PMTilesImageSource>
implements PMTilesLayer {
    public PMTilesImageLayer(PMTilesImageryInfo info) {
        super((ImageryInfo)info);
        if (info.getName() != null) {
            this.setName(info.getName());
        } else {
            this.setName(info.header().location().getPath());
        }
    }

    protected Class<? extends TileLoader> getTileLoaderClass() {
        return PMTilesLoader.class;
    }

    protected void initTileSource(PMTilesImageSource tileSource) {
        super.initTileSource((AbstractTMSTileSource)tileSource);
        TileLoader tileLoader = this.tileLoader = this.getTileLoaderFactory().makeTileLoader((TileLoaderListener)this, this.getHeaders(tileSource), (long)this.info.getMinimumTileExpire());
        if (tileLoader instanceof PMTilesLoader) {
            PMTilesLoader pmTilesLoader = (PMTilesLoader)tileLoader;
            pmTilesLoader.setInfo((PMTilesImageryInfo)this.info);
        }
    }

    protected String getCacheName() {
        return "PMTILES_IMAGE";
    }

    public Collection<String> getNativeProjections() {
        return Collections.singleton("EPSG:3857");
    }

    protected PMTilesImageSource getTileSource() {
        return new PMTilesImageSource((PMTilesImageryInfo)this.info);
    }

    @Override
    public PMTilesImageryInfo getInfo() {
        return (PMTilesImageryInfo)super.getInfo();
    }

    @Override
    public String getChangesetSourceTag() {
        return PMTilesLayer.super.getChangesetSourceTag();
    }

    public Object getInfoComponent() {
        String[][] content;
        JPanel panel = (JPanel)super.getInfoComponent();
        for (String[] entry : content = this.getInfoContent()) {
            panel.add((Component)new JLabel(entry[0] + ":"), GBC.std());
            panel.add(GBC.glue((int)5, (int)0), GBC.std());
            panel.add((Component)this.createTextField(entry[1]), GBC.eol().fill(2));
        }
        return panel;
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        super.paint(g, mv, box);
        PMTilesLayer.super.paint(g, mv, box);
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        super.visitBoundingBox(v);
        PMTilesLayer.super.visitBoundingBox(v);
    }
}

