/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.directdownload;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.directdownload.UserTrack;
import org.openstreetmap.josm.plugins.directdownload.UserTrackReader;
import org.openstreetmap.josm.tools.I18n;

public class DownloadDataGui
extends ExtendedDialog {
    private final NamedResultTableModel model;
    private final JTable tblSearchResults;

    public DownloadDataGui() {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Download Track", (Object[])new Object[0]), new String[]{I18n.tr((String)"Download Track", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new NamedResultTableModel();
        this.tblSearchResults = new JTable(this.model);
        this.tblSearchResults.setAutoCreateRowSorter(true);
        this.tblSearchResults.setSelectionModel(selectionModel);
        this.tblSearchResults.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(this.tblSearchResults);
        scrollPane.setPreferredSize(new Dimension(800, 300));
        panel.add((Component)scrollPane, "Center");
        this.model.setData(new UserTrackReader().getTrackList());
        this.setContent(panel);
        this.setupDialog();
    }

    public List<UserTrack> getSelectedUserTracks() {
        List<UserTrack> dataArray = this.model.getDataArrayList();
        int[] selected = this.tblSearchResults.getSelectedRows();
        ArrayList<UserTrack> selectedTracks = new ArrayList<UserTrack>(selected.length);
        for (int i : selected) {
            selectedTracks.add(dataArray.get(this.tblSearchResults.convertRowIndexToModel(i)));
        }
        return selectedTracks;
    }

    public UserTrack getSelectedUserTrack() {
        return this.model.getDataArrayList().get(this.tblSearchResults.convertRowIndexToModel(this.tblSearchResults.getSelectedRow()));
    }

    static class NamedResultTableModel
    extends DefaultTableModel {
        private ArrayList<UserTrack> data = new ArrayList();

        NamedResultTableModel() {
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.data == null) {
                return null;
            }
            UserTrack track = this.data.get(row);
            switch (column) {
                case 0: {
                    return track.datetime;
                }
                case 1: {
                    return track.filename;
                }
                case 2: {
                    return track.description;
                }
                case 3: {
                    return String.join((CharSequence)";", track.tags);
                }
            }
            return track;
        }

        public void setData(List<UserTrack> data) {
            if (data == null) {
                this.data.clear();
            } else {
                this.data = new ArrayList<UserTrack>(data);
            }
            this.fireTableDataChanged();
        }

        public List<UserTrack> getDataArrayList() {
            return this.data;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return I18n.tr((String)"Date", (Object[])new Object[0]);
                }
                case 1: {
                    return I18n.tr((String)"Filename", (Object[])new Object[0]);
                }
                case 2: {
                    return I18n.tr((String)"Description", (Object[])new Object[0]);
                }
                case 3: {
                    return I18n.tr((String)"Tags", (Object[])new Object[0]);
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }
    }
}

