/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageio;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.imageio.Artifact;
import org.openstreetmap.josm.plugins.imageio.NexusDownloader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

final class ImageIOPreferenceSetting
implements SubPreferenceSetting {
    private final Set<Artifact> imagePlugins = new TreeSet<Artifact>();
    private final Runnable callback;

    ImageIOPreferenceSetting(Runnable callback) {
        this.callback = callback;
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("<html><h4>" + I18n.tr((String)"Enable or disable additional image formats. Disabling an image format requires a restart.", (Object[])new Object[0]) + "</h4></html>"), GBC.eol().anchor(19).insets(5, 5, 5, 5).fill(2));
        panel.add((Component)new JSeparator(0), GBC.eol());
        JPanel checkboxes = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(checkboxes), GBC.eol().fill(1));
        this.addWebPPanel(checkboxes);
        checkboxes.add((Component)new JLabel(""), GBC.eol().fill(1));
        this.getTabPreferenceSetting(gui).addSubTab((SubPreferenceSetting)this, I18n.tr((String)"ImageIO", (Object[])new Object[0]), (Component)panel);
    }

    private void addWebPPanel(JPanel panel) {
        Artifact webp = new Artifact("com.twelvemonkeys.imageio", "imageio-webp", null);
        JCheckBox webpCheck = new JCheckBox(I18n.tr((String)"webp (recommended, implementation provided by TwelveMonkeys, BSD-3-Clause)", (Object[])new Object[0]));
        Iterator<ImageReader> webpIterator = ImageIO.getImageReadersByFormatName("WEBP");
        webpCheck.setSelected(webpIterator.hasNext() && "com.twelvemonkeys.imageio.plugins.webp.WebPImageReader".equals(webpIterator.next().getClass().getCanonicalName()));
        if (webpCheck.isSelected()) {
            this.imagePlugins.add(webp);
        }
        webpCheck.addActionListener(l -> {
            if (webpCheck.isSelected()) {
                this.imagePlugins.add(webp);
            } else {
                this.imagePlugins.remove(webp);
            }
        });
        panel.add((Component)webpCheck, GBC.eol().anchor(19));
    }

    public boolean ok() {
        TreeSet<String> classPath = new TreeSet<String>();
        for (Artifact artifact : this.imagePlugins) {
            classPath.addAll(NexusDownloader.download(artifact));
        }
        TreeSet oldConfig = new TreeSet(Config.getPref().getList("imageio.classpath"));
        if (Config.getPref().putList("imageio.classpath", new ArrayList(classPath))) {
            MainApplication.worker.execute(this.callback);
        }
        return !classPath.containsAll(oldConfig);
    }

    public boolean isExpert() {
        return false;
    }

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getImageryPreference();
    }
}

