/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.jna.win;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.openstreetmap.josm.plugins.jna.JosmNativeLogHandler;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.Logging;

public class JosmWinNativeLogHandler
extends JosmNativeLogHandler
implements Destroyable {
    private static final String JOSM = "JOSM";
    private final WinNT.HANDLE hLog = JosmWinNativeLogHandler.registerEventSource();

    private static WinNT.HANDLE registerEventSource() {
        WinNT.HANDLE handle = Advapi32.INSTANCE.RegisterEventSource(null, JOSM);
        if (handle == null) {
            if (Kernel32.INSTANCE.GetLastError() == 5) {
                throw new IllegalStateException("ERROR_ACCESS_DENIED: RegisterEventSource JOSM");
            }
            throw new Win32Exception(Native.getLastError());
        }
        return handle;
    }

    private static void deregisterEventSource(WinNT.HANDLE handle) {
        if (!Advapi32.INSTANCE.DeregisterEventSource(handle)) {
            throw new Win32Exception(Native.getLastError());
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record) && !Advapi32.INSTANCE.ReportEvent(this.hLog, JosmWinNativeLogHandler.logType(record.getLevel()), 0, 0, null, 1, 0, new String[]{this.getFormatter().format(record)}, null)) {
            System.err.println("Unable to report Windows log event for " + String.valueOf(record));
        }
    }

    private static int logType(Level logLevel) {
        if (Logging.LEVEL_ERROR.equals(logLevel)) {
            return 1;
        }
        if (Logging.LEVEL_WARN.equals(logLevel)) {
            return 2;
        }
        return 4;
    }

    public void destroy() {
        JosmWinNativeLogHandler.deregisterEventSource(this.hLog);
    }
}

