/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.text.MessageFormat;
import org.geotools.util.ClassChanger;
import org.geotools.util.Range;
import org.geotools.util.XMath;

public class NumberRange<T extends Number>
extends Range<T> {
    private static final long serialVersionUID = -818167965963008231L;

    public static NumberRange<Byte> create(byte minimum, byte maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public static NumberRange<Byte> create(byte minimum, boolean isMinIncluded, byte maximum, boolean isMaxIncluded) {
        return new NumberRange<Byte>(Byte.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    public static NumberRange<Short> create(short minimum, short maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public static NumberRange<Short> create(short minimum, boolean isMinIncluded, short maximum, boolean isMaxIncluded) {
        return new NumberRange<Short>(Short.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    public static NumberRange<Integer> create(int minimum, int maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public static NumberRange<Integer> create(int minimum, boolean isMinIncluded, int maximum, boolean isMaxIncluded) {
        return new NumberRange<Integer>(Integer.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    public static NumberRange<Long> create(long minimum, long maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public static NumberRange<Long> create(long minimum, boolean isMinIncluded, long maximum, boolean isMaxIncluded) {
        return new NumberRange<Long>(Long.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    public static NumberRange<Float> create(float minimum, float maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public static NumberRange<Float> create(float minimum, boolean isMinIncluded, float maximum, boolean isMaxIncluded) {
        return new NumberRange<Float>(Float.class, Float.valueOf(minimum), isMinIncluded, Float.valueOf(maximum), isMaxIncluded);
    }

    public static NumberRange<Double> create(double minimum, double maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public static NumberRange<Double> create(double minimum, boolean isMinIncluded, double maximum, boolean isMaxIncluded) {
        return new NumberRange<Double>(Double.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    NumberRange(Class<T> type, Comparable<T> minimum, Comparable<T> maximum) throws IllegalArgumentException {
        super(type, (Number)((Object)minimum), (Number)((Object)maximum));
    }

    public NumberRange(Class<T> type, T minimum, T maximum) {
        super(type, minimum, maximum);
    }

    public NumberRange(Class<T> type, T minimum, boolean isMinIncluded, T maximum, boolean isMaxIncluded) {
        super(type, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    NumberRange(Class<T> type, Range<? extends Number> range) throws IllegalArgumentException {
        this(type, ClassChanger.cast(range.getMinValue(), type), range.isMinIncluded(), ClassChanger.cast(range.getMaxValue(), type), range.isMaxIncluded());
    }

    public NumberRange(Range<T> range) {
        super(range.getElementClass(), (Number)range.getMinValue(), range.isMinIncluded(), (Number)range.getMaxValue(), range.isMaxIncluded());
    }

    @Override
    NumberRange<T> create(T minValue, boolean isMinIncluded, T maxValue, boolean isMaxIncluded) {
        return new NumberRange<T>(this.elementClass, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    @Override
    void checkElementClass() throws IllegalArgumentException {
        NumberRange.ensureNumberClass(this.elementClass);
    }

    private static Class<? extends Number> getElementClass(Range<?> range) throws IllegalArgumentException {
        NumberRange.ensureNonNull("range", range);
        Class type = range.elementClass;
        NumberRange.ensureNumberClass(type);
        Class result = type;
        return result;
    }

    private static void ensureNumberClass(Class<?> type) throws IllegalArgumentException {
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(MessageFormat.format("Class '{0}' is illegal. It must be '{1}' or a derivated class.", type, Number.class));
        }
    }

    public static <N extends Number> NumberRange<N> wrap(Range<N> range) {
        if (range instanceof NumberRange) {
            NumberRange cast = (NumberRange)range;
            return cast;
        }
        return new NumberRange<N>(range);
    }

    <N extends Number> NumberRange<N> convertAndCast(Range<? extends Number> range, Class<N> type) throws IllegalArgumentException {
        if (type.equals(range.getElementClass())) {
            NumberRange<? extends Number> cast = NumberRange.wrap(range);
            return cast;
        }
        return new NumberRange<N>(type, range);
    }

    public <N extends Number> NumberRange<N> castTo(Class<N> type) throws IllegalArgumentException {
        return this.convertAndCast(this, type);
    }

    NumberRange<T>[] newArray(int length) {
        return new NumberRange[length];
    }

    public boolean contains(Number value) throws IllegalArgumentException {
        if (value != null && !(value instanceof Comparable)) {
            throw new IllegalArgumentException(MessageFormat.format("{0} is not a comparable class.", value.getClass()));
        }
        return this.contains((Comparable)((Object)value));
    }

    @Override
    public boolean contains(Comparable<?> value) throws IllegalArgumentException {
        if (value == null) {
            return false;
        }
        NumberRange.ensureNumberClass(value.getClass());
        Number number = (Number)((Object)value);
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, number.getClass());
        number = ClassChanger.cast(number, type);
        boolean contains = this.castTo(type).containsNC((Comparable)((Object)number));
        return contains;
    }

    @Override
    public boolean contains(Range<?> range) {
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, NumberRange.getElementClass(range));
        range = this.convertAndCast(range, type);
        return this.castTo(type).containsNC(range);
    }

    @Override
    public boolean intersects(Range<?> range) {
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, NumberRange.getElementClass(range));
        range = this.convertAndCast(range, type);
        return this.castTo(type).intersectsNC(range);
    }

    @Override
    public NumberRange<?> union(Range<?> range) {
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, NumberRange.getElementClass(range));
        range = this.convertAndCast(range, type);
        return (NumberRange)this.castTo(type).unionNC(range);
    }

    @Override
    public NumberRange<?> intersect(Range<?> range) {
        Class<Number> rangeType = NumberRange.getElementClass(range);
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, rangeType);
        range = this.castTo(type).intersectNC(this.convertAndCast(range, type));
        type = ClassChanger.getFinestClass(this.elementClass, rangeType);
        if (range.minValue != null) {
            type = ClassChanger.getWidestClass(type, ClassChanger.getFinestClass(((Number)range.minValue).doubleValue()));
        }
        if (range.maxValue != null) {
            type = ClassChanger.getWidestClass(type, ClassChanger.getFinestClass(((Number)range.maxValue).doubleValue()));
        }
        return this.convertAndCast(range, type);
    }

    public NumberRange<?>[] subtract(Range<?> range) {
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, NumberRange.getElementClass(range));
        return (NumberRange[])this.castTo(type).subtractNC(this.convertAndCast(range, type));
    }

    public double getMinimum() {
        Number value = (Number)this.getMinValue();
        return value != null ? value.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinimum(boolean inclusive) {
        double value = this.getMinimum();
        if (inclusive != this.isMinIncluded()) {
            value = XMath.rool(this.getElementClass(), value, inclusive ? 1 : -1);
        }
        return value;
    }

    public double getMaximum() {
        Number value = (Number)this.getMaxValue();
        return value != null ? value.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaximum(boolean inclusive) {
        double value = this.getMaximum();
        if (inclusive != this.isMaxIncluded()) {
            value = XMath.rool(this.getElementClass(), value, inclusive ? -1 : 1);
        }
        return value;
    }
}

