/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;

public class MultiPointTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;

    public MultiPointTypeBinding(GeometryFactory gFactory) {
        this.gFactory = gFactory;
    }

    @Override
    public QName getTarget() {
        return GML.MultiPointType;
    }

    public Class getType() {
        return MultiPoint.class;
    }

    @Override
    public int getExecutionMode() {
        return 1;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ArrayList<Point> points = new ArrayList<Point>();
        if (node.hasChild(Point.class)) {
            points.addAll(node.getChildValues(Point.class));
        }
        if (node.hasChild(Point[].class)) {
            Point[] p;
            for (Point point : p = node.getChildValue(Point[].class)) {
                points.add(point);
            }
        }
        return this.gFactory.createMultiPoint(points.toArray(new Point[points.size()]));
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if ("pointMember".equals(name.getLocalPart())) {
            MultiPoint multiPoint = (MultiPoint)object;
            Point[] members = new Point[multiPoint.getNumGeometries()];
            for (int i = 0; i < members.length; ++i) {
                members[i] = (Point)multiPoint.getGeometryN(i);
            }
            GML3EncodingUtils.setChildIDs((Geometry)multiPoint);
            return members;
        }
        return null;
    }
}

