/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.Logging;

public final class StreetsideURL {
    public static final int MAX_RETURN = 500;
    private static final Logger LOGGER = Logger.getLogger(StreetsideURL.class.getCanonicalName());
    private static final String STREETSIDE_BASE_URL = "https://dev.virtualearth.net/REST/v1/Imagery/MetaData/Streetside";
    private static final String STREETSIDE_PRIVACY_URL = "https://www.bing.com/maps/privacyreport/streetsideprivacyreport?bubbleid=";
    private static final int OSM_BBOX_NORTH = 3;
    private static final int OSM_BBOX_SOUTH = 1;
    private static final int OSM_BBOXEAST = 2;
    private static final int OSM_BBOX_WEST = 0;

    private StreetsideURL() {
    }

    static String queryStreetsideBoundsString(Map<String, String> parts) {
        StringBuilder ret = new StringBuilder(100);
        if (parts != null) {
            ret.append("?count=").append(500).append("&key=").append(StreetsideProperties.BING_MAPS_KEY.get());
            if (parts.containsKey("bbox")) {
                String[] bbox = parts.get("bbox").split(",");
                ret.append("&mapArea=").append(bbox[1]).append(',').append(bbox[0]).append(',').append(bbox[3]).append(',').append(bbox[2]);
            }
        }
        return ret.toString();
    }

    static URL string2URL(String ... strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; strings != null && i < strings.length; ++i) {
            builder.append(strings[i]);
        }
        try {
            return new URI(builder.toString()).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            LOGGER.log(Logging.LEVEL_ERROR, e, () -> MessageFormat.format("The class ''{0}'' produces malformed URLs like ''{1}''!", StreetsideURL.class.getName(), builder));
            return null;
        }
    }

    public static final class MainWebsite {
        private MainWebsite() {
        }

        public static URL browseImage(ILatLon image) {
            if (image == null || !image.isLatLonKnown()) {
                throw new IllegalArgumentException("The image and image lat/lon may not be null!");
            }
            return StreetsideURL.string2URL("https://www.bing.com/maps?lvl=16&style=x&cp=", Double.toString(image.lat()), "~", Double.toString(image.lon()));
        }

        public static URL streetsidePrivacyLink(String id) {
            if (id == null) {
                throw new IllegalArgumentException("The image id must not be null!");
            }
            String urlEncodedId = URLEncoder.encode(id, StandardCharsets.UTF_8);
            return StreetsideURL.string2URL(StreetsideURL.STREETSIDE_PRIVACY_URL, urlEncodedId);
        }
    }

    public static final class APIv3 {
        private APIv3() {
        }

        public static URL searchStreetsideImages(Bounds bounds) {
            return StreetsideURL.string2URL(StreetsideURL.STREETSIDE_BASE_URL, APIv3.queryStreetsideString(bounds));
        }

        public static URL parseNextFromLinkHeaderValue(String value) {
            if (value != null) {
                for (String link : value.split(",", Integer.MAX_VALUE)) {
                    boolean isNext = false;
                    URL url = null;
                    for (String linkPart : link.split(";", Integer.MAX_VALUE)) {
                        linkPart = linkPart.trim();
                        isNext |= linkPart.matches("rel\\s*=\\s*\"next\"");
                        if (linkPart.length() < 1 || linkPart.charAt(0) != '<' || !linkPart.endsWith(">")) continue;
                        try {
                            url = new URI(linkPart.substring(1, linkPart.length() - 1)).toURL();
                        }
                        catch (MalformedURLException | URISyntaxException e) {
                            Logging.log((Level)Logging.LEVEL_WARN, (String)"Mapillary API v3 returns a malformed URL in the Link header.", (Throwable)e);
                        }
                    }
                    if (url == null || !isNext) continue;
                    return url;
                }
            }
            return null;
        }

        public static String queryStreetsideString(Bounds bounds) {
            if (bounds != null) {
                HashMap<String, String> parts = new HashMap<String, String>();
                parts.put("bbox", bounds.toBBox().toStringCSV(","));
                return StreetsideURL.queryStreetsideBoundsString(parts);
            }
            return StreetsideURL.queryStreetsideBoundsString(null);
        }
    }
}

