/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.streetside.CubeMapTileXY;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.actions.WalkListener;
import org.openstreetmap.josm.plugins.streetside.actions.WalkThread;
import org.openstreetmap.josm.plugins.streetside.cache.StreetsideCache;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideImageDisplay;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsidePreferenceSetting;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ImageInfoHelpPopup;
import org.openstreetmap.josm.plugins.streetside.utils.GraphicsUtils;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public final class StreetsideMainDialog
extends ToggleDialog
implements ICachedLoaderListener,
StreetsideDataListener {
    public static final String BASE_TITLE = I18n.marktr((String)"Microsoft Streetside image");
    private static final long serialVersionUID = 2645654786827812861L;
    private static final Logger LOGGER = Logger.getLogger(StreetsideMainDialog.class.getCanonicalName());
    private static final String MESSAGE_SEPARATOR = " \u2014 ";
    private static StreetsideMainDialog instance;
    public final SideButton redButton = new SideButton((Action)new RedAction());
    public final SideButton blueButton = new SideButton((Action)new BlueAction());
    private final SideButton nextButton = new SideButton((Action)new NextPictureAction());
    private final SideButton previousButton = new SideButton((Action)new PreviousPictureAction());
    private final SideButton playButton = new SideButton((Action)new PlayAction());
    private final SideButton pauseButton = new SideButton((Action)new PauseAction());
    private final SideButton stopButton = new SideButton((Action)new StopAction());
    public final StreetsideImageDisplay streetsideImageDisplay;
    public StreetsideCache thumbnailCache;
    private StreetsideAbstractImage image;
    private long lastRenderedImageHash;
    private ImageInfoHelpPopup imageInfoHelp;
    private final Map<CubeMapTileXY, StreetsideCache> imageCache = new HashMap<CubeMapTileXY, StreetsideCache>();

    private StreetsideMainDialog() {
        super(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]), "streetside-main", I18n.tr((String)"Open Streetside window", (Object[])new Object[0]), null, 200, true, StreetsidePreferenceSetting.class);
        this.addShortcuts();
        this.streetsideImageDisplay = new StreetsideImageDisplay();
        this.blueButton.setForeground(Color.BLUE);
        this.redButton.setForeground(Color.RED);
        this.setMode(MODE.NORMAL);
    }

    public static synchronized StreetsideMainDialog getInstance() {
        if (instance == null) {
            instance = new StreetsideMainDialog();
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }

    private void addShortcuts() {
        this.nextButton.getInputMap(2).put(KeyStroke.getKeyStroke("PAGE_DOWN"), "next");
        this.nextButton.getActionMap().put("next", new NextPictureAction());
        this.previousButton.getInputMap(2).put(KeyStroke.getKeyStroke("PAGE_UP"), "previous");
        this.previousButton.getActionMap().put("previous", new PreviousPictureAction());
        this.blueButton.getInputMap(2).put(KeyStroke.getKeyStroke("control PAGE_UP"), "blue");
        this.blueButton.getActionMap().put("blue", new BlueAction());
        this.redButton.getInputMap(2).put(KeyStroke.getKeyStroke("control PAGE_DOWN"), "red");
        this.redButton.getActionMap().put("red", new RedAction());
    }

    public synchronized void setImageInfoHelp(ImageInfoHelpPopup popup) {
        this.imageInfoHelp = popup;
    }

    public void setMode(MODE mode) {
        switch (mode.ordinal()) {
            case 1: {
                this.createLayout(this.streetsideImageDisplay, Arrays.asList(this.playButton, this.pauseButton, this.stopButton));
                break;
            }
            default: {
                this.createLayout(this.streetsideImageDisplay, Arrays.asList(this.blueButton, this.previousButton, this.nextButton, this.redButton));
            }
        }
        this.disableAllButtons();
        if (MODE.NORMAL == mode) {
            this.updateImage();
        }
        this.revalidate();
        this.repaint();
    }

    public synchronized void updateImage() {
        this.updateImage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateImage(boolean fullQuality) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateImage);
        } else {
            Object object;
            if (!StreetsideLayer.hasInstance()) {
                return;
            }
            if (this.image == null) {
                this.streetsideImageDisplay.setImage(null);
                this.setTitle(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]));
                return;
            }
            if (this.imageInfoHelp != null && StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.get() > 0 && this.imageInfoHelp.showPopup()) {
                StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.put(Integer.valueOf(StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.get() - 1));
            }
            if ((object = this.image) instanceof StreetsideImage) {
                StreetsideImage streetsideImage = (StreetsideImage)object;
                this.streetsideImageDisplay.setImage(null);
                if (this.thumbnailCache != null) {
                    this.thumbnailCache.cancelOutstandingTasks();
                }
                this.thumbnailCache = new StreetsideCache(streetsideImage.getThumbnail());
                try {
                    this.thumbnailCache.submit(this, false);
                }
                catch (IOException e) {
                    LOGGER.log(Logging.LEVEL_ERROR, e.getMessage(), e);
                }
                if (fullQuality) {
                    object = this.imageCache;
                    synchronized (object) {
                        this.imageCache.values().forEach(JCSCachedTileLoaderJob::cancelOutstandingTasks);
                        this.imageCache.clear();
                        this.imageCache.putAll(streetsideImage.getFaceTiles(CubemapUtils.CubemapFaces.FRONT, streetsideImage.zoomMax()).collect(Collectors.toMap(p -> (CubeMapTileXY)p.a, p -> new StreetsideCache((String)p.b))));
                        for (StreetsideCache cache : this.imageCache.values()) {
                            try {
                                cache.submit(this, false);
                            }
                            catch (IOException e) {
                                LOGGER.log(Logging.LEVEL_ERROR, e.getMessage(), e);
                            }
                        }
                    }
                }
            }
            this.updateTitle();
        }
    }

    private void disableAllButtons() {
        this.nextButton.setEnabled(false);
        this.previousButton.setEnabled(false);
        this.blueButton.setEnabled(false);
        this.redButton.setEnabled(false);
    }

    public synchronized void updateTitle() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateTitle);
        } else if (this.image != null) {
            StringBuilder title = new StringBuilder(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]));
            if (this.image instanceof StreetsideImage) {
                title.append(MESSAGE_SEPARATOR).append(MessageFormat.format("(heading {0}\u00b0)", Double.toString(this.image.heading())));
                this.setTitle(title.toString());
            }
        }
    }

    public synchronized StreetsideAbstractImage getImage() {
        return this.image;
    }

    public synchronized void setImage(StreetsideAbstractImage image) {
        this.image = image;
        this.lastRenderedImageHash = Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadingFinished(CacheEntry data, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.loadingFinished(data, attributes, result));
        } else if (data != null && result == ICachedLoaderListener.LoadResult.SUCCESS) {
            try {
                BufferedImage img;
                if (data instanceof BufferedImageCacheEntry) {
                    BufferedImageCacheEntry bufferedData = (BufferedImageCacheEntry)data;
                    v0 = bufferedData.getImage();
                } else {
                    v0 = img = ImageIO.read(new ByteArrayInputStream(data.getContent()));
                }
                if (img == null) {
                    return;
                }
                Map<CubeMapTileXY, StreetsideCache> map = this.imageCache;
                synchronized (map) {
                    if (this.imageCache.isEmpty() || this.imageCache.size() == 1 || this.imageCache.containsKey(null)) {
                        this.streetsideImageDisplay.setImage(img);
                        return;
                    }
                    HashMap<CubeMapTileXY, BufferedImage> images = new HashMap<CubeMapTileXY, BufferedImage>(this.imageCache.size());
                    for (Map.Entry<CubeMapTileXY, StreetsideCache> entry : this.imageCache.entrySet()) {
                        images.put(entry.getKey(), Optional.ofNullable(entry.getValue()).map(JCSCachedTileLoaderJob::get).map(e -> {
                            try {
                                return e.getImage();
                            }
                            catch (IOException exception) {
                                Logging.trace((Throwable)exception);
                                return null;
                            }
                        }).orElse(null));
                    }
                    if (images.containsValue(null)) {
                        return;
                    }
                    if (this.lastRenderedImageHash != (long)images.hashCode()) {
                        this.lastRenderedImageHash = images.hashCode();
                        BufferedImage fullImage = GraphicsUtils.buildMultiTiledCubemapFaceImage(images, (int)Math.round(Math.log(images.size()) / Math.log(4.0)));
                        this.streetsideImageDisplay.setImage(fullImage);
                    }
                }
            }
            catch (IOException e2) {
                LOGGER.log(Logging.LEVEL_ERROR, e2.getMessage(), e2);
            }
        }
    }

    public void createLayout(Component data, List<SideButton> buttons) {
        this.removeAll();
        this.createLayout(data, true, buttons);
        this.add((Component)this.titleBar, "North");
    }

    @Override
    public void selectedImageChanged(StreetsideImage oldImage, StreetsideImage newImage) {
        this.setImage(newImage);
        if (newImage != null) {
            if (StreetsideLayer.getInstance().getData().next(newImage) != null) {
                this.nextButton.setEnabled(true);
            }
            if (StreetsideLayer.getInstance().getData().previous(newImage) != null) {
                this.previousButton.setEnabled(true);
            }
        }
        this.updateImage();
    }

    @Override
    public void imagesAdded() {
    }

    public StreetsideImageDisplay getStreetsideImageDisplay() {
        return this.streetsideImageDisplay;
    }

    private static class RedAction
    extends AbstractAction {
        private static final long serialVersionUID = -1244456062285831231L;

        RedAction() {
            this.putValue("Name", I18n.tr((String)"Jump to red", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the picture at the other side of the red line", (Object[])new Object[0]));
            new ImageProvider("dialogs", "red").getResource().attachImageIcon((AbstractAction)this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StreetsideMainDialog.getInstance().getImage() != null) {
                StreetsideLayer.getInstance().getData().setSelectedImage(StreetsideLayer.getInstance().getNNearestImage(1), true);
            }
        }
    }

    private static class BlueAction
    extends AbstractAction {
        private static final long serialVersionUID = 5951233534212838780L;

        BlueAction() {
            this.putValue("Name", I18n.tr((String)"Jump to blue", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the picture at the other side of the blue line", (Object[])new Object[0]));
            new ImageProvider("dialogs", "blue").getResource().attachImageIcon((AbstractAction)this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StreetsideMainDialog.getInstance().getImage() != null) {
                StreetsideLayer.getInstance().getData().setSelectedImage(StreetsideLayer.getInstance().getNNearestImage(2), true);
            }
        }
    }

    private static class NextPictureAction
    extends AbstractAction {
        private static final long serialVersionUID = 6333692154558730392L;

        NextPictureAction() {
            super(I18n.tr((String)"Next picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the next picture in the sequence", (Object[])new Object[0]));
            new ImageProvider("help", "next").getResource().attachImageIcon((AbstractAction)this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StreetsideLayer.getInstance().getData().selectNext();
        }
    }

    private static class PreviousPictureAction
    extends AbstractAction {
        private static final long serialVersionUID = 4390593660514657107L;

        PreviousPictureAction() {
            super(I18n.tr((String)"Previous picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the previous picture in the sequence", (Object[])new Object[0]));
            new ImageProvider("help", "previous").getResource().attachImageIcon((AbstractAction)this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StreetsideLayer.getInstance().getData().selectPrevious();
        }
    }

    private static class PlayAction
    extends AbstractAction
    implements WalkListener {
        private static final long serialVersionUID = -1572747020946842769L;
        private transient WalkThread thread;

        PlayAction() {
            this.putValue("Name", I18n.tr((String)"Play", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Continues with the paused walk.", (Object[])new Object[0]));
            new ImageProvider("dialogs/streetsidePlay.png").getResource().attachImageIcon((AbstractAction)this, true);
            StreetsidePlugin.getStreetsideWalkAction().addListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.thread != null) {
                this.thread.play();
            }
        }

        @Override
        public void walkStarted(WalkThread thread) {
            if (thread != null) {
                this.thread = thread;
            }
        }
    }

    private static class PauseAction
    extends AbstractAction
    implements WalkListener {
        private static final long serialVersionUID = -8758326399460817222L;
        private WalkThread thread;

        PauseAction() {
            this.putValue("Name", I18n.tr((String)"Pause", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Pauses the walk.", (Object[])new Object[0]));
            new ImageProvider("dialogs/streetsidePause.png").getResource().attachImageIcon((AbstractAction)this, true);
            StreetsidePlugin.getStreetsideWalkAction().addListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.thread.pause();
        }

        @Override
        public void walkStarted(WalkThread thread) {
            this.thread = thread;
        }
    }

    private static class StopAction
    extends AbstractAction
    implements WalkListener {
        private static final long serialVersionUID = 8789972456611625341L;
        private WalkThread thread;

        StopAction() {
            this.putValue("Name", I18n.tr((String)"Stop", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Stops the walk.", (Object[])new Object[0]));
            new ImageProvider("dialogs/streetsideStop.png").getResource().attachImageIcon((AbstractAction)this, true);
            StreetsidePlugin.getStreetsideWalkAction().addListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.thread != null) {
                this.thread.stopWalk();
            }
        }

        @Override
        public void walkStarted(WalkThread thread) {
            this.thread = thread;
        }
    }

    public static enum MODE {
        NORMAL,
        WALK;

    }
}

